/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.diff;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import stanford.cs106.gui.GuiUtils;

public class DiffImage
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 0L;
    private BufferedImage image1;
    private BufferedImage image2;
    private String image1name;
    private int numDiffPixels;
    private int opacity = 50;
    private String label1Text = "Expected";
    private String label2Text = "Actual";
    private boolean highlightDiffs = false;
    private Color highlightColor = new Color(224, 0, 224);
    private JLabel image1Label;
    private JLabel image2Label;
    private JLabel diffPixelsLabel;
    private JSlider slider;
    private JCheckBox box;
    private JMenuItem saveAsItem;
    private JMenuItem setImage1Item;
    private JMenuItem setImage2Item;
    private JFrame frame;
    private JButton colorButton;

    public DiffImage(Image image1, Image image2) throws IOException {
        this.setImage1(this.toBufferedImage(image1));
        this.setImage2(this.toBufferedImage(image2));
        this.display();
    }

    private BufferedImage toBufferedImage(Image img) {
        BufferedImage bimage = new BufferedImage(img.getWidth(this), img.getHeight(this), 1);
        bimage.getGraphics().drawImage(img, 0, 0, this);
        return bimage;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.box) {
            this.highlightDiffs = this.box.isSelected();
            this.repaint();
        } else if (source == this.colorButton) {
            Color color = JColorChooser.showDialog(this.frame, "Choose highlight color", this.highlightColor);
            if (color != null) {
                this.highlightColor = color;
                this.colorButton.setBackground(color);
                this.colorButton.setForeground(color);
                this.repaint();
            }
        } else if (source == this.saveAsItem) {
            this.saveAs();
        } else if (source == this.setImage1Item) {
            this.setImage1();
        } else if (source == this.setImage2Item) {
            this.setImage2();
        }
    }

    public void countDiffPixels() {
        if (this.image1 == null || this.image2 == null) {
            return;
        }
        int w1 = this.image1.getWidth();
        int h1 = this.image1.getHeight();
        int w2 = this.image2.getWidth();
        int h2 = this.image2.getHeight();
        int wmax = Math.max(w1, w2);
        int hmax = Math.max(h1, h2);
        this.numDiffPixels = 0;
        int y = 0;
        while (y < hmax) {
            int x = 0;
            while (x < wmax) {
                int pixel2;
                int pixel1 = x < w1 && y < h1 ? this.image1.getRGB(x, y) : 0;
                int n = pixel2 = x < w2 && y < h2 ? this.image2.getRGB(x, y) : 0;
                if (pixel1 != pixel2) {
                    ++this.numDiffPixels;
                }
                ++x;
            }
            ++y;
        }
    }

    public void display() {
        this.countDiffPixels();
        this.setupComponents();
        this.setupEvents();
        this.setupLayout();
        this.frame.pack();
        GuiUtils.centerWindow(this.frame);
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    public void drawImageFull(Graphics2D g2, BufferedImage image) {
        int iw = image.getWidth();
        int ih = image.getHeight();
        int w = this.getWidth();
        int h = this.getHeight();
        int dw = w - iw;
        int dh = h - ih;
        if (dw > 0) {
            g2.fillRect(iw, 0, dw, ih);
        }
        if (dh > 0) {
            g2.fillRect(0, ih, iw, dh);
        }
        if (dw > 0 && dh > 0) {
            g2.fillRect(iw, ih, dw, dh);
        }
        g2.drawImage((Image)image, 0, 0, this);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.image1 != null) {
            this.drawImageFull(g2, this.image1);
        }
        if (this.image2 != null) {
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(10, (float)this.opacity / 100.0f));
            this.drawImageFull(g2, this.image2);
            g2.setComposite(oldComposite);
        }
        g2.setColor(Color.BLACK);
        if (this.highlightDiffs && this.image1 != null && this.image2 != null) {
            int w1 = this.image1.getWidth();
            int h1 = this.image1.getHeight();
            int w2 = this.image2.getWidth();
            int h2 = this.image2.getHeight();
            int wmax = Math.max(w1, w2);
            int hmax = Math.max(h1, h2);
            g2.setColor(this.highlightColor);
            int y = 0;
            while (y < hmax) {
                int x = 0;
                while (x < wmax) {
                    int pixel2;
                    int pixel1 = x < w1 && y < h1 ? this.image1.getRGB(x, y) : 0;
                    int n = pixel2 = x < w2 && y < h2 ? this.image2.getRGB(x, y) : 0;
                    if (pixel1 != pixel2) {
                        g2.fillRect(x, y, 1, 1);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    public void save(File file) throws IOException {
        String filename = file.getName();
        String extension = filename.substring(filename.lastIndexOf(".") + 1);
        BufferedImage img = new BufferedImage(this.getPreferredSize().width, this.getPreferredSize().height, 2);
        img.getGraphics().setColor(this.getBackground());
        img.getGraphics().fillRect(0, 0, img.getWidth(), img.getHeight());
        this.paintComponent(img.getGraphics());
        ImageIO.write((RenderedImage)img, extension, file);
    }

    public void save(String filename) throws IOException {
        this.save(new File(filename));
    }

    public void saveAs() {
    }

    public void setImage1() {
    }

    public void setImage1(BufferedImage image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image1 = image;
        this.setPreferredSize(new Dimension(Math.max(this.getPreferredSize().width, image.getWidth()), Math.max(this.getPreferredSize().height, image.getHeight())));
        if (this.frame != null) {
            this.frame.pack();
        }
        this.repaint();
    }

    public void setImage1(String filename) throws IOException {
        this.image1name = new File(filename).getName();
        if (filename.startsWith("http")) {
            this.setImage1(ImageIO.read(new URL(filename)));
        } else {
            this.setImage1(ImageIO.read(new File(filename)));
        }
    }

    public void setImage2() {
    }

    public void setImage2(BufferedImage image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image2 = image;
        this.setPreferredSize(new Dimension(Math.max(this.getPreferredSize().width, image.getWidth()), Math.max(this.getPreferredSize().height, image.getHeight())));
        if (this.frame != null) {
            this.frame.pack();
        }
        this.repaint();
    }

    public void setImage2(String filename) throws IOException {
        if (filename.startsWith("http")) {
            this.setImage2(ImageIO.read(new URL(filename)));
        } else {
            this.setImage2(ImageIO.read(new File(filename)));
        }
    }

    private void setupComponents() {
        String title = "DiffImage";
        if (this.image1name != null) {
            title = "Compare to " + this.image1name;
        }
        this.frame = new JFrame(title);
        this.frame.setResizable(false);
        this.slider = new JSlider();
        this.slider.setPaintLabels(false);
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.setMajorTickSpacing(25);
        this.slider.setMinorTickSpacing(5);
        this.box = new JCheckBox("Highlight diffs in color: ", this.highlightDiffs);
        this.colorButton = new JButton("X");
        this.colorButton.setBackground(this.highlightColor);
        this.colorButton.setForeground(this.highlightColor);
        this.colorButton.setPreferredSize(new Dimension(24, 24));
        this.diffPixelsLabel = new JLabel("(" + this.numDiffPixels + " pixels differ)");
        this.diffPixelsLabel.setFont(this.diffPixelsLabel.getFont().deriveFont(1));
        this.image1Label = new JLabel(this.label1Text);
        this.image2Label = new JLabel(this.label2Text);
        this.setupMenuBar();
    }

    private void setupLayout() {
        JPanel southPanel1 = new JPanel();
        southPanel1.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        southPanel1.add(this.image1Label);
        southPanel1.add(this.slider);
        southPanel1.add(this.image2Label);
        southPanel1.add(Box.createHorizontalStrut(20));
        JPanel southPanel2 = new JPanel();
        southPanel2.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        southPanel2.add(this.diffPixelsLabel);
        southPanel2.add(Box.createHorizontalStrut(20));
        southPanel2.add(this.box);
        southPanel2.add(this.colorButton);
        Box southPanel = Box.createVerticalBox();
        southPanel.add(southPanel1);
        southPanel.add(southPanel2);
        this.frame.add((Component)this, "Center");
        this.frame.add((Component)southPanel, "South");
    }

    private void setupMenuBar() {
        this.saveAsItem = new JMenuItem("Save As...", 65);
        this.saveAsItem.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
        this.setImage1Item = new JMenuItem("Set Image 1...", 49);
        this.setImage1Item.setAccelerator(KeyStroke.getKeyStroke("ctrl 1"));
        this.setImage2Item = new JMenuItem("Set Image 2...", 50);
        this.setImage2Item.setAccelerator(KeyStroke.getKeyStroke("ctrl 2"));
        JMenu file = new JMenu("File");
        file.setMnemonic('F');
        file.add(this.setImage1Item);
        file.add(this.setImage2Item);
        file.addSeparator();
        file.add(this.saveAsItem);
        JMenuBar bar = new JMenuBar();
        bar.add(file);
    }

    public void stateChanged(ChangeEvent e) {
        this.opacity = this.slider.getValue();
        this.repaint();
    }

    private void setupEvents() {
        this.slider.addChangeListener(this);
        this.box.addActionListener(this);
        this.colorButton.addActionListener(this);
        this.saveAsItem.addActionListener(this);
        this.setImage1Item.addActionListener(this);
        this.setImage2Item.addActionListener(this);
    }
}

