/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.audio;

import stanford.cs106.audio.Accidental;
import stanford.cs106.audio.Pitch;
import stanford.cs106.audio.StdAudio;

public class Note {
    public static final int OCTAVE_MIN = 1;
    public static final int OCTAVE_MAX = 10;
    public static boolean DEBUG = true;
    private double duration;
    private Pitch pitch;
    private int octave;
    private Accidental accidental;
    private boolean repeat;

    public Note(double duration, Pitch pitch, int octave, Accidental accidental, boolean repeat) {
        this.setPitch(pitch);
        this.setAccidental(accidental);
        this.setDuration(duration);
        this.setOctave(octave);
        this.repeat = repeat;
    }

    public Note(double duration, boolean repeat) {
        this(duration, Pitch.R, 2, Accidental.NATURAL, repeat);
    }

    public boolean equals(Object o) {
        if (o instanceof Note) {
            Note other = (Note)o;
            if (this.pitch == Pitch.R && other.pitch == Pitch.R) {
                return this.duration == other.duration && this.pitch == other.pitch && this.repeat == other.repeat;
            }
            return this.duration == other.duration && this.pitch == other.pitch && this.octave == other.octave && this.accidental == other.accidental && this.repeat == other.repeat;
        }
        return false;
    }

    public Accidental getAccidental() {
        return this.accidental;
    }

    public double getDuration() {
        return this.duration;
    }

    public int getOctave() {
        return this.octave;
    }

    public Pitch getPitch() {
        return this.pitch;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public boolean isRest() {
        return this.pitch == Pitch.R;
    }

    public void play() {
        if (DEBUG) {
            System.out.println("  - playing " + this.duration + " " + (Object)((Object)this.pitch) + (this.pitch == Pitch.R ? "" : " " + this.octave + " " + (Object)((Object)this.accidental)));
        }
        if (this.pitch == Pitch.R) {
            StdAudio.play(this, StdAudio.note(0.0, this.duration, 0.5), this.duration);
        } else {
            char note = this.pitch.toString().charAt(0);
            int steps = (note - 65) * 2;
            if (note == 'C' || note == 'D' || note == 'E') {
                --steps;
            } else if (note == 'F' || note == 'G') {
                steps -= 2;
            }
            steps = this.octave > 4 || this.octave == 4 && note <= 'B' ? (steps += (this.octave - 4) * 12) : (steps -= (4 - this.octave) * 12);
            if (note != 'A' && note != 'B') {
                steps -= 12;
            }
            if (this.accidental.equals((Object)Accidental.SHARP)) {
                ++steps;
            } else if (this.accidental.equals((Object)Accidental.FLAT)) {
                --steps;
            }
            double hz = 440.0 * Math.pow(2.0, (double)steps / 12.0);
            StdAudio.play(this, StdAudio.note(hz, this.duration, 0.5), this.duration);
        }
    }

    public void setAccidental(Accidental accidental) {
        if (accidental == null) {
            throw new NullPointerException();
        }
        if (this.pitch != Pitch.R) {
            this.accidental = accidental;
        }
    }

    public void setDuration(double duration) {
        if (duration < 0.0) {
            throw new IllegalArgumentException();
        }
        this.duration = duration;
    }

    public void setOctave(int octave) {
        if (octave < 1 || octave > 10) {
            throw new IllegalArgumentException("Illegal octave value: " + octave);
        }
        if (this.pitch != Pitch.R) {
            this.octave = octave;
        }
    }

    public void setPitch(Pitch pitch) {
        if (pitch == null) {
            throw new NullPointerException();
        }
        this.pitch = pitch;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public String toString() {
        if (this.pitch == Pitch.R) {
            return String.valueOf(this.duration) + " " + (Object)((Object)this.pitch) + " " + this.repeat;
        }
        return String.valueOf(this.duration) + " " + (Object)((Object)this.pitch) + " " + this.octave + " " + (Object)((Object)this.accidental) + " " + this.repeat;
    }
}

