/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.diff;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffCollection {
    protected Object[] a;
    protected Object[] b;
    protected List<Difference> diffs = new ArrayList<Difference>();
    private Difference pending;
    private TreeMap<Integer, Integer> thresh;

    public DiffCollection(Object[] a, Object[] b) {
        this.a = a;
        this.b = b;
        this.thresh = null;
    }

    public List<Difference> diff() {
        this.traverseSequences();
        if (this.pending != null) {
            this.diffs.add(this.pending);
        }
        return this.diffs;
    }

    /*
     * Unable to fully structure code
     */
    protected void traverseSequences() {
        matches = this.getLongestCommonSubsequences();
        lastA = this.a.length - 1;
        lastB = this.b.length - 1;
        bi = 0;
        lastMatch = matches.length - 1;
        ai = 0;
        while (ai <= lastMatch) {
            block6: {
                bLine = matches[ai];
                if (bLine != null) ** GOTO lbl13
                this.onANotB(ai, bi);
                break block6;
lbl-1000:
                // 1 sources

                {
                    this.onBNotA(ai, bi++);
lbl13:
                    // 2 sources

                    ** while (bi < bLine.intValue())
                }
            }
            ++ai;
        }
        calledFinishA = false;
        calledFinishB = false;
        while (ai <= lastA || bi <= lastB) {
            block8: {
                block7: {
                    if (ai != lastA + 1 || bi > lastB) break block7;
                    if (calledFinishA || !this.callFinishedA()) ** GOTO lbl25
                    calledFinishA = true;
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        this.onBNotA(ai, bi++);
lbl25:
                        // 2 sources

                        ** while (bi <= lastB)
                    }
                }
                if (bi != lastB + 1 || ai > lastA) break block8;
                if (calledFinishB || !this.callFinishedB()) ** GOTO lbl32
                calledFinishB = true;
                break block8;
lbl-1000:
                // 1 sources

                {
                    this.onANotB(ai++, bi);
lbl32:
                    // 2 sources

                    ** while (ai <= lastA)
                }
            }
            if (ai <= lastA) {
                this.onANotB(ai++, bi);
            }
            if (bi > lastB) continue;
            this.onBNotA(ai, bi++);
        }
    }

    protected boolean callFinishedA() {
        return false;
    }

    protected boolean callFinishedB() {
        return false;
    }

    protected void onANotB(int ai, int bi) {
        if (this.pending == null) {
            this.pending = new Difference(ai, ai, bi, -1);
        } else {
            this.pending.setDeleted(ai);
        }
    }

    protected void onBNotA(int ai, int bi) {
        if (this.pending == null) {
            this.pending = new Difference(ai, -1, bi, bi);
        } else {
            this.pending.setAdded(bi);
        }
    }

    protected boolean equals(Object x, Object y) {
        return x.equals(y);
    }

    public Integer[] getLongestCommonSubsequences() {
        List positions;
        int aStart = 0;
        int aEnd = this.a.length - 1;
        int bStart = 0;
        int bEnd = this.b.length - 1;
        TreeMap<Integer, Integer> matches = new TreeMap<Integer, Integer>();
        while (aStart <= aEnd && bStart <= bEnd && this.equals(this.a[aStart], this.b[bStart])) {
            matches.put(new Integer(aStart++), new Integer(bStart++));
        }
        while (aStart <= aEnd && bStart <= bEnd && this.equals(this.a[aEnd], this.b[bEnd])) {
            matches.put(new Integer(aEnd--), new Integer(bEnd--));
        }
        AbstractMap bMatches = null;
        bMatches = this.a.length > 0 && this.a[0] instanceof Comparable ? new TreeMap() : new HashMap();
        int bi = bStart;
        while (bi <= bEnd) {
            Object element = this.b[bi];
            Object key = element;
            positions = (ArrayList<Integer>)bMatches.get(key);
            if (positions == null) {
                positions = new ArrayList<Integer>();
                bMatches.put(key, positions);
            }
            positions.add(new Integer(bi));
            ++bi;
        }
        this.thresh = new TreeMap();
        HashMap<Integer, Integer[]> links = new HashMap<Integer, Integer[]>();
        int i = aStart;
        while (i <= aEnd) {
            Object aElement = this.a[i];
            positions = (List)bMatches.get(aElement);
            if (positions != null) {
                Integer k = new Integer(0);
                ListIterator pit = positions.listIterator(positions.size());
                while (pit.hasPrevious()) {
                    Integer j = (Integer)pit.previous();
                    k = this.insert(j, k);
                    if (k == null) continue;
                    Integer value = k - 1;
                    links.put(k, new Integer[]{value, new Integer(i), j});
                }
            }
            ++i;
        }
        if (this.thresh.size() > 0) {
            Integer ti = this.thresh.lastKey();
            Integer[] link = (Integer[])links.get(ti);
            while (link != null) {
                Integer x = link[1];
                Integer y = link[2];
                matches.put(x, y);
                link = (Integer[])links.get(link[0]);
            }
        }
        return DiffCollection.toArray(matches);
    }

    protected static Integer[] toArray(TreeMap<Integer, Integer> map) {
        int size = map.size() == 0 ? 0 : 1 + map.lastKey();
        Integer[] ary = new Integer[size];
        for (Integer idx : map.keySet()) {
            Integer val;
            ary[idx.intValue()] = val = map.get(idx);
        }
        return ary;
    }

    protected static boolean isNonzero(Integer i) {
        return i != null && i != 0;
    }

    protected boolean isGreaterThan(Integer index, Integer val) {
        Integer lhs = this.thresh.get(index);
        return lhs != null && val != null && lhs.compareTo(val) > 0;
    }

    protected boolean isLessThan(Integer index, Integer val) {
        Integer lhs = this.thresh.get(index);
        return lhs != null && (val == null || lhs.compareTo(val) < 0);
    }

    protected Integer getLastValue() {
        return this.thresh.get(this.thresh.lastKey());
    }

    protected void append(Integer value) {
        Integer addIdx = null;
        if (this.thresh.size() == 0) {
            addIdx = new Integer(0);
        } else {
            Integer lastKey = this.thresh.lastKey();
            addIdx = new Integer(lastKey + 1);
        }
        this.thresh.put(addIdx, value);
    }

    protected Integer insert(Integer j, Integer k) {
        if (DiffCollection.isNonzero(k) && this.isGreaterThan(k, j) && this.isLessThan(new Integer(k - 1), j)) {
            this.thresh.put(k, j);
        } else {
            int hi = -1;
            if (DiffCollection.isNonzero(k)) {
                hi = k;
            } else if (this.thresh.size() > 0) {
                hi = this.thresh.lastKey();
            }
            if (hi == -1 || j.compareTo(this.getLastValue()) > 0) {
                this.append(j);
                k = new Integer(hi + 1);
            } else {
                int lo = 0;
                while (lo <= hi) {
                    int index = (hi + lo) / 2;
                    Integer val = this.thresh.get(new Integer(index));
                    int cmp = j.compareTo(val);
                    if (cmp == 0) {
                        return null;
                    }
                    if (cmp > 0) {
                        lo = index + 1;
                        continue;
                    }
                    hi = index - 1;
                }
                this.thresh.put(new Integer(lo), j);
                k = new Integer(lo);
            }
        }
        return k;
    }

    public static final class Difference {
        public static final int NONE = -1;
        private int delStart = -1;
        private int delEnd = -1;
        private int addStart = -1;
        private int addEnd = -1;

        public Difference(int delStart, int delEnd, int addStart, int addEnd) {
            this.delStart = delStart;
            this.delEnd = delEnd;
            this.addStart = addStart;
            this.addEnd = addEnd;
        }

        public int getDeletedStart() {
            return this.delStart;
        }

        public int getDeletedEnd() {
            return this.delEnd;
        }

        public int getAddedStart() {
            return this.addStart;
        }

        public int getAddedEnd() {
            return this.addEnd;
        }

        public void setDeleted(int line) {
            this.delStart = Math.min(line, this.delStart);
            this.delEnd = Math.max(line, this.delEnd);
        }

        public void setAdded(int line) {
            this.addStart = Math.min(line, this.addStart);
            this.addEnd = Math.max(line, this.addEnd);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Difference) {
                Difference other = (Difference)obj;
                return this.delStart == other.delStart && this.delEnd == other.delEnd && this.addStart == other.addStart && this.addEnd == other.addEnd;
            }
            return false;
        }

        public int hashCode() {
            return this.delStart << 24 + this.delEnd << 16 + this.addStart << 8 + this.addEnd;
        }

        public String addedIndexToString() {
            return this.indexToString(this.addStart, this.addEnd);
        }

        public String deletedIndexToString() {
            return this.indexToString(this.delStart, this.delEnd);
        }

        public String indexToString(int start, int end) {
            StringBuffer buf = new StringBuffer();
            buf.append(end == -1 ? start : 1 + start);
            if (end != -1 && start != end) {
                buf.append("-").append(1 + end);
            }
            return buf.toString();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("del: [" + this.delStart + ", " + this.delEnd + "]");
            buf.append(" ");
            buf.append("add: [" + this.addStart + ", " + this.addEnd + "]");
            return buf.toString();
        }
    }
}

