/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stanford.cs106.io.IORuntimeException;
import stanford.spl.JavaBackEnd;
import stanford.spl.SplPipeDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleServer {
    private static final int DEFAULT_PORT = 8080;
    private static SimpleServer INSTANCE;
    private JavaBackEnd javaBackEnd;
    private HttpServer server;
    private int port;
    private Map<Integer, HttpExchange> requestMap = new HashMap<Integer, HttpExchange>();
    private int currentRequestID = 0;

    public static synchronized SimpleServer getInstance() {
        return SimpleServer.getInstance(8080);
    }

    public static synchronized SimpleServer getInstance(int port) {
        if (INSTANCE == null) {
            INSTANCE = new SimpleServer(port);
        }
        return INSTANCE;
    }

    public SimpleServer() {
        this(8080);
    }

    public SimpleServer(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.server != null;
    }

    public void sendResponse(int requestID, int httpErrorCode, String contentType, String responseText) {
        if (!this.requestMap.containsKey(requestID)) {
            throw new IllegalArgumentException("Unknown request ID: " + requestID);
        }
        HttpExchange exchange = this.requestMap.get(requestID);
        try {
            exchange.sendResponseHeaders(httpErrorCode, responseText.length());
            OutputStream os = exchange.getResponseBody();
            os.write(responseText.getBytes());
            os.close();
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    public void sendResponseFile(int requestID, int httpErrorCode, String contentType, String responseFilePath) {
        if (!this.requestMap.containsKey(requestID)) {
            throw new IllegalArgumentException("Unknown request ID: " + requestID);
        }
        HttpExchange exchange = this.requestMap.get(requestID);
        try {
            OutputStream os = exchange.getResponseBody();
            File file = new File(responseFilePath);
            exchange.sendResponseHeaders(httpErrorCode, file.length());
            Files.copy(file.toPath(), os);
            os.close();
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    public void setJavaBackEnd(JavaBackEnd javaBackEnd) {
        this.javaBackEnd = javaBackEnd;
    }

    public void start() {
        if (this.isRunning()) {
            this.stop();
        }
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.server.createContext("/", new BottleHandler());
            this.server.setExecutor(null);
            this.server.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.server.stop(0);
            this.server = null;
        }
    }

    public static String renderTemplate(String templatePath, Map<String, String> args) {
        try {
            Scanner htmlScanner = new Scanner(new File(templatePath));
            String html = htmlScanner.useDelimiter("\\Z").next();
            htmlScanner.close();
            if (args != null) {
                for (String key : args.keySet()) {
                    String value = args.get(key);
                    html = html.replace("{{" + key + "}}", value);
                }
            }
            String regex = "\\%include\\[(.*)]";
            Pattern includePattern = Pattern.compile(regex);
            Matcher m = includePattern.matcher(html);
            String injectedHtml = html;
            while (m.find()) {
                String includePath = m.group(1);
                String injectHtml = SimpleServer.renderTemplate(includePath, args);
                injectedHtml = injectedHtml.replace("%include[" + includePath + "]", injectHtml);
            }
            return injectedHtml;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getUriString(HttpExchange exchange) {
        URI uri = exchange.getRequestURI();
        String uriStr = uri.toString();
        return uriStr;
    }

    private class BottleHandler
    implements HttpHandler {
        private BottleHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HttpExchange exchange) throws IOException {
            String requestUrl = SimpleServer.getUriString(exchange);
            int requestID = 0;
            SimpleServer simpleServer = SimpleServer.this;
            synchronized (simpleServer) {
                SimpleServer simpleServer2 = SimpleServer.this;
                int n = simpleServer2.currentRequestID;
                simpleServer2.currentRequestID = n + 1;
                requestID = n;
                SimpleServer.this.requestMap.put(requestID, exchange);
            }
            SimpleServer.this.javaBackEnd.acknowledgeEvent("event:serverRequest(%d, %d, \"%s\")", (long)SimpleServer.this.javaBackEnd.getEventTime(), requestID, SplPipeDecoder.encode(requestUrl));
        }
    }
}

