/*
 * Decompiled with CFR 0.152.
 */
package stanford.karel;

import java.awt.Color;
import java.awt.Point;
import stanford.karel.Karel;
import stanford.karel.KarelWorld;
import stanford.karel.KarelWorldMonitor;

public class SuperKarel
extends Karel {
    public static final Color BLACK = Color.BLACK;
    public static final Color BLUE = Color.BLUE;
    public static final Color CYAN = Color.CYAN;
    public static final Color DARK_GRAY = Color.DARK_GRAY;
    public static final Color GRAY = Color.GRAY;
    public static final Color GREEN = Color.GREEN;
    public static final Color LIGHT_GRAY = Color.LIGHT_GRAY;
    public static final Color MAGENTA = Color.MAGENTA;
    public static final Color ORANGE = Color.ORANGE;
    public static final Color PINK = Color.PINK;
    public static final Color RED = Color.RED;
    public static final Color WHITE = Color.WHITE;
    public static final Color YELLOW = Color.YELLOW;

    public void run() {
    }

    public void turnRight() {
        this.checkWorld("turnRight");
        this.setDirection(KarelWorld.rightFrom(this.getDirection()));
        this.getWorld().trace();
    }

    public void turnAround() {
        this.checkWorld("turnAround");
        this.setDirection(KarelWorld.oppositeDirection(this.getDirection()));
        this.getWorld().trace();
    }

    public void paintCorner(Color color) {
        KarelWorld world = this.getWorld();
        Point pt = this.getLocation();
        this.checkWorld("paintCorner");
        world.setCornerColor(pt.x, pt.y, color);
        world.trace();
    }

    public void paintCorner(int rgb) {
        this.paintCorner(new Color(rgb));
    }

    public void paintCorner(double red, double blue, double green) {
        this.paintCorner(new Color((float)red, (float)blue, (float)green));
    }

    public Color newColor(int rgb) {
        return new Color(rgb);
    }

    public boolean random() {
        this.checkWorld("random");
        return this.random(0.5);
    }

    public boolean random(double p) {
        this.checkWorld("random");
        return Math.random() < p;
    }

    public boolean cornerColorIs(Color color) {
        KarelWorld world = this.getWorld();
        Point pt = this.getLocation();
        this.checkWorld("cornerColorIs");
        if (color == null) {
            return world.getCornerColor(pt.x, pt.y) == null;
        }
        return color.equals(world.getCornerColor(pt.x, pt.y));
    }

    public boolean cornerColorIs(int rgb) {
        return this.cornerColorIs(new Color(rgb));
    }

    public boolean cornerColorIs(double red, double blue, double green) {
        Color color = new Color((float)red, (float)blue, (float)green);
        return this.cornerColorIs(color);
    }

    public void pause(double milliseconds) {
        KarelWorld world = this.getWorld();
        boolean repaintFlag = true;
        KarelWorldMonitor monitor = world.getMonitor();
        if (monitor != null && monitor.getSpeed() > 0.98) {
            repaintFlag = false;
        }
        world.setRepaintFlag(true);
        world.repaint();
        world.setRepaintFlag(repaintFlag);
        try {
            int millis = (int)milliseconds;
            int nanos = (int)Math.round((milliseconds - (double)millis) * 1000000.0);
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

