/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GContainer;
import acm.graphics.GObject;
import acm.util.ErrorException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GIterator
implements Iterator<GObject> {
    private GContainer cont;
    private int dir;
    private int index;
    private int nElements;

    public GIterator(GContainer gContainer, int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.dir = n;
                break;
            }
            default: {
                throw new ErrorException("Illegal direction for iterator");
            }
        }
        this.cont = gContainer;
        this.index = 0;
        this.nElements = gContainer.getElementCount();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.nElements;
    }

    @Override
    public GObject next() {
        if (this.dir == 1) {
            return this.cont.getElement(this.nElements - this.index++ - 1);
        }
        return this.cont.getElement(this.index++);
    }

    public GObject nextElement() {
        return this.next();
    }

    @Override
    public void remove() {
        if (this.dir == 1) {
            this.cont.remove(this.cont.getElement(this.nElements - --this.index - 1));
        } else {
            this.cont.remove(this.cont.getElement(--this.index));
        }
        --this.nElements;
    }
}

