/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.MediaTools;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;

class ImageSaver {
    private OutputStream out;
    private String formatName;
    private int bufferType;

    public ImageSaver() {
    }

    public ImageSaver(String format, int type) {
        this.formatName = format;
        this.bufferType = type;
    }

    public void setOutputStream(OutputStream output) {
        this.out = output;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void saveImage(Image image) {
        BufferedImage bi = MediaTools.createBufferedImage(image, this.bufferType);
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(this.getOutputStream());
        try {
            if (!ImageIO.write((RenderedImage)bi, this.formatName, ios)) {
                throw new IOException("ImageIO.write failed");
            }
            ios.close();
        }
        catch (IOException ex) {
            throw new ErrorException("saveImage: " + ex.getMessage());
        }
    }

    public void updateFileType(File file) {
    }

    public void dumpByte(int x) {
        try {
            this.out.write(x);
        }
        catch (IOException ex) {
            throw new ErrorException("saveImage: " + ex.getMessage());
        }
    }

    public void dumpShort(int x) {
        try {
            this.out.write(x >> 8);
            this.out.write(x);
        }
        catch (IOException ex) {
            throw new ErrorException("saveImage: " + ex.getMessage());
        }
    }

    public void dumpLong(int x) {
        try {
            this.out.write(x >> 24);
            this.out.write(x >> 16);
            this.out.write(x >> 8);
            this.out.write(x);
        }
        catch (IOException ex) {
            throw new ErrorException("saveImage: " + ex.getMessage());
        }
    }

    public int getPixelComponent(int pixel, char color) {
        int alpha = pixel >> 24 & 0xFF;
        switch (color) {
            case 'R': {
                pixel >>= 16;
                break;
            }
            case 'G': {
                pixel >>= 8;
                break;
            }
            case 'B': {
                break;
            }
            default: {
                throw new ErrorException("getPixelComponent: Illegal color");
            }
        }
        return (alpha * (pixel &= 0xFF) + (255 - alpha) * 255) / 255;
    }
}

