/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class SPLWindowSettings {
    public static final String SETTINGS_FILENAME = "spl-window-settings.sav";
    private static Properties props = new Properties();

    public static void saveWindowLocation(Window window) {
        window.addComponentListener(new SPLComponentAdapter());
    }

    public static void forgetWindowLocation(Window window) {
        ComponentListener[] componentListenerArray = window.getComponentListeners();
        int n = componentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentListener listener = componentListenerArray[n2];
            if (listener instanceof SPLComponentAdapter) {
                window.removeComponentListener(listener);
                String title = SPLWindowSettings.getTitle(window);
                props.remove(String.valueOf(title) + "-x");
                props.remove(String.valueOf(title) + "-y");
                props.remove(String.valueOf(title) + "-w");
                props.remove(String.valueOf(title) + "-h");
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadWindowLocation(Window window) {
        Properties properties = props;
        synchronized (properties) {
            try {
                String tempDir = System.getProperty("user.dir");
                String settingsFile = String.valueOf(tempDir) + "/" + SETTINGS_FILENAME;
                FileInputStream input = new FileInputStream(settingsFile);
                props.load(input);
            }
            catch (IOException tempDir) {
            }
            catch (Exception tempDir) {
                // empty catch block
            }
        }
        String title = SPLWindowSettings.getTitle(window);
        if (props.containsKey(String.valueOf(title) + "-x") && props.containsKey(String.valueOf(title) + "-y")) {
            int x = Integer.parseInt(props.getProperty(String.valueOf(title) + "-x"));
            int y = Integer.parseInt(props.getProperty(String.valueOf(title) + "-y"));
            window.setLocation(x, y);
        }
        if (props.containsKey(String.valueOf(title) + "-w") && props.containsKey(String.valueOf(title) + "-h")) {
            int w = Integer.parseInt(props.getProperty(String.valueOf(title) + "-w"));
            int h = Integer.parseInt(props.getProperty(String.valueOf(title) + "-h"));
            window.setSize(w, h);
        }
    }

    private static String getTitle(Window window) {
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return "???";
    }

    private static class SPLComponentAdapter
    extends ComponentAdapter {
        private SPLComponentAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentMoved(ComponentEvent event) {
            Component component = event.getComponent();
            if (!(component instanceof Frame)) {
                return;
            }
            Frame window = (Frame)component;
            int x = window.getX();
            int y = window.getY();
            int w = window.getWidth();
            int h = window.getHeight();
            Properties properties = props;
            synchronized (properties) {
                props.setProperty(String.valueOf(window.getTitle()) + "-x", String.valueOf(x));
                props.setProperty(String.valueOf(window.getTitle()) + "-y", String.valueOf(y));
                props.setProperty(String.valueOf(window.getTitle()) + "-w", String.valueOf(w));
                props.setProperty(String.valueOf(window.getTitle()) + "-h", String.valueOf(h));
                try {
                    String tempDir = System.getProperty("user.dir");
                    String settingsFile = String.valueOf(tempDir) + "/" + SPLWindowSettings.SETTINGS_FILENAME;
                    FileOutputStream out = new FileOutputStream(settingsFile);
                    props.store(out, "Stanford C++ library window location settings");
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

