/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.graphics.GScalable;
import acm.util.MediaTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;

public class GImage
extends GObject
implements GResizable,
GScalable {
    private Image myImage;
    private double myWidth;
    private double myHeight;
    private boolean sizeDetermined;
    static final long serialVersionUID = 1L;

    public GImage(Image image) {
        this(image, 0.0, 0.0);
    }

    public GImage(String name) {
        this(name, 0.0, 0.0);
    }

    public GImage(int[][] array) {
        this(array, 0.0, 0.0);
    }

    public GImage(Image image, double x, double y) {
        this.setImage(image);
        this.setLocation(x, y);
    }

    public GImage(String name, double x, double y) {
        this(MediaTools.loadImage(name), x, y);
    }

    public GImage(int[][] array, double x, double y) {
        this(MediaTools.createImage(array), x, y);
    }

    public void setImage(Image image) {
        this.myImage = MediaTools.loadImage(image);
        this.sizeDetermined = false;
        this.determineSize();
        this.repaint();
    }

    public void setImage(String name) {
        this.setImage(MediaTools.loadImage(name));
    }

    public Image getImage() {
        return this.myImage;
    }

    public void saveImage(String filename) {
        MediaTools.saveImage(this.myImage, filename);
    }

    public void saveImage(File file) {
        MediaTools.saveImage(this.myImage, file);
    }

    protected void paint2d(Graphics2D graphics2d) {
        Component component = this.getComponent();
        if (component == null) {
            component = MediaTools.getImageObserver();
        }
        if (this.myImage != null && component != null) {
            this.determineSize();
            Color color = this.getObjectColor();
            if (color == null) {
                graphics2d.drawImage(this.myImage, 0, 0, GMath.round(this.myWidth), GMath.round(this.myHeight), component);
            } else {
                graphics2d.drawImage(this.myImage, 0, 0, GMath.round(this.myWidth), GMath.round(this.myHeight), color, component);
            }
        }
    }

    public void paint(Graphics g) {
        Component imageObserver = this.getComponent();
        if (imageObserver == null) {
            imageObserver = MediaTools.getImageObserver();
        }
        if (this.myImage != null && imageObserver != null) {
            Rectangle r = this.getAWTBounds();
            Color color = this.getObjectColor();
            if (color == null) {
                g.drawImage(this.myImage, r.x, r.y, r.width, r.height, imageObserver);
            } else {
                g.drawImage(this.myImage, r.x, r.y, r.width, r.height, color, imageObserver);
            }
        }
    }

    public void setSize(double width, double height) {
        this.myWidth = width;
        this.myHeight = height;
        this.repaint();
    }

    public void fit(double width, double height) {
        double aspectRatio = this.myWidth / this.myHeight;
        double widthRatio = this.myWidth / width;
        double heightRatio = this.myHeight / height;
        if (widthRatio > heightRatio) {
            this.myWidth = width;
            this.myHeight = width / aspectRatio;
        } else {
            this.myHeight = height;
            this.myWidth = height * aspectRatio;
        }
    }

    public boolean inBounds(double x, double y) {
        int xx = (int)x;
        int yy = (int)y;
        return xx >= 0 && (double)xx < this.getWidth() && yy >= 0 && (double)yy < this.getHeight();
    }

    public final void setSize(GDimension size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.myWidth, this.myHeight);
    }

    public void setBounds(double x, double y, double width, double height) {
        this.myWidth = width;
        this.myHeight = height;
        this.setLocation(x, y);
    }

    public final void setBounds(GRectangle bounds) {
        this.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public GRectangle getBounds() {
        this.determineSize();
        return new GRectangle(this.getX(), this.getY(), this.myWidth, this.myHeight);
    }

    public void scale(double sx, double sy) {
        this.myWidth *= sx;
        this.myHeight *= sy;
        this.repaint();
    }

    public int[][] getPixelArray() {
        return MediaTools.getPixelArray(this.myImage);
    }

    public void setPixelArray(int[][] pixels) {
        this.setImage(MediaTools.createImage(pixels));
    }

    public static int getAlpha(int pixel) {
        return pixel >> 24 & 0xFF;
    }

    public static int getRed(int pixel) {
        return pixel >> 16 & 0xFF;
    }

    public static int getGreen(int pixel) {
        return pixel >> 8 & 0xFF;
    }

    public static int getBlue(int pixel) {
        return pixel & 0xFF;
    }

    public static int createRGBPixel(int red, int green, int blue) {
        return GImage.createRGBPixel(red, green, blue, 255);
    }

    public static int createRGBPixel(int red, int green, int blue, int alpha) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    protected Rectangle getAWTBounds() {
        this.determineSize();
        return new Rectangle(GMath.round(this.getX()), GMath.round(this.getY()), GMath.round(this.myWidth), GMath.round(this.myHeight));
    }

    private void determineSize() {
        if (this.sizeDetermined) {
            return;
        }
        Component component = this.getComponent();
        if (component == null) {
            component = MediaTools.getImageObserver();
        }
        this.myWidth = this.myImage.getWidth(component);
        this.myHeight = this.myImage.getHeight(component);
        this.sizeDetermined = true;
    }
}

