/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import stanford.cs106.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    public static final String XML_EXTENSION = ".xml";

    public static boolean attributeIsFalsey(Node node, String name) {
        return XmlUtils.hasAttribute(node, name) && StringUtils.isFalsey(XmlUtils.getAttribute(node, name));
    }

    public static boolean attributeIsTruthy(Node node, String name) {
        return XmlUtils.hasAttribute(node, name) && StringUtils.isTruthy(XmlUtils.getAttribute(node, name));
    }

    public static void ensureNotNull(Object node, String tag) {
        if (node == null) {
            throw new XmlRuntimeException("missing required node or attribute: <" + tag + ">");
        }
    }

    public static String getAttribute(Node node, String name) {
        if (node.getAttributes() == null) {
            return null;
        }
        Node attributeNode = node.getAttributes().getNamedItem(name);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getNodeValue();
    }

    public static void setAttribute(Node node, String name, String value) {
        Element element = (Element)node;
        element.setAttribute(name, value);
    }

    public static String getAttribute(Node node, String name, boolean required) {
        return XmlUtils.getAttribute(node, name, required, null);
    }

    public static String getAttribute(Node node, String name, boolean required, String defaultValue) {
        if (required && !XmlUtils.hasAttribute(node, name)) {
            throw new XmlRuntimeException("missing required attribute: " + name);
        }
        String attributeValue = XmlUtils.getAttribute(node, name);
        if (attributeValue == null) {
            attributeValue = defaultValue;
        }
        return attributeValue;
    }

    public static int getAttributeInt(Node node, String name) {
        return XmlUtils.getAttributeInt(node, name, false);
    }

    public static int getAttributeInt(Node node, String name, boolean required) {
        return XmlUtils.getAttributeInt(node, name, required, 0);
    }

    public static int getAttributeInt(Node node, String name, boolean required, int defaultValue) {
        if (required && !XmlUtils.hasAttribute(node, name)) {
            throw new XmlRuntimeException("missing required attribute: " + name);
        }
        String attributeValue = XmlUtils.getAttribute(node, name);
        if (attributeValue != null) {
            try {
                return Integer.parseInt(attributeValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String getAttributeAny(Node node, String ... names) {
        return XmlUtils.getAttributeAny(node, false, names);
    }

    public static String getAttributeAny(Node node, boolean required, String ... names) {
        if (node.getAttributes() != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Node attributeNode = node.getAttributes().getNamedItem(name);
                if (attributeNode != null) {
                    return attributeNode.getNodeValue();
                }
                ++n2;
            }
        }
        if (required) {
            throw new XmlRuntimeException("missing required attributes (one or more must be present): " + Arrays.toString(names));
        }
        return null;
    }

    public static String getAttributeOrChild(Node node, String name) {
        return XmlUtils.getAttributeOrChild(node, name, false);
    }

    public static String getAttributeOrChild(Node node, String name, boolean required) {
        if (XmlUtils.hasAttribute(node, name)) {
            return XmlUtils.getAttribute(node, name);
        }
        return XmlUtils.getChildValue(node, name, required);
    }

    public static List<String> getAttributes(Node node) {
        ArrayList<String> result = new ArrayList<String>();
        NamedNodeMap attrs = node.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node attrNode = attrs.item(i);
            result.add(String.valueOf(attrNode.getNodeName()) + "=" + attrNode.getNodeValue());
            ++i;
        }
        return result;
    }

    public static Node getChildNode(Node node, String element) {
        List<Node> childNodes = XmlUtils.getChildNodes(node, element);
        if (childNodes.isEmpty()) {
            return null;
        }
        return childNodes.get(0);
    }

    public static List<Node> getChildNodes(Node node, String ... elements) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            String[] stringArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.equals(childNode.getNodeName())) {
                    result.add(childNode);
                }
                ++n2;
            }
            ++i;
        }
        return result;
    }

    public static String getChildValue(Node node, String element) {
        return XmlUtils.getChildValue(node, element, false);
    }

    public static String getChildValue(Node node, String element, boolean required) {
        String result = null;
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals(element)) {
                result = XmlUtils.getTextContent(childNode, true);
                break;
            }
            ++i;
        }
        if (required) {
            XmlUtils.ensureNotNull(result, element);
        }
        return result;
    }

    public static Node getChildByTagName(Node node, String element, boolean required) {
        Node result = XmlUtils.getChildByTagName(node, element);
        if (required) {
            XmlUtils.ensureNotNull(result, element);
        }
        return result;
    }

    public static Node getChildByTagName(Node node, String element) {
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            if ("*".equals(element) || element == null || childNode.getNodeName().equals(element)) {
                return childNode;
            }
            ++j;
        }
        return null;
    }

    public static List<Node> getChildrenByTagName(Node node, String element) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            if ("*".equals(element) || element == null || childNode.getNodeName().equals(element)) {
                result.add(childNode);
            }
            ++j;
        }
        return result;
    }

    public static List<Node> getChildrenByTagNames(Node node, String ... elements) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            String[] stringArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if ("*".equals(element) || element == null || childNode.getNodeName().equals(element)) {
                    result.add(childNode);
                }
                ++n2;
            }
            ++j;
        }
        return result;
    }

    public static Element getElementByTagName(Document document, String element) {
        NodeList nodeList = document.getElementsByTagName(element);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static String getTextContent(Node node) {
        return XmlUtils.getTextContent(node, true);
    }

    public static String getTextContent(Node node, boolean trim) {
        if (node == null) {
            return "";
        }
        String textContent = "";
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 3) {
                textContent = String.valueOf(textContent) + childNode.getNodeValue().trim();
            }
            ++i;
        }
        if ((textContent = textContent.replace("\r", "")).startsWith("\n")) {
            textContent = textContent.substring(1);
        }
        if (trim) {
            textContent = textContent.trim();
        }
        return textContent;
    }

    public static boolean hasAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name) != null;
    }

    public static boolean hasAttributeAny(Node node, String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (XmlUtils.hasAttribute(node, name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasAttributes(Node node, String ... names) {
        NamedNodeMap attrs = node.getAttributes();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (attrs.getNamedItem(name) == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void requireAttributes(Node node, String ... names) {
        NamedNodeMap attrs = node.getAttributes();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (attrs.getNamedItem(name) == null) {
                throw new XmlRuntimeException("<" + node.getNodeName() + "> element requires \"" + name + "\" attribute");
            }
            ++n2;
        }
    }

    public static void validate(String xmlFileName, String schemaFileName) throws IOException, ParserConfigurationException, SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new File(schemaFileName));
        Validator validator = schema.newValidator();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder parser = builderFactory.newDocumentBuilder();
        Document document = parser.parse(new File(xmlFileName));
        validator.validate(new DOMSource(document));
    }

    public static Node up(Node node, String element) {
        while (node != null && node.getNodeName() != null && !node.getNodeName().equalsIgnoreCase(element)) {
            node = node.getParentNode();
        }
        return node;
    }

    public static class XmlRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        public XmlRuntimeException(String message) {
            super(message);
        }

        public XmlRuntimeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

