/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;

public class LimitedPrintStream
extends PrintStream {
    private static final int MAX_CALLS = 5000;
    private static final int MAX_CHARS = 50000;
    private int calls = 0;
    private int chars = 0;
    private int maxCalls = 0;
    private int maxChars = 0;

    public LimitedPrintStream(OutputStream stream) {
        this(stream, 5000, 50000);
    }

    public LimitedPrintStream(File file) throws FileNotFoundException {
        this(file, 5000, 50000);
    }

    public LimitedPrintStream(String file) throws FileNotFoundException {
        this(file, 5000, 50000);
    }

    public LimitedPrintStream(OutputStream stream, int maxCalls, int maxChars) {
        super(stream);
        this.maxCalls = maxCalls;
        this.maxChars = maxChars;
    }

    public LimitedPrintStream(File file, int maxCalls, int maxChars) throws FileNotFoundException {
        super(file);
        this.maxCalls = maxCalls;
        this.maxChars = maxChars;
    }

    public LimitedPrintStream(String file, int maxCalls, int maxChars) throws FileNotFoundException {
        super(file);
        this.maxCalls = maxCalls;
        this.maxChars = maxChars;
    }

    public void close() {
    }

    public void print(int x) {
        this.print(String.valueOf(x));
    }

    public void print(double x) {
        this.print(String.valueOf(x));
    }

    public void print(float x) {
        this.print(String.valueOf(x));
    }

    public void print(long x) {
        this.print(String.valueOf(x));
    }

    public void print(short x) {
        this.print(String.valueOf(x));
    }

    public void print(byte x) {
        this.print(String.valueOf(x));
    }

    public void print(boolean x) {
        this.print(String.valueOf(x));
    }

    public void print(char x) {
        this.print(String.valueOf(x));
    }

    public void print(Object x) {
        this.print(String.valueOf(x));
    }

    public void print(String x) {
        ++this.calls;
        this.chars += x == null ? 4 : x.length();
        if (this.calls >= this.maxCalls || this.chars >= this.maxChars) {
            throw new ExcessiveOutputException();
        }
        super.print(x);
    }

    public void println(int x) {
        this.println(String.valueOf(x));
    }

    public void println(double x) {
        this.println(String.valueOf(x));
    }

    public void println(float x) {
        this.println(String.valueOf(x));
    }

    public void println(long x) {
        this.println(String.valueOf(x));
    }

    public void println(short x) {
        this.println(String.valueOf(x));
    }

    public void println(byte x) {
        this.println(String.valueOf(x));
    }

    public void println(boolean x) {
        this.println(String.valueOf(x));
    }

    public void println(char x) {
        this.println(String.valueOf(x));
    }

    public void println(Object x) {
        this.println(String.valueOf(x));
    }

    public void println(String x) {
        this.print(x);
        this.print("\n");
    }

    public static class ExcessiveOutputException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        public ExcessiveOutputException() {
        }

        public ExcessiveOutputException(String message) {
            super(message);
        }
    }
}

