/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.audio;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import stanford.cs106.audio.Note;

public final class StdAudio {
    public static final int SAMPLE_RATE = 44100;
    private static final int BYTES_PER_SAMPLE = 2;
    private static final int BITS_PER_SAMPLE = 16;
    private static final double MAX_16_BIT = 32767.0;
    private static final int SAMPLE_BUFFER_SIZE = 4096;
    private static SourceDataLine line;
    private static byte[] buffer;
    private static int bufferSize;
    private static boolean muted;
    private static boolean paused;
    private static Set<AudioEventListener> listeners;

    static {
        bufferSize = 0;
        muted = false;
        paused = false;
        StdAudio.init();
    }

    public static void addAudioEventListener(AudioEventListener listener) {
        listeners.add(listener);
    }

    private static void init() {
        try {
            AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format, 8192);
            buffer = new byte[2730];
            listeners = new HashSet<AudioEventListener>();
        }
        catch (Exception e) {
            System.err.println("Error initializing StdAudio audio system:");
            e.printStackTrace();
            System.exit(1);
        }
        line.start();
    }

    public static void clearAudioEventListeners() {
        listeners.clear();
    }

    public static void close() {
        line.drain();
        line.stop();
    }

    public static boolean isMuted() {
        return muted;
    }

    public static boolean isPaused() {
        return paused;
    }

    public static void loop(String filename) {
        if (muted) {
            return;
        }
        URL url = null;
        try {
            File file = new File(filename);
            if (file.canRead()) {
                url = file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (url == null) {
            throw new RuntimeException("audio " + filename + " not found");
        }
        AudioClip clip = Applet.newAudioClip(url);
        clip.loop();
        StdAudio.notifyListeners(new AudioEvent(AudioEvent.Type.LOOP));
    }

    public static double[] note(double hz, double duration, double amplitude) {
        int N = (int)(44100.0 * duration);
        double[] a = new double[N + 1];
        int i = 0;
        while (i <= N) {
            a[i] = amplitude * Math.sin(Math.PI * 2 * (double)i * hz / 44100.0);
            ++i;
        }
        return a;
    }

    public static void play(double in) {
        if (muted) {
            return;
        }
        if (in < -1.0) {
            in = -1.0;
        }
        if (in > 1.0) {
            in = 1.0;
        }
        short s = (short)(32767.0 * in);
        StdAudio.buffer[StdAudio.bufferSize++] = (byte)s;
        StdAudio.buffer[StdAudio.bufferSize++] = (byte)(s >> 8);
        if (bufferSize >= buffer.length) {
            line.write(buffer, 0, buffer.length);
            bufferSize = 0;
        }
    }

    public static void play(double[] input) {
        StdAudio.prePlay();
        int i = 0;
        while (i < input.length) {
            StdAudio.play(input[i]);
            ++i;
        }
    }

    public static void play(double[] input, double duration) {
        StdAudio.play(input);
        StdAudio.notifyListeners(new AudioEvent(AudioEvent.Type.PLAY, duration));
    }

    public static void play(Note note, double[] input, double duration) {
        StdAudio.play(input);
        StdAudio.notifyListeners(new AudioEvent(AudioEvent.Type.PLAY, note, duration));
    }

    public static void play(String filename) {
        StdAudio.prePlay();
        URL url = null;
        try {
            File file = new File(filename);
            if (file.canRead()) {
                url = file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (url == null) {
            throw new RuntimeException("audio " + filename + " not found");
        }
        AudioClip clip = Applet.newAudioClip(url);
        clip.play();
    }

    public static double[] read(String filename) {
        byte[] data = StdAudio.readByte(filename);
        int N = data.length;
        double[] d = new double[N / 2];
        int i = 0;
        while (i < N / 2) {
            d[i] = (double)((short)(((data[2 * i + 1] & 0xFF) << 8) + (data[2 * i] & 0xFF))) / 32767.0;
            ++i;
        }
        return d;
    }

    public static void removeAudioEventListener(AudioEventListener listener) {
        listeners.remove(listener);
    }

    public static void save(String filename, double[] input) {
        block5: {
            AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, false);
            byte[] data = new byte[2 * input.length];
            int i = 0;
            while (i < input.length) {
                short temp = (short)(input[i] * 32767.0);
                data[2 * i + 0] = (byte)temp;
                data[2 * i + 1] = (byte)(temp >> 8);
                ++i;
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                AudioInputStream ais = new AudioInputStream(bais, format, input.length);
                if (filename.endsWith(".wav") || filename.endsWith(".WAV")) {
                    AudioSystem.write(ais, AudioFileFormat.Type.WAVE, new File(filename));
                    break block5;
                }
                if (filename.endsWith(".au") || filename.endsWith(".AU")) {
                    AudioSystem.write(ais, AudioFileFormat.Type.AU, new File(filename));
                    break block5;
                }
                throw new RuntimeException("File format not supported: " + filename);
            }
            catch (Exception e) {
                System.out.println(e);
                System.exit(1);
            }
        }
    }

    public static void setMute(boolean mute) {
        muted = mute;
        StdAudio.notifyListeners(new AudioEvent(mute ? AudioEvent.Type.MUTE : AudioEvent.Type.UNMUTE));
    }

    public static void setPaused(boolean pause) {
        paused = pause;
        StdAudio.notifyListeners(new AudioEvent(pause ? AudioEvent.Type.PAUSE : AudioEvent.Type.UNPAUSE));
    }

    private static void notifyListeners(AudioEvent event) {
        for (AudioEventListener listener : listeners) {
            listener.onAudioEvent(event);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void prePlay() {
        if (!StdAudio.muted) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException var0) {
                // empty catch block
            }
lbl8:
            // 3 sources

            ** while (StdAudio.paused)
        }
lbl9:
        // 1 sources

    }

    private static byte[] readByte(String filename) {
        byte[] data = null;
        AudioInputStream ais = null;
        try {
            File file = new File(filename);
            if (file.exists()) {
                ais = AudioSystem.getAudioInputStream(file);
                data = new byte[ais.available()];
                ais.read(data);
            } else {
                URL url = StdAudio.class.getResource(filename);
                ais = AudioSystem.getAudioInputStream(url);
                data = new byte[ais.available()];
                ais.read(data);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new RuntimeException("Could not read " + filename);
        }
        return data;
    }

    public static void main(String[] args) {
        double freq = 440.0;
        int i = 0;
        while (i <= 44100) {
            StdAudio.play(0.5 * Math.sin(Math.PI * 2 * freq * (double)i / 44100.0));
            ++i;
        }
        int[] nArray = new int[8];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        nArray[7] = 12;
        int[] steps = nArray;
        int i2 = 0;
        while (i2 < steps.length) {
            double hz = 440.0 * Math.pow(2.0, (double)steps[i2] / 12.0);
            StdAudio.play(StdAudio.note(hz, 1.0, 0.5));
            ++i2;
        }
        StdAudio.close();
        System.exit(0);
    }

    private StdAudio() {
    }

    public static class AudioEvent {
        private Type type;
        private Note note;
        private double duration;

        public AudioEvent(Type type) {
            this(type, 0.0);
        }

        public AudioEvent(Type type, double duration) {
            this.type = type;
            this.duration = duration;
        }

        public AudioEvent(Type type, Note note, double duration) {
            this.type = type;
            this.note = note;
            this.duration = duration;
        }

        public double getDuration() {
            return this.duration;
        }

        public Note getNote() {
            return this.note;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "AudioEvent{Type=" + (Object)((Object)this.type) + (this.note == null ? "" : ", note=" + this.note) + (this.duration == 0.0 ? "" : ", duration=" + this.duration) + "}";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            PLAY,
            LOOP,
            PAUSE,
            UNPAUSE,
            STOP,
            MUTE,
            UNMUTE;

        }
    }

    public static interface AudioEventListener {
        public void onAudioEvent(AudioEvent var1);
    }
}

