/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.util.ErrorException;
import acm.util.JTFTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandLineProgramLoader
extends ClassLoader {
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_NameAndType = 12;
    private HashMap<Integer, Integer> classTable;
    private ClassLoader realLoader;
    private String targetName;
    private int superclassOffset;

    public CommandLineProgramLoader(String string) {
        this.targetName = string;
        try {
            Class<?> clazz = Class.forName("java.lang.ClassLoader");
            Method method = clazz.getMethod("getSystemClassLoader", new Class[0]);
            this.realLoader = (ClassLoader)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (string.equals(this.targetName)) {
            InputStream inputStream = this.getResourceAsStream(string + ".class");
            this.superclassOffset = this.findSuperclassOffset(inputStream);
            inputStream = this.getResourceAsStream(string + ".class");
            byte[] byArray = this.patchClassData(inputStream);
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        return this.realLoader.loadClass(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        return this.realLoader.getResourceAsStream(string);
    }

    @Override
    public URL getResource(String string) {
        return this.realLoader.getResource(string);
    }

    private byte[] patchClassData(InputStream inputStream) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JTFTools.copyBytes(inputStream, byteArrayOutputStream, 8L);
            int n2 = inputStream.read() << 8 | inputStream.read();
            byteArrayOutputStream.write(n2 >> 8);
            byteArrayOutputStream.write(n2 & 0xFF);
            block15: for (n = 1; n < n2; ++n) {
                int n3 = inputStream.read();
                byteArrayOutputStream.write(n3);
                if (JTFTools.testDebugOption("constants")) {
                    System.out.println(n + ": " + CommandLineProgramLoader.getConstantTypeName(n3));
                }
                switch (n3) {
                    case 3: {
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, 4L);
                        continue block15;
                    }
                    case 4: {
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, 4L);
                        continue block15;
                    }
                    case 5: {
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, 8L);
                        ++n;
                        continue block15;
                    }
                    case 6: {
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, 8L);
                        ++n;
                        continue block15;
                    }
                    case 7: {
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, 2L);
                        continue block15;
                    }
                    case 8: {
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, 2L);
                        continue block15;
                    }
                    case 9: {
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, 4L);
                        continue block15;
                    }
                    case 10: {
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, 4L);
                        continue block15;
                    }
                    case 11: {
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, 4L);
                        continue block15;
                    }
                    case 12: {
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, 4L);
                        continue block15;
                    }
                    case 1: {
                        int n4;
                        if (n == this.superclassOffset) {
                            n4 = inputStream.read() << 8 | inputStream.read();
                            inputStream.skip(n4);
                            String string = "acm/program/CommandLineProgram";
                            n4 = string.length();
                            byteArrayOutputStream.write(n4 >> 8);
                            byteArrayOutputStream.write(n4 & 0xFF);
                            for (int i = 0; i < n4; ++i) {
                                byteArrayOutputStream.write((byte)string.charAt(i));
                            }
                            continue block15;
                        }
                        n4 = inputStream.read() << 8 | inputStream.read();
                        byteArrayOutputStream.write(n4 >> 8);
                        byteArrayOutputStream.write(n4 & 0xFF);
                        JTFTools.copyBytes(inputStream, byteArrayOutputStream, n4);
                    }
                }
            }
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    private int findSuperclassOffset(InputStream inputStream) {
        this.classTable = new HashMap();
        try {
            inputStream.skip(8L);
            int n = inputStream.read() << 8 | inputStream.read();
            n += 2;
            block15: for (int i = 1; i < n - 2; ++i) {
                int n2 = inputStream.read();
                switch (n2) {
                    case 3: {
                        inputStream.skip(4L);
                        continue block15;
                    }
                    case 4: {
                        inputStream.skip(4L);
                        continue block15;
                    }
                    case 5: {
                        inputStream.skip(8L);
                        ++i;
                        continue block15;
                    }
                    case 6: {
                        inputStream.skip(8L);
                        ++i;
                        continue block15;
                    }
                    case 8: {
                        inputStream.skip(2L);
                        continue block15;
                    }
                    case 9: {
                        inputStream.skip(4L);
                        continue block15;
                    }
                    case 10: {
                        inputStream.skip(4L);
                        continue block15;
                    }
                    case 11: {
                        inputStream.skip(4L);
                        continue block15;
                    }
                    case 12: {
                        inputStream.skip(4L);
                        continue block15;
                    }
                    case 7: {
                        int n3 = inputStream.read() << 8 | inputStream.read();
                        this.classTable.put(new Integer(i), new Integer(n3));
                        continue block15;
                    }
                    case 1: {
                        int n4 = inputStream.read() << 8 | inputStream.read();
                        inputStream.skip(n4);
                    }
                }
            }
            inputStream.skip(4L);
            return this.classTable.get(new Integer(inputStream.read() << 8 | inputStream.read()));
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    private static String getConstantTypeName(int n) {
        switch (n) {
            case 1: {
                return "Utf8";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 6: {
                return "Double";
            }
            case 7: {
                return "Class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Fieldref";
            }
            case 10: {
                return "Methodref";
            }
            case 11: {
                return "InterfaceMethodref";
            }
            case 12: {
                return "NameAndType";
            }
        }
        return "Type[" + n + "]";
    }
}

