/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import stanford.cs106.diff.Diff;
import stanford.cs106.gui.GuiUtils;
import stanford.cs106.gui.WindowCloseKeyListener;
import stanford.cs106.util.StringUtils;

public class DiffGui
implements ActionListener,
AdjustmentListener {
    public static boolean SIDE_BY_SIDE_ENABLED = false;
    private static final int SPLIT = 0;
    public static final String EXPECTED_COLOR = "#00aa00";
    public static final String STUDENT_COLOR = "#aa0000";
    public static final String LINE_NUMBER_BG_COLOR = "#ffffff";
    public static final String LINE_NUMBER_FG_COLOR = "#777777";
    private String s1;
    private String s2;
    private JFrame frame;
    private JTextPane diffsArea;
    private JTextPane sbsDiffsArea;
    private JScrollPane scroll1;
    private JScrollPane scroll2;
    private int oldScrollValue1 = 0;
    private int oldScrollValue2 = 0;
    private JCheckBox syncBox;
    private JCheckBox ignoreLeading;
    private JCheckBox ignoreTrailing;
    private JCheckBox ignoreWhitespace;
    private JCheckBox ignoreBlankLines;
    private JCheckBox ignoreCase;
    private JCheckBox ignorePunctuation;
    private JCheckBox ignoreNumbers;
    private JCheckBox ignoreNonNumbers;

    public DiffGui(String s1, String s2) {
        this(null, s1, null, s2);
    }

    public DiffGui(String name1, String s1, String name2, String s2) {
        this(name1, s1, name2, s2, 30);
    }

    public DiffGui(String name1, String s1, String name2, String s2, int flags) {
        this.s1 = s1;
        this.s2 = s2;
        JTextPane area1 = this.makeHtmlPane(this.colorOutput(StringUtils.numberLines(s1)));
        JTextPane area2 = this.makeHtmlPane(this.colorOutput(StringUtils.numberLines(s2)));
        this.diffsArea = this.makeHtmlPane(this.colorDiffs(Diff.diff(s1, s2, flags)));
        this.sbsDiffsArea = this.makeHtmlPane(this.colorSideBySideDiffs(Diff.diffSideBySide(s1, s2, StringUtils.getWidth(s1))));
        this.syncBox = new JCheckBox("Sync scrolling", true);
        this.syncBox.setHorizontalAlignment(0);
        this.syncBox.setMnemonic('S');
        this.ignoreLeading = new JCheckBox("Start", (flags & 1) != 0);
        this.ignoreTrailing = new JCheckBox("End", (flags & 2) != 0);
        this.ignoreWhitespace = new JCheckBox("Spaces", (flags & 4) != 0);
        this.ignoreBlankLines = new JCheckBox("Blank", (flags & 8) != 0);
        this.ignoreCase = new JCheckBox("CaSe", (flags & 0x10) != 0);
        this.ignorePunctuation = new JCheckBox("Punct", (flags & 0x80) != 0);
        this.ignoreNumbers = new JCheckBox("[0-9]", (flags & 0x20) != 0);
        this.ignoreNonNumbers = new JCheckBox("![0-9]", (flags & 0x40) != 0);
        JPanel center = new JPanel(new GridLayout(1, 2));
        this.scroll1 = new JScrollPane(area1);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.scroll1.setPreferredSize(new Dimension((int)((double)screen.width * 0.45), (int)((double)screen.height * 0.7)));
        this.scroll1.getVerticalScrollBar().addAdjustmentListener(this);
        this.scroll2 = new JScrollPane(area2);
        this.scroll2.setPreferredSize(this.scroll1.getPreferredSize());
        this.scroll2.getVerticalScrollBar().addAdjustmentListener(this);
        center.add(this.scroll1);
        center.add(this.scroll2);
        JTabbedPane diffsSouth = new JTabbedPane();
        diffsSouth.addTab("Diffs (use checkboxes below)", new JScrollPane(this.diffsArea));
        if (SIDE_BY_SIDE_ENABLED) {
            diffsSouth.addTab("Side-by-side (checkboxes have no effect)", new JScrollPane(this.sbsDiffsArea));
        }
        JPanel buttonPane = GuiUtils.createPanel(new FlowLayout(1), new JLabel("Ignore: "), this.ignoreLeading, this.ignoreTrailing, this.ignoreWhitespace, this.ignoreBlankLines, this.ignoreCase, this.ignorePunctuation, this.ignoreNumbers, this.ignoreNonNumbers, GuiUtils.createButton("Update", 'U', this), Box.createHorizontalStrut(20), GuiUtils.createButton("Close", 'C', this));
        JPanel overall = new JPanel(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(0, center, diffsSouth);
        splitPane.setDividerLocation(0.6);
        overall.add((Component)splitPane, "Center");
        overall.add((Component)buttonPane, "South");
        JPanel north = new JPanel(new GridLayout(1, 3));
        if (name1 == null) {
            north.add(new JLabel());
        } else {
            JLabel label1 = new JLabel("<html><body><font color='#00aa00'>" + name1 + "</font></body></html>");
            label1.setHorizontalAlignment(2);
            north.add(label1);
        }
        north.add(this.syncBox);
        if (name2 == null) {
            north.add(new JLabel());
        } else {
            JLabel label2 = new JLabel("<html><body><font color='#aa0000'>" + name2 + "</font></body></html>");
            label2.setHorizontalAlignment(4);
            north.add(label2);
        }
        overall.add((Component)north, "North");
        this.frame = new JFrame();
        this.frame.setTitle("Diff");
        this.frame.setDefaultCloseOperation(2);
        this.frame.setContentPane(overall);
        new WindowCloseKeyListener(this.frame);
        this.frame.pack();
        GuiUtils.centerWindow(this.frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustmentValueChanged(AdjustmentEvent event) {
        int value = event.getValue();
        JScrollBar bar1 = this.scroll1.getVerticalScrollBar();
        JScrollBar bar2 = this.scroll2.getVerticalScrollBar();
        if (this.syncBox.isSelected()) {
            JScrollBar jScrollBar = bar1;
            synchronized (jScrollBar) {
                bar1.removeAdjustmentListener(this);
                bar2.removeAdjustmentListener(this);
                if (event.getSource() == bar1) {
                    int diff = value - this.oldScrollValue1;
                    bar2.setValue(bar2.getValue() + diff);
                } else {
                    int diff = value - this.oldScrollValue2;
                    bar1.setValue(bar1.getValue() + diff);
                }
                bar1.addAdjustmentListener(this);
                bar2.addAdjustmentListener(this);
            }
        }
        this.oldScrollValue1 = bar1.getValue();
        this.oldScrollValue2 = bar2.getValue();
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand().intern();
        if (cmd == "Update") {
            int newFlags = 0;
            if (this.ignoreLeading.isSelected()) {
                newFlags |= 1;
            }
            if (this.ignoreTrailing.isSelected()) {
                newFlags |= 2;
            }
            if (this.ignoreWhitespace.isSelected()) {
                newFlags |= 4;
            }
            if (this.ignoreBlankLines.isSelected()) {
                newFlags |= 8;
            }
            if (this.ignoreCase.isSelected()) {
                newFlags |= 0x10;
            }
            if (this.ignorePunctuation.isSelected()) {
                newFlags |= 0x80;
            }
            if (this.ignoreNumbers.isSelected()) {
                newFlags |= 0x20;
            }
            if (this.ignoreNonNumbers.isSelected()) {
                newFlags |= 0x40;
            }
            this.diffsArea.setText(this.colorDiffs(Diff.diff(this.s1, this.s2, newFlags)));
            this.diffsArea.setCaretPosition(0);
        }
        if (cmd == "Close") {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    public void show() {
        this.frame.setVisible(true);
    }

    private String colorOutput(String output) {
        String[] lines = output.split("\r?\n");
        int i = 0;
        while (i < lines.length) {
            lines[i] = lines[i].replaceAll("^([0-9]{1,4}[|])", "<font color='#777777' bgcolor='#ffffff'>$1</font>");
            ++i;
        }
        return StringUtils.join(lines, "<br>");
    }

    private String colorDiffs(String diffs) {
        diffs = StringUtils.htmlEncode(diffs, true, true);
        diffs = diffs.replaceAll("(EXPECTED&nbsp;&lt;.{0,999})", "<font color='#00aa00'>$1</font>");
        diffs = diffs.replaceAll("(STUDENT&nbsp;&nbsp;&gt;.{0,999})", "<font color='#aa0000'>$1</font>");
        return "<html><body>" + diffs + "</body></html>";
    }

    private String colorSideBySideDiffs(String diffs) {
        diffs = StringUtils.htmlEncode(diffs, true, true);
        return "<html><body>" + diffs + "</body></html>";
    }

    private JTextPane makeHtmlPane(String htmlText) {
        JTextPane pane = new JTextPane();
        Font font = pane.getFont();
        font = new Font("Monospaced", 0, font.getSize());
        pane.setFont(font);
        pane.setContentType("text/html");
        pane.setText(htmlText);
        pane.setCaretPosition(0);
        pane.setEditable(false);
        return pane;
    }
}

