/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JStringList
extends JList {
    private static final long serialVersionUID = 0L;
    private List<Color> colorsList = new ArrayList<Color>();
    private Set<ActionListener> listeners = new LinkedHashSet<ActionListener>();
    private String actionCommand = null;

    public JStringList() {
        super(new DefaultListModel());
        this.setSelectionMode(0);
        this.addListSelectionListener(new JStringListSelectionListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener listener) {
        this.ensureNotNull(listener);
        Set<ActionListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    public void addItem(String s) {
        this.addItem(s, Color.BLACK);
    }

    public void addItem(String s, Color color) {
        this.ensureNotNull(s, color);
        this.getModel().addElement(this.wrapWithColor(s, color));
        this.colorsList.add(color);
    }

    public void addItems(String[] items) {
        this.ensureNotNull(new Object[]{items});
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.addItem(item);
            ++n2;
        }
    }

    public void addItems(String[] items, Color[] colors) {
        this.ensureNotNull(items, colors);
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            Color color = i < colors.length ? colors[i] : Color.BLACK;
            this.addItem(item, color);
            ++i;
        }
    }

    public void clear() {
        this.getModel().clear();
        this.colorsList.clear();
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public ActionListener[] getActionListeners() {
        return this.listeners.toArray(new ActionListener[0]);
    }

    public Color getColor(int index) {
        return this.colorsList.get(index);
    }

    public String getItem(int index) {
        String item = (String)this.getModel().get(index);
        item = this.stripHTML(item);
        return item;
    }

    public int getItemCount() {
        return this.colorsList.size();
    }

    public DefaultListModel getModel() {
        return (DefaultListModel)super.getModel();
    }

    public String getSelectedValue() {
        String selected = (String)super.getSelectedValue();
        if (selected != null) {
            selected = this.stripHTML(selected);
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener listener) {
        this.ensureNotNull(listener);
        Set<ActionListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public void removeItem(int index) {
        this.getModel().removeElementAt(index);
        this.colorsList.remove(index);
    }

    public void removeItem(String s) {
        this.ensureNotNull(s);
        int i = 0;
        while (i < this.getModel().getSize()) {
            String item = (String)this.getModel().get(i);
            if (item.equals(s) || this.stripHTML(item).equals(s)) {
                this.getModel().removeElement(item);
                this.colorsList.remove(i);
                break;
            }
            ++i;
        }
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public void setColor(int index, Color color) {
        this.ensureNotNull(color);
        String text = this.getItem(index);
        this.getModel().set(index, this.wrapWithColor(text, color));
    }

    public void setColors(Color[] colors) {
        this.ensureNotNull(new Object[]{colors});
        int len = Math.min(this.getItemCount(), colors.length);
        int i = 0;
        while (i < len) {
            this.setColor(i, colors[i]);
            ++i;
        }
    }

    public void setItem(int index, String s) {
        this.ensureNotNull(s);
        Color color = this.colorsList.get(index);
        this.getModel().set(index, this.wrapWithColor(s, color));
    }

    public void setItem(int index, String s, Color color) {
        this.ensureNotNull(s, color);
        this.colorsList.set(index, color);
        this.getModel().set(index, this.wrapWithColor(s, color));
    }

    public void setItems(String[] items, Color[] colors) {
        this.ensureNotNull(items, colors);
        this.clear();
        this.addItems(items, colors);
    }

    private void ensureNotNull(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionPerformed() {
        ActionEvent event = new ActionEvent(this, -1, this.actionCommand);
        Set<ActionListener> set = this.listeners;
        synchronized (set) {
            for (ActionListener listener : this.listeners) {
                listener.actionPerformed(event);
            }
        }
    }

    private String stripHTML(String s) {
        return s.replaceAll("<[^>]*>", "");
    }

    private String toRgbString(Color color) {
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private String wrapWithColor(String s, Color c) {
        String colorString = this.toRgbString(c);
        return "<html><font color=\"" + colorString + "\">" + s + "</font></html>";
    }

    private class JStringListSelectionListener
    implements ListSelectionListener {
        private JStringListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                JStringList.this.fireActionPerformed();
            }
        }
    }
}

