/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    private static final boolean DEBUG = false;
    private static Class<?> resourceLoaderClass = ResourceUtils.class;

    public static void setResourceLoaderClass(Class<?> clazz) {
        if (clazz != null) {
            resourceLoaderClass = clazz;
        }
    }

    public static boolean fileExists(String filename) {
        try {
            URL url = ResourceUtils.filenameToURL(filename);
            return url != null;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static URL filenameToURL(String filename) throws IOException {
        filename = filename.replace("\\", "/");
        File file = new File(filename);
        URL result = null;
        try {
            if (file.exists()) {
                result = new URL("file:" + filename.replace("\\", "/"));
            }
        }
        catch (SecurityException sex) {
            sex.printStackTrace();
        }
        if (result == null) {
            result = resourceLoaderClass.getResource("/" + filename);
        }
        if (result == null) {
            throw new FileNotFoundException(filename);
        }
        return result;
    }

    public static InputStream openFile(String filename) throws IOException {
        InputStream stream = ResourceUtils.filenameToURL(filename).openStream();
        if (stream == null) {
            throw new FileNotFoundException(filename);
        }
        return stream;
    }
}

