/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.util;

import java.awt.Point;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import stanford.cs106.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static final int DEFAULT_TAB_WIDTH = 4;
    public static final String TAB_STRING = "\t";

    public static String escape(String s) {
        s = String.valueOf(s);
        s = s.replace("\\", "\\\\");
        s = s.replace("\"", "\\\"");
        s = s.replace("\n", "\\n");
        s = s.replace(TAB_STRING, "\\t");
        return s;
    }

    public static String fitToWidth(String value, int width) {
        return StringUtils.fitToBox(value, width, value == null ? 0 : value.length());
    }

    public static String fitToHeight(String value, int height) {
        return StringUtils.fitToBox(value, value == null ? 0 : value.length(), height);
    }

    public static String fitToBox(String value, int width, int height) {
        return StringUtils.fitToBox(value, width, height, false);
    }

    public static String fitToBox(String value, int width, int height, boolean html) {
        if (value == null) {
            value = "null";
        }
        String[] lines = value.split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].length() > width) {
                lines[i] = String.valueOf(lines[i].substring(0, width)) + "...";
            }
            ++i;
        }
        if (lines.length > height) {
            lines[height++] = "...";
        }
        return StringUtils.join(lines, html ? "<br/>\n" : "\n", height);
    }

    public static int getWidth(String value) {
        if (value == null) {
            return 0;
        }
        String[] lines = value.split("\n");
        int width = 0;
        int i = 0;
        while (i < lines.length) {
            width = Math.max(width, lines[i].length());
            ++i;
        }
        return width;
    }

    public static int getHeight(String value) {
        if (value == null || value.length() == 0) {
            return 0;
        }
        String[] lines = (String.valueOf(value) + " ").split("\n");
        return lines.length;
    }

    public static String htmlDecode(String value) {
        return StringUtils.htmlDecode(value, false);
    }

    public static String htmlDecode(String value, boolean replaceSpecialChars) {
        if (value == null) {
            return null;
        }
        value = value.replace("&lt;", "<");
        value = value.replace("&gt;", ">");
        value = value.replace("&nbsp;", " ");
        value = value.replace("\u00a0", " ");
        value = value.replace("&amp;", "&");
        if (replaceSpecialChars) {
            value = value.replace("\\n", "\n");
            value = value.replace("\\t", TAB_STRING);
            value = value.replace("\\\"", "\"");
            value = value.replace("\\\\", "\\");
        }
        return value;
    }

    public static String htmlEncode(String value) {
        return StringUtils.htmlEncode(value, false);
    }

    public static String htmlEncode(String value, boolean replaceSpecialChars) {
        return StringUtils.htmlEncode(value, replaceSpecialChars, false);
    }

    public static String htmlEncode(String value, boolean replaceSpecialChars, boolean nbsp) {
        if (value == null) {
            return "null";
        }
        value = value.replace("&", "&amp;");
        value = value.replace("<", "&lt;");
        value = value.replace(">", "&gt;");
        if (nbsp) {
            value = value.replace(" ", "&nbsp;");
        }
        value = value.replace("\"", "&quot;");
        if (replaceSpecialChars) {
            value = value.replace("\n", "<br />\n");
            value = value.replace(TAB_STRING, "\t\t");
        }
        return value;
    }

    public static String htmlEncode(int value) {
        return StringUtils.htmlEncode(String.valueOf(value));
    }

    public static String htmlEncode(double value) {
        return StringUtils.htmlEncode(String.valueOf(value));
    }

    public static String htmlEncode(char value) {
        return StringUtils.htmlEncode(String.valueOf(value));
    }

    public static String htmlEncode(boolean value) {
        return StringUtils.htmlEncode(String.valueOf(value));
    }

    public static String htmlEncode(long value) {
        return StringUtils.htmlEncode(String.valueOf(value));
    }

    public static String htmlEncode(Object value) {
        return StringUtils.htmlEncode(String.valueOf(value));
    }

    public static boolean isFalsey(String value) {
        if (value == null) {
            return false;
        }
        return (value = value.trim().toLowerCase().intern()) == "false" || value == "0" || value == "no" || value == "n" || value == "off" || value == "disabled";
    }

    public static boolean isTruthy(String value) {
        if (value == null) {
            return false;
        }
        return (value = value.trim().toLowerCase().intern()) == "true" || value == "1" || value == "yes" || value == "y" || value == "on" || value == "enabled";
    }

    public static String join(String[] tokens, String delimiter) {
        return StringUtils.join(tokens, delimiter, tokens == null ? 0 : tokens.length);
    }

    public static String join(String[] tokens, String delimiter, int limit) {
        if (tokens == null || tokens.length == 0 || limit <= 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(tokens[0]);
        limit = Math.min(limit, tokens.length);
        int i = 1;
        while (i < limit) {
            buffer.append(delimiter);
            buffer.append(tokens[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String join(Iterable<String> tokens, String delimiter) {
        if (tokens == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<String> itr = tokens.iterator();
        if (!itr.hasNext()) {
            return "";
        }
        buffer.append(itr.next());
        while (itr.hasNext()) {
            buffer.append(delimiter);
            buffer.append(itr.next());
        }
        return buffer.toString();
    }

    public static int levenshtein(String s1, String s2) {
        s1 = s1.toUpperCase();
        s2 = s2.toUpperCase();
        int[][] matrix = new int[s1.length() + 1][s2.length() + 1];
        int i = 0;
        while (i <= s1.length()) {
            matrix[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= s2.length()) {
            matrix[0][j] = j;
            ++j;
        }
        j = 1;
        while (j <= s2.length()) {
            int i2 = 1;
            while (i2 <= s1.length()) {
                matrix[i2][j] = s1.charAt(i2 - 1) == s2.charAt(j - 1) ? matrix[i2 - 1][j - 1] : 1 + Math.min(matrix[i2 - 1][j], Math.min(matrix[i2][j - 1], matrix[i2 - 1][j - 1]));
                ++i2;
            }
            ++j;
        }
        return matrix[matrix.length - 1][matrix[0].length - 1];
    }

    public static String nCopies(String s, int n) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length() * n + 8);
        int i = 1;
        while (i <= n) {
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static String numberLines(String s) {
        String[] lines = (s = String.valueOf(s)).split("\r?\n");
        int digits = String.valueOf(lines.length).length();
        if (digits == 0) {
            return "";
        }
        int i = 0;
        while (i < lines.length) {
            lines[i] = String.format("%0" + digits + "d| %s", i + 1, lines[i]);
            ++i;
        }
        return StringUtils.join(lines, "\n");
    }

    public static String padL(int s, int width) {
        return StringUtils.padL(String.valueOf(s), width);
    }

    public static String padL(String s, int width) {
        s = String.valueOf(s);
        while (s.length() < width) {
            s = " " + s;
        }
        return s;
    }

    public static String padR(int s, int width) {
        return StringUtils.padR(String.valueOf(s), width);
    }

    public static String padR(String s, int width) {
        s = String.valueOf(s);
        while (s.length() < width) {
            s = String.valueOf(s) + " ";
        }
        return s;
    }

    public static boolean[] parseBooleanArray(String s) {
        s = String.valueOf(s);
        String[] tokens = StringUtils.parseStringArray(s);
        boolean[] result = new boolean[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            result[i] = Boolean.parseBoolean(tokens[i]);
            ++i;
        }
        return result;
    }

    public static char[] parseCharArray(String s) {
        s = String.valueOf(s);
        s = s.replace("'", "");
        String[] tokens = StringUtils.parseStringArray(s);
        char[] result = new char[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            result[i] = tokens[i].length() > 0 ? tokens[i].charAt(0) : (char)'\u0000';
            ++i;
        }
        return result;
    }

    public static double[] parseDoubleArray(String s) {
        s = String.valueOf(s);
        String[] tokens = StringUtils.parseStringArray(s);
        double[] result = new double[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            result[i] = Double.parseDouble(tokens[i]);
            ++i;
        }
        return result;
    }

    public static int[] parseIntArray(String s) {
        s = String.valueOf(s);
        String[] tokens = StringUtils.parseStringArray(s);
        int[] result = new int[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            result[i] = Integer.parseInt(tokens[i]);
            ++i;
        }
        return result;
    }

    public static int[][] parseIntArray2D(String s) {
        s = String.valueOf(s);
        s = s.trim();
        if ((s = s.replaceAll("^\\{+", "").replaceAll("\\}+$", "")).length() == 0) {
            return new int[0][0];
        }
        String[] rows = s.split("\\}, \\{");
        int[][] result = new int[rows.length][];
        int i = 0;
        while (i < rows.length) {
            result[i] = StringUtils.parseIntArray(rows[i]);
            ++i;
        }
        return result;
    }

    public static String[] parseStringArray(String s) {
        s = String.valueOf(s);
        if ((s = StringUtils.htmlDecode(s).trim().replace("[", "").replace("]", "").replace("{", "").replace("}", "").replace("&quot;", "")).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.length() == 0) {
            return new String[0];
        }
        s = s.replace("\\\"", "\"");
        return s.split("[\"]?,[ ]*[\"]?");
    }

    public static Point parsePoint(String value) {
        String value2 = (value = String.valueOf(value)).replaceAll("[^0-9\\-+.,]", "");
        Object[] nums = value2.split("\\s*,\\s*");
        if (nums.length < 2) {
            throw new IllegalArgumentException("value=" + value + ", value2=" + value2 + ", nums=" + Arrays.toString(nums));
        }
        int x = Integer.parseInt(nums[0]);
        int y = Integer.parseInt(nums[1]);
        return new Point(x, y);
    }

    public static String plural(int n) {
        return n == 1 ? "" : "s";
    }

    public static boolean equalsIgnoreWhitespace(String s1, String s2) {
        return StringUtils.equalsIgnoreWhitespace(s1, s2, false);
    }

    public static boolean equalsIgnoreWhitespace(String s1, String s2, boolean ignoreCase) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (ignoreCase) {
            return StringUtils.removeWhitespace(s1).equalsIgnoreCase(StringUtils.removeWhitespace(s2));
        }
        return StringUtils.removeWhitespace(s1).equals(StringUtils.removeWhitespace(s2));
    }

    public static String removeWhitespace(String s) {
        if (s == null) {
            return s;
        }
        s = s.replaceAll("[ \r\n\t\f]+", "");
        return s;
    }

    public static String sortChars(String s) {
        s = String.valueOf(s);
        char[] a = s.toCharArray();
        Arrays.sort(a);
        return new String(a).intern();
    }

    public static String toAsciiDump(String s) {
        s = String.valueOf(s);
        StringBuilder sb = new StringBuilder(s.length() * 30);
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            sb.append(String.format("%3s : %3d\n", StringUtils.toPrintableChar(c), (int)c));
            ++n2;
        }
        return sb.toString();
    }

    public static String toPrintableChar(char c) {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\t': {
                return "\\t";
            }
            case '\\': {
                return "\\\\";
            }
            case '\u0000': {
                return "\\0";
            }
            case ' ': {
                return "' '";
            }
        }
        return String.valueOf(c);
    }

    public static String trimBlankLines(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(s.split("[\r]?\n")));
        while (!lines.isEmpty()) {
            if (((String)lines.get(0)).trim().isEmpty()) {
                lines.remove(0);
                continue;
            }
            if (!((String)lines.get(lines.size() - 1)).trim().isEmpty()) break;
            lines.remove(lines.size() - 1);
        }
        return CollectionUtils.join(lines, "\n");
    }

    public static String trimR(String s) {
        s = String.valueOf(s);
        int end = s.length() - 1;
        while (end >= 0 && Character.isWhitespace(s.charAt(end))) {
            --end;
        }
        return s.substring(0, end + 1);
    }

    public static String trimLines(String s) {
        if ((s = String.valueOf(s)) == null) {
            return null;
        }
        return s.replaceAll("[ \t]{0,999}\r?\n[ \t]{0,999}", "\n").trim();
    }

    public static String trimEndsOfLines(String s) {
        s = String.valueOf(s);
        return s.replaceAll("\\s+\r?\n", "\n");
    }

    public static String unindent(String s) {
        s = String.valueOf(s);
        String[] lines = s.split("[\r]?\n");
        int minIndent = Integer.MAX_VALUE;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                int indent = 0;
                while (indent < line.length() && (line.charAt(indent) == ' ' || line.charAt(indent) == '\t')) {
                    ++indent;
                }
                minIndent = Math.min(minIndent, indent);
            }
            ++n2;
        }
        minIndent = minIndent == Integer.MAX_VALUE ? 0 : minIndent;
        int i = 0;
        while (i < lines.length) {
            lines[i] = lines[i].substring(Math.min(minIndent, lines[i].length()));
            ++i;
        }
        return StringUtils.join(lines, "\n");
    }

    public static String untabify(String s) {
        return StringUtils.untabify(s, 4);
    }

    public static String untabify(String s, int tabWidth) {
        s = String.valueOf(s);
        String tab = "";
        int i = 0;
        while (i < tabWidth) {
            tab = String.valueOf(tab) + " ";
            ++i;
        }
        return s.replaceAll(TAB_STRING, tab);
    }

    public static String urlEncode(String s) {
        s = String.valueOf(s);
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return s;
        }
    }

    public static String urlDecode(String s) {
        s = String.valueOf(s);
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return s;
        }
    }
}

