/*
 * Decompiled with CFR 0.152.
 */
package stanford.karel;

import acm.util.JTFTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import stanford.karel.HPanel;
import stanford.karel.KarelBugIcon;
import stanford.karel.KarelErrorCanvas;
import stanford.karel.KarelProgram;
import stanford.karel.VPanel;

class KarelErrorDialog
extends JDialog
implements WindowListener,
ActionListener,
KeyListener {
    private Frame parent;
    private static final int DIALOG_WIDTH = 630;
    private static final int DIALOG_HEIGHT = 370;
    private static final int LOGO_WIDTH = 100;
    private static final int LOGO_HEIGHT = 100;
    private static final int BUTTON_WIDTH = 60;
    private static final Font DIALOG_FONT = new Font("SansSerif", 0, 12);
    public static final Color DIALOG_BGCOLOR = new Color(255, 96, 96);
    private KarelBugIcon bugIcon;
    private JButton okButton;
    private KarelErrorCanvas errorDisplay;

    public KarelErrorDialog(KarelProgram program) {
        super(JTFTools.getEnclosingFrame(program.getWorld()), true);
        this.parent = JTFTools.getEnclosingFrame(program.getWorld());
        this.setLayout(new BorderLayout(10, 10));
        this.init();
    }

    private void init() {
        this.setSize(630, 370);
        this.setFont(DIALOG_FONT);
        this.setBackground(DIALOG_BGCOLOR);
        this.setResizable(false);
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        HPanel hbox = new HPanel();
        hbox.setBackground(DIALOG_BGCOLOR);
        VPanel vbox = new VPanel();
        vbox.setBackground(DIALOG_BGCOLOR);
        this.bugIcon = new KarelBugIcon();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.okButton.setMnemonic('O');
        this.errorDisplay = new KarelErrorCanvas(this);
        this.errorDisplay.setFont(DIALOG_FONT);
        hbox.add("/width:100/height:100", this.bugIcon);
        hbox.add("/stretch:both", this.errorDisplay);
        vbox.add("/stretch:both", hbox);
        vbox.add("/top:3/bottom:3/width:60/center", this.okButton);
        this.add("Center", vbox);
        this.okButton.addKeyListener(this);
        this.errorDisplay.addKeyListener(this);
        this.addKeyListener(this);
        this.validate();
        this.pack();
        int centerX = this.parent.getX() + this.parent.getWidth() / 2 - 315;
        int centerY = this.parent.getY() + this.parent.getHeight() / 2 - 185;
        this.setLocation(centerX, centerY);
        this.okButton.requestFocus();
    }

    public void error(String msg) {
        this.error(msg, "");
    }

    public void error(String msg, String stackTrace) {
        this.errorDisplay.setText(msg);
        this.errorDisplay.setStackTrace(stackTrace);
        this.setVisible(true);
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Component source = (Component)e.getSource();
        if (source == this.okButton) {
            this.windowClosing(null);
        }
    }

    public void keyPressed(KeyEvent event) {
        int code = event.getKeyCode();
        if (code == 27 || code == 10 || code == 32) {
            this.okButton.doClick();
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }
}

