/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.util.ErrorException;
import acm.util.TokenScanner;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class SplPipeDecoder {
    public static final int PIPE_MAX_COMMAND_LENGTH = 2048;

    public static String decode(String s) {
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println(uee);
        }
        return s;
    }

    public static String encode(String s) {
        try {
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println(uee);
        }
        return s;
    }

    public static void encodeAndWrite(String s) {
        SplPipeDecoder.writeResult(SplPipeDecoder.encode(s));
    }

    public static String readAndDecode(TokenScanner scanner) {
        return SplPipeDecoder.decode(SplPipeDecoder.readEncodedString(scanner));
    }

    private static void eatSpaces(TokenScanner scanner) {
        int ch = scanner.getChar();
        while (ch >= 0 && Character.isWhitespace(ch)) {
            ch = scanner.getChar();
        }
        if (ch >= 0) {
            scanner.ungetChar(ch);
        }
    }

    public static synchronized void print(Object o) {
        SplPipeDecoder.print(String.valueOf(o));
    }

    public static synchronized void print(String s) {
        System.out.print(s);
        System.out.flush();
    }

    public static synchronized void println(Object o) {
        SplPipeDecoder.println(String.valueOf(o));
    }

    public static synchronized void println(String s) {
        System.out.println(s);
        System.out.flush();
    }

    public static String readEncodedString(TokenScanner scanner) {
        String s = "";
        SplPipeDecoder.eatSpaces(scanner);
        int ch = scanner.getChar();
        if (ch != 34) {
            throw new ErrorException("quoted string must start with \" character, but saw '" + (char)ch + "' (" + ch + ")");
        }
        while ((ch = scanner.getChar()) != 34 && ch >= 0) {
            s = String.valueOf(s) + (char)ch;
        }
        if (ch != 34) {
            throw new ErrorException("quoted string must end with \" character, but saw '" + (char)ch + "' (" + ch + ")");
        }
        return s;
    }

    public static synchronized void writeAck() {
        SplPipeDecoder.writeAck("");
    }

    public static synchronized void writeAck(String s) {
        SplPipeDecoder.writeResult("___jbe___ack___ " + s);
    }

    public static synchronized void writeResult(Object o) {
        SplPipeDecoder.writeResult(o == null ? "null" : o.toString());
    }

    public static synchronized void writeResult(String s) {
        if (s.length() > 2041) {
            SplPipeDecoder.writeLongResult(s);
        } else {
            SplPipeDecoder.println("result:" + s);
        }
    }

    public static synchronized void writeLongResult(String s) {
        SplPipeDecoder.println("result_long:begin");
        int i = 0;
        int len = s.length();
        while (i < len) {
            String chunk = s.substring(i, Math.min(i + 2048, len));
            SplPipeDecoder.println(chunk);
            i += 2048;
        }
        SplPipeDecoder.println("result_long:end");
    }
}

