/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import stanford.cs106.collections.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTable<R, C, V>
implements Table<R, C, V> {
    private Map<R, Map<C, V>> map = this.createTableMap();

    protected abstract Map<R, Map<C, V>> createTableMap();

    protected abstract Map<C, V> createRowMap();

    protected abstract Map<R, V> createColumnMap();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Map<R, V> column(C columnKey) {
        Map<R, V> result = this.createColumnMap();
        for (R rowKey : this.map.keySet()) {
            Map<C, V> row = this.map.get(rowKey);
            if (!row.containsKey(columnKey)) continue;
            result.put(rowKey, row.get(columnKey));
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public boolean contains(Object rowKey, Object columnKey) {
        return this.map.containsKey(rowKey) && this.map.get(rowKey).containsKey(columnKey);
    }

    @Override
    public boolean containsColumn(Object columnKey) {
        return false;
    }

    @Override
    public boolean containsRow(Object rowKey) {
        return this.map.containsKey(rowKey);
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public V get(Object rowKey, Object columnKey) {
        if (this.contains(rowKey, columnKey)) {
            return this.map.get(rowKey).get(columnKey);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V put(R rowKey, C columnKey, V value) {
        Map<C, V> row = null;
        if (this.containsRow(rowKey)) {
            row = this.map.get(rowKey);
        } else {
            row = this.createRowMap();
            this.map.put(rowKey, row);
        }
        return row.put(columnKey, value);
    }

    @Override
    public V remove(Object rowKey, Object columnKey) {
        if (this.containsRow(rowKey)) {
            Map<C, V> row = this.map.get(rowKey);
            V result = row.remove(columnKey);
            if (row.isEmpty()) {
                this.map.remove(row);
            }
            return result;
        }
        return null;
    }

    @Override
    public Map<C, V> row(R rowKey) {
        return this.map.get(rowKey);
    }

    @Override
    public Set<R> rowKeySet() {
        return this.map.keySet();
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        return this.map;
    }

    @Override
    public int size() {
        int result = 0;
        for (Map<C, V> row : this.map.values()) {
            result += row.size();
        }
        return result;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        for (Map<C, V> column : this.map.values()) {
            result.addAll(column.values());
        }
        return result;
    }
}

