/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.graphics.GCanvas;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.program.GObjectProgram;
import acm.program.GProgramListener;
import acm.program.Program;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphicsProgram
extends Program {
    private GCanvas gc;
    private GProgramListener eventListener = new GProgramListener(this);

    protected GraphicsProgram() {
        this.setGCanvas(this.createGCanvas());
        this.add((Component)this.gc, "Center");
        this.validate();
    }

    @Override
    public void run() {
    }

    @Override
    public void init() {
    }

    public GCanvas getGCanvas() {
        return this.gc;
    }

    public void add(GObject gObject) {
        this.gc.add(gObject);
    }

    public final void add(GObject gObject, double d, double d2) {
        gObject.setLocation(d, d2);
        this.add(gObject);
    }

    public final void add(GObject gObject, GPoint gPoint) {
        gObject.setLocation(gPoint);
        this.add(gObject);
    }

    public final void add(Component component, double d, double d2) {
        component.setLocation(GMath.round(d), GMath.round(d2));
        this.gc.add(component);
    }

    public final void add(Component component, GPoint gPoint) {
        this.add(component, gPoint.getX(), gPoint.getY());
    }

    public void remove(GObject gObject) {
        this.gc.remove(gObject);
    }

    @Override
    public void removeAll() {
        this.gc.removeAll();
    }

    public int getElementCount() {
        return this.gc.getElementCount();
    }

    public GObject getElement(int n) {
        return this.gc.getElement(n);
    }

    public GObject getElementAt(double d, double d2) {
        return this.gc.getElementAt(d, d2);
    }

    public final GObject getElementAt(GPoint gPoint) {
        return this.getElementAt(gPoint.getX(), gPoint.getY());
    }

    public void setGCanvas(GCanvas gCanvas) {
        this.gc = gCanvas;
        gCanvas.addMouseListener(this.eventListener);
        if (this.eventListener.needsMouseMotionListeners()) {
            gCanvas.addMouseMotionListener(this.eventListener);
        }
    }

    public Iterator<GObject> iterator() {
        return this.gc.iterator();
    }

    public Iterator<GObject> iterator(int n) {
        return this.gc.iterator(n);
    }

    public void addMouseListeners() {
        this.gc.addMouseListener(this);
        this.gc.addMouseMotionListener(this);
    }

    public void addMouseListeners(EventListener eventListener) {
        boolean bl = false;
        if (eventListener instanceof MouseListener) {
            this.gc.addMouseListener((MouseListener)eventListener);
            bl = true;
        }
        if (eventListener instanceof MouseMotionListener) {
            this.gc.addMouseMotionListener((MouseMotionListener)eventListener);
            bl = true;
        }
        if (!bl) {
            throw new ErrorException("addMouseListeners: Illegal listener");
        }
    }

    public void addKeyListeners() {
        this.gc.addKeyListener(this);
    }

    public void addKeyListeners(KeyListener keyListener) {
        this.gc.addKeyListener(keyListener);
    }

    public void waitForClick() {
        this.eventListener.waitForClick();
    }

    @Override
    public void repaint() {
        this.gc.repaint();
        super.repaint();
    }

    public void removeAllComponents() {
        super.removeAll();
    }

    @Override
    public Dimension getCentralRegionSize() {
        if (this.gc.isShowing()) {
            return this.gc.getSize();
        }
        return super.getCentralRegionSize();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.gc != null) {
            this.gc.setBackground(color);
        }
    }

    public static void startGraphicsProgram(GObject gObject, String[] stringArray) {
        GObjectProgram gObjectProgram = new GObjectProgram();
        gObjectProgram.setStartupObject(gObject);
        gObjectProgram.start(stringArray);
    }

    protected GCanvas createGCanvas() {
        return new GCanvas();
    }

    @Override
    protected void endHook() {
        this.gc.repaint();
    }

    @Override
    protected boolean isStarted() {
        if (this.gc == null || !super.isStarted()) {
            return false;
        }
        Dimension dimension = this.gc.getSize();
        return dimension != null && dimension.width != 0 && dimension.height != 0;
    }
}

