/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.util.ErrorException;
import acm.util.MediaTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;

public class GImage
extends GObject
implements GResizable {
    private Image image;
    private double width;
    private double height;
    private boolean sizeDetermined;
    static final long serialVersionUID = 21L;

    public GImage(Image image) {
        this(image, 0.0, 0.0);
    }

    public GImage(String string) {
        this(string, 0.0, 0.0);
    }

    public GImage(int[][] nArray) {
        this(nArray, 0.0, 0.0);
    }

    public GImage(Image image, double d, double d2) {
        this.setImage(image);
        this.setLocation(d, d2);
    }

    public GImage(String string, double d, double d2) {
        this(MediaTools.loadImage(string), d, d2);
    }

    public GImage(int[][] nArray, double d, double d2) {
        this(MediaTools.createImage(nArray), d, d2);
    }

    public void setImage(Image image) {
        this.image = MediaTools.loadImage(image);
        this.sizeDetermined = false;
        this.determineSize();
        this.repaint();
    }

    public void setImage(String string) {
        this.setImage(MediaTools.loadImage(string));
    }

    public Image getImage() {
        return this.image;
    }

    public void saveImage(String string) {
        MediaTools.saveImage(this.image, string);
    }

    public void saveImage(File file) {
        MediaTools.saveImage(this.image, file);
    }

    protected void paint2d(Graphics2D graphics2D) {
        Component component = this.getComponent();
        if (component == null) {
            component = MediaTools.getImageObserver();
        }
        if (this.image != null && component != null) {
            this.determineSize();
            Color color = this.getObjectColor();
            if (color == null) {
                graphics2D.drawImage(this.image, 0, 0, GMath.round(this.width), GMath.round(this.height), component);
            } else {
                graphics2D.drawImage(this.image, 0, 0, GMath.round(this.width), GMath.round(this.height), color, component);
            }
        }
    }

    public void setSize(double d, double d2) {
        if (this.getMatrix() != null) {
            throw new ErrorException("setSize: Object has been transformed");
        }
        this.width = d;
        this.height = d2;
        this.repaint();
    }

    public final void setSize(GDimension gDimension) {
        this.setSize(gDimension.getWidth(), gDimension.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.width, this.height);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        if (this.getMatrix() != null) {
            throw new ErrorException("setBounds: Object has been transformed");
        }
        this.width = d3;
        this.height = d4;
        this.setLocation(d, d2);
    }

    public final void setBounds(GRectangle gRectangle) {
        if (this.getMatrix() != null) {
            throw new ErrorException("setBounds: Object has been transformed");
        }
        this.setBounds(gRectangle.getX(), gRectangle.getY(), gRectangle.getWidth(), gRectangle.getHeight());
    }

    public GRectangle getBounds() {
        this.determineSize();
        Shape shape = new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        Rectangle rectangle = shape.getBounds();
        return new GRectangle(this.getX() + ((RectangularShape)rectangle).getX(), this.getY() + ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth(), ((RectangularShape)rectangle).getHeight());
    }

    public boolean contains(double d, double d2) {
        this.determineSize();
        Shape shape = new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        return shape.contains(d - this.getX(), d2 - this.getY());
    }

    public int[][] getPixelArray() {
        return MediaTools.getPixelArray(this.image);
    }

    public static int getAlpha(int n) {
        return n >> 24 & 0xFF;
    }

    public static int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public static int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public static int getBlue(int n) {
        return n & 0xFF;
    }

    public static int createRGBPixel(int n, int n2, int n3) {
        return GImage.createRGBPixel(n, n2, n3, 255);
    }

    public static int createRGBPixel(int n, int n2, int n3, int n4) {
        return n4 << 24 | n << 16 | n2 << 8 | n3;
    }

    private void determineSize() {
        if (this.sizeDetermined) {
            return;
        }
        Component component = this.getComponent();
        if (component == null) {
            component = MediaTools.getImageObserver();
        }
        this.width = this.image.getWidth(component);
        this.height = this.image.getHeight(component);
        this.sizeDetermined = true;
    }
}

