/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.program.Program;
import acm.util.ErrorException;
import java.awt.Button;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;

class DefaultActionListener
implements ActionListener {
    public void actionPerformed(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        Program program = this.findProgram(component);
        if (program != null && DefaultActionListener.countActionListeners(component) > 1) {
            try {
                Class[] classArray = new Class[]{Class.forName("java.awt.event.ActionListener")};
                Object[] objectArray = new Object[]{this};
                Method method = component.getClass().getMethod("removeActionListener", classArray);
                method.invoke((Object)component, objectArray);
                return;
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
        }
        String string = "No ActionListener is attached";
        if (component instanceof Button) {
            string = string + " to button " + ((Button)component).getLabel();
        } else {
            try {
                Method method = component.getClass().getMethod("getText", new Class[0]);
                string = string + " to button " + (String)method.invoke((Object)component, new Object[0]);
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
        }
        if (program == null) {
            throw new ErrorException(string);
        }
        program.getDialog().showErrorMessage(string);
    }

    protected static int countActionListeners(Component component) {
        try {
            Method method = component.getClass().getMethod("getActionListeners", new Class[0]);
            ActionListener[] actionListenerArray = (ActionListener[])method.invoke((Object)component, new Object[0]);
            return actionListenerArray.length;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private Program findProgram(Component component) {
        if (component instanceof Program) {
            return (Program)component;
        }
        if (component != null) {
            return this.findProgram(component.getParent());
        }
        return null;
    }
}

