/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.io.IOConsole;
import acm.io.StandardConsoleModel;
import acm.program.Program;
import acm.util.JTFTools;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import stanford.cs106.gui.GuiUtils;
import stanford.cs106.util.SystemProperties;

public abstract class ConsoleProgram
extends Program {
    private static final String DEFAULT_REPROMPT_MESSAGE = "Unable to open that file. Try again.";
    private InputFileReader inputReader = null;
    private boolean outputCapture = false;
    private boolean inputOverride = false;
    private List<String> echoedComments = null;
    private StringBuilder capturedOutput = new StringBuilder();
    private static final String absolveStudentStr = "[NOT THE STUDENT'S FAULT!]";

    public ConsoleProgram() {
        this.add((Component)this.getConsole(), "Center");
        this.validate();
    }

    protected void checkCompilerFlags() {
        super.checkCompilerFlags();
        if (SystemProperties.hasSystemProperty("SPL_CONSOLE_FONTSIZE")) {
            int size = SystemProperties.getSystemPropertyInt("SPL_CONSOLE_FONTSIZE");
            this.setFont("Monospaced-Bold-" + size);
        }
        if (SystemProperties.hasSystemProperty("SPL_CONSOLE_WIDTH") && SystemProperties.hasSystemProperty("SPL_CONSOLE_HEIGHT")) {
            int w = SystemProperties.getSystemPropertyInt("SPL_CONSOLE_WIDTH");
            int h = SystemProperties.getSystemPropertyInt("SPL_CONSOLE_HEIGHT");
            this.setSize(w, h);
        }
        if (SystemProperties.hasSystemProperty("SPL_CONSOLE_X") && SystemProperties.hasSystemProperty("SPL_CONSOLE_Y")) {
            int x = SystemProperties.getSystemPropertyInt("SPL_CONSOLE_X");
            int y = SystemProperties.getSystemPropertyInt("SPL_CONSOLE_Y");
            this.setLocation(x, y);
        }
        if (SystemProperties.hasSystemProperty("SPL_CONSOLE_LOCATION_SAVED") && SystemProperties.getSystemPropertyBoolean("SPL_CONSOLE_LOCATION_SAVED")) {
            GuiUtils.rememberWindowLocation(this.getJFrame());
        }
    }

    public void run() {
    }

    public void init() {
    }

    public void setFont(String str) {
        IOConsole console = this.getConsole();
        if (console != null) {
            console.setFont(str);
            super.setFont(console.getFont());
        }
    }

    public void setFont(Font font) {
        IOConsole console = this.getConsole();
        font = JTFTools.getStandardFont(font);
        if (console != null) {
            console.setFont(font);
        }
        super.setFont(font);
    }

    protected IOConsole createConsole() {
        return new IOConsole();
    }

    public void clearConsole() {
        this.getConsole().clear();
    }

    public String promptUserForFile(String prompt) {
        return this.promptUserForFile(prompt, "");
    }

    public String promptUserForFile(String prompt, String directory) {
        return this.promptUserForFile(prompt, directory, DEFAULT_REPROMPT_MESSAGE);
    }

    public String promptUserForFile(String prompt, String directory, String reprompt) {
        String filename = this.readLine(prompt);
        while (filename.isEmpty() || !new File(directory, filename).exists()) {
            this.println(reprompt);
            filename = this.readLine(prompt).trim();
        }
        if (!directory.equals("") && !(directory = directory.replace("\\", "/")).endsWith("/")) {
            directory = String.valueOf(directory) + "/";
        }
        return String.valueOf(directory) + filename;
    }

    private boolean shouldOverrideInput() {
        return this.inputOverride && this.inputReader.peekInputLine() != null;
    }

    public void overrideInput(String inputFilename) {
        if (!this.inputOverride) {
            this.inputOverride = true;
            this.inputReader = new InputFileReader(inputFilename);
            this.echoedComments = new ArrayList<String>();
            String newTitle = String.valueOf(this.getTitle()) + " [Input from " + inputFilename + "]";
            this.setTitle(newTitle);
        }
    }

    public void captureOutput() {
        this.captureOutput(true);
    }

    public void captureOutput(boolean capture) {
        this.outputCapture = capture;
        if (!this.outputCapture && this.capturedOutput.length() > 0) {
            this.capturedOutput.delete(0, this.capturedOutput.length());
        }
    }

    public String getCapturedOutput() {
        return this.capturedOutput.toString();
    }

    public void echoComments() {
        this.println(this.getComments());
    }

    public String getComments() {
        StringBuilder builder = new StringBuilder();
        if (this.inputOverride) {
            this.inputReader.flush();
            Iterator<String> iter = this.echoedComments.iterator();
            while (iter.hasNext()) {
                builder.append(iter.next().replace("#> ", ""));
                builder.append('\n');
            }
        }
        return builder.toString();
    }

    public void print(String value) {
        if (this.outputCapture) {
            this.capturedOutput.append(value);
        } else {
            super.print(value);
        }
    }

    public void println() {
        if (this.outputCapture) {
            this.capturedOutput.append('\n');
        } else {
            super.println();
        }
    }

    public void println(String value) {
        if (this.outputCapture) {
            this.capturedOutput.append(value);
            this.capturedOutput.append('\n');
        } else {
            super.println(value);
        }
    }

    public int readInt(String prompt, int min, int max) {
        int result;
        if (this.outputCapture || this.shouldOverrideInput()) {
            result = this.getInputInt();
            ConsoleProgram.checkRange(result, min, max);
            this.println(String.valueOf(prompt) + result + "\t<readInt>");
        } else {
            result = super.readInt(prompt, min, max);
        }
        return result;
    }

    public double readDouble(String prompt, double min, double max) {
        double result;
        if (this.outputCapture || this.shouldOverrideInput()) {
            result = this.getInputDouble();
            ConsoleProgram.checkRange(result, min, max);
            this.println(String.valueOf(prompt) + result + "\t<readDouble>");
        } else {
            result = super.readDouble(prompt, min, max);
        }
        return result;
    }

    private int getInputInt() {
        String line = null;
        try {
            line = this.inputReader.readInputLine();
            return Integer.parseInt(line);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("[NOT THE STUDENT'S FAULT!] Poorly formatted integer input: " + line, e);
        }
    }

    private double getInputDouble() {
        String line = null;
        try {
            line = this.inputReader.readInputLine();
            return Double.parseDouble(line);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("[NOT THE STUDENT'S FAULT!] Poorly formatted double input: " + line, e);
        }
    }

    private static void checkRange(int value, int min, int max) {
        if (min > value || max < value) {
            throw new RuntimeException("[NOT THE STUDENT'S FAULT!] Out of range [" + min + ", " + max + "] integer input: " + value);
        }
    }

    private static void checkRange(double value, double min, double max) {
        if (min > value || max < value) {
            throw new RuntimeException("[NOT THE STUDENT'S FAULT!] Out of range [" + min + ", " + max + "] double input: " + value);
        }
    }

    private JScrollPane getScrollPane() {
        IOConsole console = this.getConsole();
        StandardConsoleModel model = (StandardConsoleModel)console.getConsoleModel();
        return model.getScrollPane();
    }

    private int scrollPageHeight() {
        JScrollPane scroll = this.getScrollPane();
        if (scroll != null && scroll.getVerticalScrollBar() != null) {
            return scroll.getHeight();
        }
        return 0;
    }

    private int scrollLineHeight() {
        Font programFont = this.getFont();
        FontMetrics fm = this.getFontMetrics(programFont);
        return fm.getHeight();
    }

    private void scrollBy(int dy) {
        int y;
        JScrollPane scroll = this.getScrollPane();
        if (scroll == null) {
            return;
        }
        JScrollBar bar = scroll.getVerticalScrollBar();
        if (bar == null) {
            return;
        }
        int min = scroll.getVerticalScrollBar().getMinimum();
        int max = scroll.getVerticalScrollBar().getMaximum();
        if (dy == Integer.MIN_VALUE) {
            y = min;
        } else if (dy == Integer.MAX_VALUE) {
            y = max;
        } else {
            y = bar.getValue() + dy;
            y = Math.max(min, y);
            y = Math.min(max, y);
        }
        bar.setValue(y);
    }

    public void scrollToTop() {
        this.scrollBy(Integer.MIN_VALUE);
    }

    public void scrollToBottom() {
        this.scrollBy(Integer.MAX_VALUE);
    }

    public void scrollPageUp() {
        this.scrollBy(-this.scrollPageHeight());
    }

    public void scrollPageDown() {
        this.scrollBy(this.scrollPageHeight());
    }

    public void scrollLineUp() {
        this.scrollBy(-this.scrollLineHeight());
    }

    public void scrollLineDown() {
        this.scrollBy(this.scrollLineHeight());
    }

    private class InputFileReader {
        private BufferedReader inputReader;
        private String cachedLine;
        private static final String commentBeginStr = "#";
        private static final String echoCommentBeginStr = "#>";

        public InputFileReader(String inputFilename) {
            try {
                this.cachedLine = null;
                if (inputFilename != null) {
                    this.inputReader = new BufferedReader(new FileReader(inputFilename));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("[NOT THE STUDENT'S FAULT!] Error while opening file: " + inputFilename, e);
            }
        }

        public String readInputLine() {
            String result = this.peekInputLine();
            this.cachedLine = null;
            return result;
        }

        public String peekInputLine() {
            if (this.cachedLine == null) {
                this.advanceLine();
            }
            return this.cachedLine;
        }

        private void advanceLine() {
            if (this.inputReader == null) {
                return;
            }
            try {
                this.cachedLine = this.inputReader.readLine();
                while (this.isComment(this.cachedLine)) {
                    if (this.cachedLine.startsWith(echoCommentBeginStr)) {
                        ConsoleProgram.this.echoedComments.add(this.cachedLine);
                    }
                    this.cachedLine = this.inputReader.readLine();
                }
                if (this.cachedLine == null) {
                    ConsoleProgram.this.print("[INPUT FILE EXHAUSTED!] ");
                    this.inputReader = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("[NOT THE STUDENT'S FAULT!] Error while reading file.", e);
            }
        }

        private void flush() {
            if (this.inputReader == null) {
                return;
            }
            try {
                this.cachedLine = this.inputReader.readLine();
                while (this.cachedLine != null) {
                    if (this.cachedLine.startsWith(echoCommentBeginStr)) {
                        ConsoleProgram.this.echoedComments.add(this.cachedLine);
                    }
                    this.cachedLine = this.inputReader.readLine();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("[NOT THE STUDENT'S FAULT!] Error while reading file.", e);
            }
        }

        private boolean isComment(String str) {
            return str != null && str.startsWith(commentBeginStr);
        }
    }
}

