/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import stanford.cs106.diff.DiffGui;
import stanford.cs106.gui.GuiUtils;
import stanford.cs106.gui.WindowCloseKeyListener;
import stanford.cs106.io.ResourceUtils;
import stanford.cs106.junit.JUnitListener;
import stanford.spl.JavaBackEnd;
import stanford.spl.SPLWindowSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutograderUnitTestGUI
extends Observable
implements ActionListener,
JUnitListener,
MouseListener {
    private static final int DIALOG_WIDTH = 500;
    private static final Color ZEBRA_STRIPE_COLOR_1 = new Color(250, 250, 250);
    private static final Color ZEBRA_STRIPE_COLOR_2 = new Color(235, 235, 235);
    private static final Color PASS_COLOR = new Color(0, 96, 0);
    private static final Color FAIL_COLOR = new Color(96, 0, 0);
    private static final Color WARN_COLOR = new Color(112, 112, 0);
    private static Color NORMAL_COLOR = null;
    private static AutograderUnitTestGUI instance;
    private static AutograderUnitTestGUI styleCheckInstance;
    private static final String TESTS_TITLE = "Autograder Tests";
    private static final String STYLE_CHECK_TITLE = "Style Checker";
    private static final String ICONS_FOLDER = "res/icons/";
    private JavaBackEnd javaBackEnd;
    private JFrame frame = null;
    private JScrollPane scroll = null;
    private Box contentPaneBox = null;
    private JLabel descriptionLabel = null;
    private JLabel southLabel = null;
    private AutograderUnitTestGUIMouseAdapter mouseListener;
    private Map<String, Container> allCategories = new LinkedHashMap<String, Container>();
    private Container currentCategory = null;
    private Map<Object, TestInfo> allTests = new LinkedHashMap<Object, TestInfo>();
    private int passCount = 0;
    private int testCount = 0;
    private boolean testingIsInProgress = false;
    private int testPanelHeight = -1;
    private boolean allCategoriesHidden = false;
    private boolean checkboxesShown = true;

    public static synchronized AutograderUnitTestGUI getInstance(JavaBackEnd javaBackEnd) {
        if (instance == null) {
            instance = new AutograderUnitTestGUI(javaBackEnd, TESTS_TITLE);
        }
        return instance;
    }

    public static synchronized AutograderUnitTestGUI getInstance(JavaBackEnd javaBackEnd, boolean isStyleCheck) {
        if (isStyleCheck) {
            return AutograderUnitTestGUI.getStyleCheckInstance(javaBackEnd);
        }
        return AutograderUnitTestGUI.getInstance(javaBackEnd);
    }

    public static synchronized AutograderUnitTestGUI getStyleCheckInstance(JavaBackEnd javaBackEnd) {
        if (styleCheckInstance == null) {
            styleCheckInstance = new AutograderUnitTestGUI(javaBackEnd, STYLE_CHECK_TITLE);
        }
        return styleCheckInstance;
    }

    public AutograderUnitTestGUI(JavaBackEnd javaBackEnd, String title) {
        this.javaBackEnd = javaBackEnd;
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(1);
        this.frame.setTitle(title);
        this.frame.setVisible(false);
        this.frame.addWindowListener(new AutograderUnitTestGUIWindowAdapter());
        this.descriptionLabel = new JLabel(TESTS_TITLE);
        if (NORMAL_COLOR == null) {
            NORMAL_COLOR = this.descriptionLabel.getForeground();
        }
        this.descriptionLabel.setHorizontalAlignment(0);
        this.descriptionLabel.setAlignmentX(0.5f);
        GuiUtils.shrinkFont(this.descriptionLabel);
        this.frame.add((Component)this.descriptionLabel, "North");
        this.contentPaneBox = Box.createVerticalBox();
        this.scroll = new JScrollPane(this.contentPaneBox);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.getVerticalScrollBar().setUnitIncrement(32);
        this.frame.add((Component)this.scroll, "Center");
        this.southLabel = new JLabel(" ");
        this.southLabel.setIcon(new ImageIcon(ResourceUtils.filenameToURL("res/icons/progress.gif")));
        this.southLabel.setHorizontalTextPosition(2);
        this.southLabel.setHorizontalAlignment(0);
        this.southLabel.setAlignmentX(0.5f);
        this.frame.add((Component)this.southLabel, "South");
        this.updateSouthText();
        new WindowCloseKeyListener(this.frame);
        this.mouseListener = new AutograderUnitTestGUIMouseAdapter();
        SPLWindowSettings.loadWindowLocation(this.frame);
        SPLWindowSettings.saveWindowLocation(this.frame);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.showTestDetails(event.getActionCommand());
    }

    public Container addCategory(String name) {
        if (!this.allCategories.containsKey(name)) {
            final Box category = Box.createVerticalBox();
            this.currentCategory = category;
            category.setName("category");
            this.allCategories.put(name, this.currentCategory);
            if (!name.isEmpty()) {
                Border border;
                if (this.isStyleCheck()) {
                    border = BorderFactory.createTitledBorder(name);
                    ((TitledBorder)border).setTitleJustification(0);
                    ((Box)this.currentCategory).setBorder(border);
                } else {
                    border = BorderFactory.createLineBorder(Color.DARK_GRAY);
                    ((Box)this.currentCategory).setBorder(border);
                }
                this.currentCategory.setBackground(ZEBRA_STRIPE_COLOR_2);
            }
            if (!this.isStyleCheck()) {
                JPanel top = new JPanel(new FlowLayout(0));
                JButton selectAll = new JButton("All");
                selectAll.setIcon(new ImageIcon(ResourceUtils.filenameToURL("res/icons/checkbox-checked.gif")));
                GuiUtils.shrinkFont(selectAll, 2);
                selectAll.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        AutograderUnitTestGUI.this.selectAll(category, true);
                    }
                });
                selectAll.addMouseListener(this.mouseListener);
                selectAll.setToolTipText("Double-click to select all tests from all categories.");
                JButton deselectAll = new JButton("None");
                deselectAll.setIcon(new ImageIcon(ResourceUtils.filenameToURL("res/icons/checkbox-unchecked.gif")));
                GuiUtils.shrinkFont(deselectAll, 2);
                deselectAll.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        AutograderUnitTestGUI.this.selectAll(category, false);
                    }
                });
                deselectAll.addMouseListener(this.mouseListener);
                deselectAll.setToolTipText("Double-click to deselect all tests from all categories.");
                JButton minimize = new JButton("Hide");
                GuiUtils.shrinkFont(minimize, 2);
                minimize.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        AutograderUnitTestGUI.this.minimize(category);
                    }
                });
                minimize.addMouseListener(this.mouseListener);
                minimize.setToolTipText("Double-click to minimize all categories.");
                if (this.checkboxesShown) {
                    top.add(selectAll);
                    top.add(deselectAll);
                }
                top.add(minimize);
                if (!name.isEmpty()) {
                    JLabel nameLabel = new JLabel(name);
                    GuiUtils.shrinkFont(nameLabel, 1);
                    top.add(nameLabel);
                }
                category.add(top);
            }
            this.contentPaneBox.add(this.currentCategory);
            this.checkVisibility();
        }
        return this.allCategories.get(name);
    }

    public void addTest(String testName, String categoryName) {
        ++this.testCount;
        this.currentCategory = this.addCategory(categoryName);
        JPanel testPanel = new JPanel(new BorderLayout());
        testPanel.setName("testPanel");
        JPanel testWestPanel = new JPanel();
        Color bgColor = this.testCount % 2 == 0 ? ZEBRA_STRIPE_COLOR_1 : ZEBRA_STRIPE_COLOR_2;
        testPanel.setBackground(bgColor);
        testWestPanel.setBackground(bgColor);
        TestInfo testInfo = new TestInfo();
        testInfo.name = testName;
        this.allTests.put(testName, testInfo);
        testInfo.checked = new JCheckBox();
        testInfo.checked.setSelected(true);
        if (!this.isStyleCheck() && this.checkboxesShown) {
            testWestPanel.add(testInfo.checked);
        }
        JLabel testCountLabel = new JLabel(String.format("%3d. ", this.testCount));
        this.allTests.put(testCountLabel, testInfo);
        testCountLabel.setHorizontalAlignment(4);
        testCountLabel.setAlignmentX(1.0f);
        Font oldFont = testCountLabel.getFont();
        testCountLabel.setFont(new Font("Monospaced", 1, oldFont.getSize()));
        testWestPanel.add(testCountLabel);
        testPanel.add((Component)testWestPanel, "West");
        String testNameShort = testName.replaceAll("Test_[0-9]{1,5}_", "");
        testInfo.description = new JLabel(testNameShort);
        testInfo.description.setToolTipText("Click to see detailed results from this test.");
        GuiUtils.shrinkFont(testInfo.description);
        testInfo.description.setFont(testInfo.description.getFont().deriveFont(1));
        testPanel.add((Component)testInfo.description, "Center");
        testInfo.description.addMouseListener(this);
        this.allTests.put(testInfo.description, testInfo);
        testInfo.result = new JLabel(new ImageIcon(ResourceUtils.filenameToURL("res/icons/running.gif")));
        testInfo.result.setText("        ");
        GuiUtils.shrinkFont(testInfo.result, 2);
        testInfo.result.setHorizontalTextPosition(2);
        testInfo.result.setToolTipText("Click to see detailed results from this test.");
        testInfo.result.addMouseListener(this);
        testPanel.add((Component)testInfo.result, "East");
        this.allTests.put(testInfo.result, testInfo);
        this.currentCategory.add(testPanel);
        this.checkVisibility();
    }

    public void clearTests() {
        this.currentCategory = null;
        this.allCategories.clear();
        this.allTests.clear();
        this.passCount = 0;
        this.testCount = 0;
        this.testingIsInProgress = true;
        this.contentPaneBox.removeAll();
        this.contentPaneBox.validate();
        this.scroll.validate();
        this.updateSouthText();
        this.checkVisibility();
    }

    public void clearTestResults() {
        this.passCount = 0;
        for (TestInfo testInfo : this.allTests.values()) {
            testInfo.details.clear();
            testInfo.description.setForeground(NORMAL_COLOR);
            testInfo.result.setIcon(new ImageIcon(ResourceUtils.filenameToURL("res/icons/running.gif")));
            testInfo.result.setText("");
        }
        this.updateSouthText();
    }

    private String getTestResult(String testName) {
        TestInfo testInfo = this.allTests.get(testName);
        if (testInfo == null) {
            return "no such test";
        }
        if (testInfo.description.getForeground().equals(FAIL_COLOR)) {
            return "fail";
        }
        if (testInfo.description.getForeground().equals(WARN_COLOR)) {
            return "warn";
        }
        if (testInfo.description.getForeground().equals(PASS_COLOR)) {
            return "pass";
        }
        if (testInfo.details.containsKey("passed")) {
            String passed = (String)testInfo.details.get("passed");
            return passed.equalsIgnoreCase("true") ? "pass" : "fail";
        }
        return "unknown";
    }

    public int getFailedCount() {
        return this.getTestCount() - this.getPassedCount();
    }

    public int getPassedCount() {
        return this.passCount;
    }

    public int getTestCount() {
        return this.getCheckedTestCount();
    }

    public boolean isChecked(String testName) {
        TestInfo testInfo = this.allTests.get(testName);
        if (testInfo == null) {
            return false;
        }
        return testInfo.checked.isSelected();
    }

    public boolean isEmpty() {
        return this.allCategories.isEmpty();
    }

    public boolean isStyleCheck() {
        return this == styleCheckInstance || this.frame.getTitle().equals(STYLE_CHECK_TITLE);
    }

    public boolean isVisible() {
        return this.frame != null && this.frame.isVisible();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        JLabel label = (JLabel)event.getSource();
        TestInfo testInfo = this.allTests.get(label);
        String testName = testInfo.name;
        if (testName != null) {
            this.showTestDetails(testName);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    public void setChecked(String testName, boolean checked) {
        TestInfo testInfo = this.allTests.get(testName);
        if (testInfo != null) {
            testInfo.checked.setSelected(checked);
        }
    }

    public void setDescription(String text) {
        text = text.replaceAll("[ \t\r\n\f]+", " ");
        text = text.replaceAll("Note:", "<b>Note:</b>");
        text = text.replaceAll("Warning:", "<b>Warning:</b>");
        text = text.replaceAll("Error:", "<b>Error:</b>");
        this.descriptionLabel.setText("<html><body style='width: 500; max-width: 500'><center>" + text + "</center></body></html>");
        this.descriptionLabel.validate();
        this.checkVisibility();
    }

    @Override
    public void setTestCounts(int passCount, int testCount) {
        this.passCount = passCount;
        this.testCount = testCount;
        this.updateSouthText();
    }

    @Override
    public void setTestDetails(String testName, Map<String, String> details) {
        TestInfo testInfo = this.allTests.get(testName);
        if (testInfo == null) {
            return;
        }
        String existingResult = this.getTestResult(testName).intern();
        if (!(existingResult != "fail" && existingResult != "warn" || testInfo.details.isEmpty())) {
            return;
        }
        testInfo.details = details;
    }

    @Override
    public void setTestDetailsMessage(String testName, String detailsMessage) {
        TreeMap<String, String> details = new TreeMap<String, String>();
        details.put("testType", "MANUAL");
        details.put("message", detailsMessage);
        this.setTestDetails(testName, details);
    }

    @Override
    public void setTestingCompleted(boolean completed) {
        this.testingIsInProgress = !completed;
        this.updateSouthText();
    }

    @Override
    public boolean setTestResult(String testName, String result) {
        TestInfo testInfo;
        if ((result = result.toLowerCase().intern()) == "error") {
            result = "fail";
        }
        if ((testInfo = this.allTests.get(testName)) == null) {
            return false;
        }
        String existingResult = this.getTestResult(testName).intern();
        if ((existingResult == "fail" || existingResult == "warn") && result != "fail") {
            return true;
        }
        testInfo.result.setIcon(new ImageIcon(ResourceUtils.filenameToURL(ICONS_FOLDER + result + ".gif")));
        if (result == "pass") {
            ++this.passCount;
            testInfo.description.setForeground(PASS_COLOR);
        } else if (result == "fail") {
            testInfo.description.setForeground(FAIL_COLOR);
        } else if (result == "warn") {
            testInfo.description.setForeground(WARN_COLOR);
        } else if (result == "warn") {
            testInfo.description.setForeground(NORMAL_COLOR);
        }
        this.updateSouthText();
        return true;
    }

    @Override
    public boolean setTestRuntime(String testName, int runtimeMS) {
        TestInfo testInfo = this.allTests.get(testName);
        if (testInfo == null) {
            return false;
        }
        String text = " (" + runtimeMS + "ms)";
        testInfo.result.setText(text);
        return true;
    }

    public void setCheckboxesShown(boolean shown) {
        this.checkboxesShown = shown;
    }

    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    private void checkVisibility() {
        this.contentPaneBox.revalidate();
        this.scroll.revalidate();
        this.frame.validate();
        this.frame.pack();
        this.frame.setSize(this.frame.getWidth() + 32, this.frame.getHeight() + 10);
    }

    private void minimize(Container category) {
        this.minimize(category, !category.getName().contains("hidden"));
    }

    private void minimize(Container category, boolean minimized) {
        if (minimized) {
            category.setName("category_hidden");
        } else {
            category.setName("category");
        }
        Component[] componentArray = category.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            JPanel panel;
            String name;
            Component comp = componentArray[n2];
            if (comp instanceof JPanel && (name = (panel = (JPanel)comp).getName()) != null && name.equals("testPanel")) {
                Dimension size = panel.getPreferredSize();
                if (this.testPanelHeight < 0) {
                    this.testPanelHeight = size.height;
                }
                size.height = minimized ? 0 : this.testPanelHeight;
                panel.setPreferredSize(size);
                if (minimized) {
                    panel.setMaximumSize(size);
                } else {
                    panel.setMaximumSize(null);
                }
                panel.invalidate();
                category.invalidate();
            }
            ++n2;
        }
        category.validate();
        this.contentPaneBox.validate();
        this.scroll.validate();
        this.frame.validate();
    }

    private void selectAll(Container category, boolean selected) {
        Component[] componentArray = category.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)comp;
                checkBox.setSelected(selected);
            } else if (comp instanceof Container) {
                Container container = (Container)comp;
                this.selectAll(container, selected);
            }
            ++n2;
        }
    }

    private void showTestDetails(String testName) {
        String valueType;
        TestInfo testInfo = this.allTests.get(testName);
        if (testInfo == null) {
            return;
        }
        Map deets = testInfo.details;
        if (deets.isEmpty()) {
            return;
        }
        boolean passed = deets.containsKey("passed") && ((String)deets.get("passed")).equalsIgnoreCase("true");
        String type = deets.containsKey("testType") ? ((String)deets.get("testType")).toUpperCase().intern() : "";
        String message = (String)deets.get("message");
        if (type == "ASSERT_EQUALS") {
            message = String.valueOf(message) + " (must be equal)";
        } else if (type == "ASSERT_NOT_EQUALS") {
            message = String.valueOf(message) + " (must be non-equal)";
        } else if (type == "ASSERT_NEAR") {
            message = String.valueOf(message) + " (must be nearly equal)";
        } else if (type == "ASSERT_DIFF") {
            message = String.valueOf(message) + " (program output must match)";
        } else if (type == "ASSERT_TRUE") {
            message = String.valueOf(message) + " (must be true)";
        } else if (type == "ASSERT_FALSE") {
            message = String.valueOf(message) + " (must be false)";
        } else if (type != "EXCEPTION") {
            if (type == "NOT_EXCEPTION") {
                message = String.valueOf(message) + " (didn't throw expected exception)";
            } else if (type == "PASS") {
                message = String.valueOf(message) + " (passed)";
            } else if (type == "FAIL") {
                message = String.valueOf(message) + " (failed)";
            }
        }
        String expected = String.valueOf(deets.get("expected"));
        String student = String.valueOf(deets.get("student"));
        String string = valueType = deets.containsKey("valueType") ? ((String)deets.get("valueType")).toLowerCase().intern() : "";
        if (valueType == "string") {
            expected = "\"" + expected + "\"";
            student = "\"" + student + "\"";
        } else if (valueType == "char") {
            expected = "'" + expected + "'";
            student = "'" + student + "'";
        }
        boolean shouldShowJOptionPane = true;
        if (type == "ASSERT_EQUALS" || type == "ASSERT_NOT_EQUALS" || type == "ASSERT_NEAR" || type == "STYLE_CHECK") {
            String htmlMessage = "";
            htmlMessage = String.valueOf(htmlMessage) + "<html><body style='max-width: 500px;'>";
            htmlMessage = String.valueOf(htmlMessage) + "<p>" + message + "</p>";
            htmlMessage = String.valueOf(htmlMessage) + "<ul>";
            htmlMessage = String.valueOf(htmlMessage) + "<li><font style='font-family: monospaced' color='#00aa00'>expected:</font>" + expected + "</li>";
            htmlMessage = String.valueOf(htmlMessage) + "<li><font style='font-family: monospaced' color='#aa0000'>student :</font>" + student + "</li>";
            htmlMessage = String.valueOf(htmlMessage) + "</ul>";
            htmlMessage = String.valueOf(htmlMessage) + "</body></html>";
            htmlMessage = htmlMessage.replace("\n", "\\n");
            htmlMessage = htmlMessage.replace("\r", "\\r");
            message = htmlMessage = htmlMessage.replace("\t", "\\t");
        } else if (type == "ASSERT_DIFF") {
            shouldShowJOptionPane = false;
            new DiffGui("expected output", expected, "student output", student).show();
        } else if (type == "MANUAL") {
            shouldShowJOptionPane = true;
            String htmlMessage = "";
            htmlMessage = String.valueOf(htmlMessage) + "<html><body style='max-width: 500px;'>";
            htmlMessage = String.valueOf(htmlMessage) + "<pre>" + message + "</pre>";
            htmlMessage = String.valueOf(htmlMessage) + "</body></html>";
            htmlMessage = htmlMessage.replace("\n", "<br>");
            htmlMessage = htmlMessage.replace("\r", "");
            message = htmlMessage = htmlMessage.replace("\t", "    ");
        }
        if (shouldShowJOptionPane) {
            JOptionPane.showMessageDialog(this.frame, message, testName, passed ? 1 : 0);
        }
        this.setChanged();
        this.notifyObservers(testName);
    }

    private int getCheckedTestCount() {
        int count = 0;
        HashSet<TestInfo> tests = new HashSet<TestInfo>(this.allTests.values());
        for (TestInfo info : tests) {
            if (!this.isChecked(info.name)) continue;
            ++count;
        }
        return count;
    }

    private void updateSouthText() {
        String text = "passed " + this.passCount + " / " + this.getCheckedTestCount() + " tests";
        if (this.testingIsInProgress) {
            text = String.valueOf(text) + " (running ...)";
            if (this.southLabel.getIcon() == null) {
                this.southLabel.setIcon(new ImageIcon(ResourceUtils.filenameToURL("res/icons/progress.gif")));
            }
        } else {
            text = String.valueOf(text) + " (complete)";
            this.southLabel.setIcon(null);
        }
        this.southLabel.setText(text);
    }

    private class AutograderUnitTestGUIMouseAdapter
    extends MouseAdapter {
        private AutograderUnitTestGUIMouseAdapter() {
        }

        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                JButton button = (JButton)event.getSource();
                if (button.getText().contains("All")) {
                    AutograderUnitTestGUI.this.selectAll(AutograderUnitTestGUI.this.contentPaneBox, true);
                } else if (button.getText().contains("None")) {
                    AutograderUnitTestGUI.this.selectAll(AutograderUnitTestGUI.this.contentPaneBox, false);
                } else if (button.getText().contains("Hide")) {
                    AutograderUnitTestGUI.this.allCategoriesHidden = !AutograderUnitTestGUI.this.allCategoriesHidden;
                    for (Container category : AutograderUnitTestGUI.this.allCategories.values()) {
                        AutograderUnitTestGUI.this.minimize(category, AutograderUnitTestGUI.this.allCategoriesHidden);
                    }
                }
            }
        }
    }

    private class AutograderUnitTestGUIWindowAdapter
    extends WindowAdapter {
        private AutograderUnitTestGUIWindowAdapter() {
        }

        public void windowClosing(WindowEvent event) {
            if (AutograderUnitTestGUI.this.testingIsInProgress && AutograderUnitTestGUI.this.javaBackEnd != null) {
                AutograderUnitTestGUI.this.javaBackEnd.shutdownBackEnd(true);
            }
        }
    }

    private class TestInfo {
        private String name;
        private JCheckBox checked;
        private JLabel description;
        private JLabel result;
        private Map<String, String> details = new LinkedHashMap<String, String>();

        private TestInfo() {
        }
    }
}

