/* Ashley Taylor
 * CS106B
 * Reverse Polish Notation
 * This code takes an instruction
 * in Reverse Polish Notation
 * and outputs the result of the expression.
 * Only works on one-digit numbers.
 */


#include <iostream>
#include <sstream>
#include "console.h"
#include "gwindow.h" // for GWindow
#include "simpio.h"  // for getLine
#include "stack.h"   // for Stack
#include "queue.h"
#include "vector.h"  // for Vector
using namespace std;

int evalExpr(string input);
int compute(int first, int second, char op);

int main() {
    string input = "43*725*++";
    cout << "The output is: " << evalExpr(input);
    return 0;
}

// helpful methods to know:
// isdigit(ch)
// ch - '0' converts digits to numbers
int evalExpr(string input) {
    Stack<int> memory;
    for (int i = 0; i < input.length(); i++) {
        if (isdigit(input[i])) {
            int num = input[i] - '0';
            memory.push(num);
        } else {
            //operator
            int second = memory.pop();
            int first = memory.pop();
            char op = input[i];
            int val = compute(first, second, op);
            memory.push(val);
        }
    }

    return memory.pop(); //TODO: change this
}

// helper function that converts from characters
// to their mathematical operations
int compute(int first, int second, char op) {
    if (op == '*') {
        return first * second;
    } else if (op == '+') {
        return first + second;
    } else if (op == '-') {
        return first - second;
    } else if (op == '/') {
        return first / second;
    } else {
        throw "A non operator was passed";
    }
}
