/* Ashley Taylor
 * CS106B
 *
 * Where2Eat takes a file like this:
 * guest
 * restaurant
 * restaurant
 *
 * guest
 * ...
 *
 * And then asks for a group of people to eat together
 * and prints all the acceptable restaurants
 */

#include <fstream>
#include <iostream>
#include "console.h"
#include "filelib.h"
#include "map.h"
#include "set.h"
#include "simpio.h"
using namespace std;

int main() {
    ifstream file;
    file.open("restaurants.txt");
    string myFriend;

    Map<string, Set<string>> restaurantPreferences;


    while (getline(file, myFriend)) {
        string restaurant;
        while (getline(file, restaurant) && restaurant != "") {
            restaurantPreferences[myFriend] += restaurant;
        }
    }

    string guest = getLine("Enter a guest: ");
    while (guest != "") {
        // We need to initialize the set
        // with all the preferences of the first guest
        Set<string> acceptableRestaurants = restaurantPreferences[guest];
        while (guest != "") {
            // Now we intersect the acceptable restaurants
            // with the restaurant preferences of this new guest
            acceptableRestaurants *= restaurantPreferences[guest];
            guest = getLine("Enter a guest: ");
        }

        cout << "Here are the acceptable restaurants:" << endl;
        cout << acceptableRestaurants << endl;
        cout << endl;
        guest = getLine("Enter a guest: ");
    }
    return 0;
}
