/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TreeMap;
import org.junit.ComparisonFailure;
import org.junit.Test;
import stanford.cs106.junit.ComparisonFailureEnhanced;
import stanford.cs106.junit.JUnitListener;
import stanford.cs106.junit.TestCategory;
import stanford.cs106.junit.UnitTestType;
import stanford.cs106.reflect.ReflectionRuntimeException;
import stanford.cs106.reflect.ReflectionUtils;
import stanford.cs106.util.ExceptionUtils;
import stanford.cs106.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitUtils {
    private static final int STACK_TRACE_LINES_TO_DISPLAY = 10;

    private JUnitUtils() {
    }

    public static String getTestCategory(Class<?> clazz, Method method) {
        return JUnitUtils.getTestCategory(clazz, method, true);
    }

    public static String getTestCategory(Class<?> clazz, Method method, boolean infer) {
        TestCategory anno = method.getAnnotation(TestCategory.class);
        if (anno == null) {
            if (infer) {
                String methodName = method.getName();
                if (methodName.matches("test[0-9]+_.*_.*")) {
                    methodName = methodName.replaceAll("test[0-9]+_", "");
                    methodName = methodName.replaceAll("_.*", "");
                    return methodName;
                }
                return "";
            }
        } else {
            Class<? extends Annotation> annoClass = anno.annotationType();
            Method valueMethod = ReflectionUtils.getMethod(annoClass, "value");
            if (valueMethod != null) {
                try {
                    String categoryName = (String)valueMethod.invoke((Object)anno, new Object[0]);
                    if (categoryName != null) {
                        return categoryName;
                    }
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionRuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionRuntimeException(e);
                }
            }
        }
        return "";
    }

    public static boolean isJUnitMethod(Class<?> clazz, Method method) {
        return method.getAnnotation(Test.class) != null;
    }

    public static boolean isJUnitMethod(Class<?> clazz, String methodName) {
        return JUnitUtils.isJUnitMethod(clazz, ReflectionUtils.getMethod(clazz, methodName));
    }

    public static void runJUnitMethod(Class<?> junitClass, Method method, JUnitListener listener) {
        String testName = method.getName();
        Test annotation = method.getAnnotation(Test.class);
        Class<? extends Annotation> annoClass = annotation.annotationType();
        long timeout = Integer.MAX_VALUE;
        Method timeoutMethod = ReflectionUtils.getMethod(annoClass, "timeout");
        if (timeoutMethod != null) {
            try {
                Long timeoutInteger = (Long)timeoutMethod.invoke((Object)annotation, new Object[0]);
                if (timeoutInteger != null) {
                    timeout = timeoutInteger;
                }
            }
            catch (IllegalAccessException e) {
                throw new ReflectionRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionRuntimeException(e);
            }
        }
        Class expectedExceptionClass = null;
        Method expectedMethod = ReflectionUtils.getMethod(annoClass, "expected");
        if (expectedMethod != null) {
            try {
                expectedExceptionClass = (Class)expectedMethod.invoke((Object)annotation, new Object[0]);
                if (expectedExceptionClass != null && expectedExceptionClass.getName().endsWith("None")) {
                    expectedExceptionClass = null;
                }
            }
            catch (IllegalAccessException e) {
                throw new ReflectionRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionRuntimeException(e);
            }
        }
        try {
            Object junitObj = junitClass.newInstance();
            JUnitTestRunnable run = new JUnitTestRunnable();
            run.method = method;
            run.object = junitObj;
            Thread thread = new Thread(run);
            long startTime = System.currentTimeMillis();
            thread.start();
            thread.join(timeout);
            if (thread.isAlive()) {
                thread.stop();
                if (listener != null) {
                    listener.setTestResult(testName, "fail");
                    listener.setTestDetailsMessage(testName, "test timed out after " + timeout + "ms");
                }
            } else if (listener != null && run.passed) {
                listener.setTestResult(testName, "pass");
            }
            long endTime = System.currentTimeMillis();
            long runtimeMS = endTime - startTime;
            if (run.thrown != null) {
                listener.setTestResult(testName, "fail");
                TreeMap<String, String> details = new TreeMap<String, String>();
                if (run.thrown instanceof ComparisonFailure) {
                    ComparisonFailure failure = (ComparisonFailure)((Object)run.thrown);
                    String expected = failure.getExpected();
                    String actual = failure.getActual();
                    String message = failure.getMessage();
                    String detailsText = "";
                    String testType = UnitTestType.ASSERT_EQUALS.toString();
                    String valueType = "";
                    if (run.thrown instanceof ComparisonFailureEnhanced) {
                        ComparisonFailureEnhanced failure2 = (ComparisonFailureEnhanced)((Object)run.thrown);
                        detailsText = failure2.getDetails();
                        testType = failure2.getType().toString();
                        valueType = failure2.getValueType();
                        if (failure2.getType() == UnitTestType.ASSERT_DIFF) {
                            message = detailsText;
                        }
                        String stackTrace = ExceptionUtils.stackTraceToString(run.thrown, 10);
                        stackTrace = ExceptionUtils.filterStackTrace(stackTrace, "sun.", "junit.", "org.", "java.lang.reflect.", "java.lang.Thread.", "stanford.");
                        String[] stackTraceLines = stackTrace.split("\r?\n");
                        stackTrace = StringUtils.join(stackTraceLines, "\n", 1, 0);
                        stackTrace = stackTrace.replaceAll("at [a-zA-Z_0-9]+\\.", "at ");
                        stackTrace = stackTrace.replaceAll("\\(", " (");
                        details.put("stackTrace", stackTrace);
                    }
                    details.put("testType", testType);
                    details.put("expected", expected);
                    details.put("student", actual);
                    details.put("actual", actual);
                    details.put("message", message);
                    details.put("valueType", valueType);
                    details.put("passed", "false");
                } else if (run.thrown instanceof AssertionError) {
                    AssertionError failure = (AssertionError)((Object)run.thrown);
                    System.out.println("FAILURE: " + failure);
                    System.out.println("CAUSE  : " + ((Throwable)((Object)failure)).getCause());
                    String expected = "passed assertion";
                    String actual = "failed assertion";
                    String message = ((Throwable)((Object)failure)).getMessage();
                    String testType = UnitTestType.ASSERT_TRUE.toString();
                    String valueType = "";
                    details.put("testType", testType);
                    details.put("expected", expected);
                    details.put("student", actual);
                    details.put("actual", actual);
                    details.put("message", message);
                    details.put("valueType", valueType);
                    details.put("passed", "false");
                } else {
                    details.put("testType", UnitTestType.EXCEPTION.toString());
                    details.put("message", "test threw: " + run.thrown);
                }
                listener.setTestDetails(testName, details);
            }
            if (listener != null) {
                listener.setTestRuntime(testName, (int)runtimeMS);
            }
        }
        catch (InstantiationException e) {
            throw new ReflectionRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionRuntimeException(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class JUnitTestRunnable
    implements Runnable {
        public Method method;
        public Object object;
        public Throwable thrown;
        public boolean passed = true;

        private JUnitTestRunnable() {
        }

        public void run() {
            try {
                this.method.invoke(this.object, new Object[0]);
            }
            catch (Throwable t) {
                this.passed = false;
                this.thrown = ExceptionUtils.getUnderlyingCause(t);
            }
        }
    }
}

