/*
 * Decompiled with CFR 0.152.
 */
package stanford.karel;

import acm.program.Program;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.UIManager;
import stanford.karel.KarelProgram;
import stanford.karel.KarelWorld;

public class Karel
extends Program
implements Runnable {
    private static final int NORTH = 0;
    private static final int EAST = 1;
    private static final int SOUTH = 2;
    private static final int WEST = 3;
    private static final String[] SKIP_JARS = new String[]{"acm.jar", "karel.jar"};
    private KarelWorld world = null;
    private int x = 1;
    private int y = 1;
    private int dir = 1;
    private int beepers;

    public void run() {
    }

    public void move() {
        this.checkWorld("move");
        if (this.world.checkWall(this.x, this.y, this.dir)) {
            throw new ErrorException("Karel is blocked");
        }
        this.setLocation(KarelWorld.adjacentPoint(this.x, this.y, this.dir));
        this.world.trace();
    }

    public void turnLeft() {
        this.checkWorld("turnLeft");
        this.setDirection(KarelWorld.leftFrom(this.dir));
        this.world.trace();
    }

    public void pickBeeper() {
        this.checkWorld("pickBeeper");
        int nb = this.world.getBeepersOnCorner(this.x, this.y);
        if (nb < 1) {
            throw new ErrorException("pickBeeper: No beepers on this corner");
        }
        this.world.setBeepersOnCorner(this.x, this.y, KarelWorld.adjustBeepers(nb, -1));
        this.setBeepersInBag(KarelWorld.adjustBeepers(this.getBeepersInBag(), 1));
        this.world.trace();
    }

    public void putBeeper() {
        this.checkWorld("putBeeper");
        int nBag = this.getBeepersInBag();
        if (nBag < 1) {
            throw new ErrorException("putBeeper: No beepers in bag");
        }
        int nCorner = this.world.getBeepersOnCorner(this.x, this.y);
        this.world.setBeepersOnCorner(this.x, this.y, KarelWorld.adjustBeepers(nCorner, 1));
        this.setBeepersInBag(KarelWorld.adjustBeepers(nBag, -1));
        this.world.trace();
    }

    public boolean frontIsClear() {
        this.checkWorld("frontIsClear");
        return !this.world.checkWall(this.x, this.y, this.dir);
    }

    public boolean frontIsBlocked() {
        this.checkWorld("frontIsBlocked");
        return this.world.checkWall(this.x, this.y, this.dir);
    }

    public boolean leftIsClear() {
        this.checkWorld("leftIsClear");
        return !this.world.checkWall(this.x, this.y, KarelWorld.leftFrom(this.dir));
    }

    public boolean leftIsBlocked() {
        this.checkWorld("leftIsBlocked");
        return this.world.checkWall(this.x, this.y, KarelWorld.leftFrom(this.dir));
    }

    public boolean rightIsClear() {
        this.checkWorld("rightIsClear");
        return !this.world.checkWall(this.x, this.y, KarelWorld.rightFrom(this.dir));
    }

    public boolean rightIsBlocked() {
        this.checkWorld("rightIsBlocked");
        return this.world.checkWall(this.x, this.y, KarelWorld.rightFrom(this.dir));
    }

    public boolean beepersPresent() {
        this.checkWorld("beepersPresent");
        return this.world.getBeepersOnCorner(this.x, this.y) > 0;
    }

    public boolean noBeepersPresent() {
        this.checkWorld("noBeepersPresent");
        return this.world.getBeepersOnCorner(this.x, this.y) == 0;
    }

    public boolean beepersInBag() {
        this.checkWorld("beepersInBag");
        return this.getBeepersInBag() > 0;
    }

    public boolean noBeepersInBag() {
        this.checkWorld("noBeepersInBag");
        return this.getBeepersInBag() == 0;
    }

    public boolean facingNorth() {
        this.checkWorld("facingNorth");
        return this.dir == 0;
    }

    public boolean facingEast() {
        this.checkWorld("facingEast");
        return this.dir == 1;
    }

    public boolean facingSouth() {
        this.checkWorld("facingSouth");
        return this.dir == 2;
    }

    public boolean facingWest() {
        this.checkWorld("facingWest");
        return this.dir == 3;
    }

    public boolean notFacingNorth() {
        this.checkWorld("notFacingNorth");
        return this.dir != 0;
    }

    public boolean notFacingEast() {
        this.checkWorld("notFacingEast");
        return this.dir != 1;
    }

    public boolean notFacingSouth() {
        this.checkWorld("notFacingSouth");
        return this.dir != 2;
    }

    public boolean notFacingWest() {
        this.checkWorld("notFacingWest");
        return this.dir != 3;
    }

    public static void main(String[] args) {
        try {
            String lnf = UIManager.getSystemLookAndFeelClassName();
            if (lnf == null || lnf.contains("MetalLookAndFeel")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else {
                UIManager.setLookAndFeel(lnf);
            }
        }
        catch (Exception lnf) {
            // empty catch block
        }
        ArrayList<String> argList = new ArrayList<String>();
        boolean codeFlag = false;
        int i = 0;
        while (i < args.length) {
            argList.add(args[i]);
            if (args[i].startsWith("code=")) {
                codeFlag = true;
            }
            ++i;
        }
        if (!codeFlag) {
            String className = Karel.getMainClassName();
            if (className.endsWith(".class")) {
                className = className.substring(0, className.length() - 6);
            }
            className = className.replace('/', '.');
            argList.add("code=" + className);
        }
        argList.add("program=stanford.karel.KarelProgram");
        String[] argArray = new String[argList.size()];
        int i2 = 0;
        while (i2 < argArray.length) {
            argArray[i2] = (String)argList.get(i2);
            ++i2;
        }
        KarelProgram.main(argArray);
    }

    public void start(String[] args) {
        KarelProgram program = new KarelProgram();
        program.setStartupObject(this);
        program.start(args);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point pt) {
        this.setLocation(pt.x, pt.y);
    }

    public void setLocation(int x, int y) {
        if (this.world != null) {
            if (this.world.outOfBounds(x, y)) {
                throw new ErrorException("setLocation: Out of bounds");
            }
            Karel occupant = this.world.getKarelOnSquare(x, y);
            if (occupant == this) {
                return;
            }
            if (occupant != null) {
                throw new ErrorException("setLocation: Square is occupied");
            }
        }
        int x0 = this.x;
        int y0 = this.y;
        this.x = x;
        this.y = y;
        if (this.world != null) {
            this.world.updateCorner(x, y);
            this.world.updateCorner(x0, y0);
        }
    }

    protected int getDirection() {
        return this.dir;
    }

    protected void setDirection(int dir) {
        this.dir = dir;
        if (this.world != null) {
            this.world.updateCorner(this.x, this.y);
        }
    }

    protected int getBeepersInBag() {
        return this.beepers;
    }

    protected void setBeepersInBag(int nBeepers) {
        this.beepers = nBeepers;
    }

    protected KarelWorld getWorld() {
        return this.world;
    }

    protected void setWorld(KarelWorld world) {
        this.world = world;
    }

    protected void checkWorld(String caller) {
        if (this.world == null) {
            throw new ErrorException(String.valueOf(caller) + ": Karel is not living in a world");
        }
    }

    public void setDisplayOneFlag(boolean flag) {
        this.world.setDisplayOneFlag(flag);
    }

    private static String getMainClassName() {
        String result = null;
        String classpath = System.getProperty("java.class.path");
        if (classpath == null) {
            classpath = System.getProperty("user.dir");
        }
        if (classpath == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(classpath, ":;");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            File file = new File(token);
            String[] candidates = null;
            if (file.isDirectory()) {
                candidates = file.list();
            } else if (token.endsWith(".jar") && !Karel.nameAppears(token, SKIP_JARS)) {
                try {
                    ZipFile zf = new ZipFile(file);
                    ArrayList<String> list = new ArrayList<String>();
                    Enumeration<? extends ZipEntry> entries = zf.entries();
                    while (entries.hasMoreElements()) {
                        list.add(entries.nextElement().getName());
                    }
                    candidates = new String[list.size()];
                    int i = 0;
                    while (i < candidates.length) {
                        candidates[i] = (String)list.get(i);
                        ++i;
                    }
                    zf.close();
                }
                catch (IOException ex) {
                    candidates = null;
                }
            }
            if (candidates == null) continue;
            int i = 0;
            while (i < candidates.length) {
                String className;
                String fileName = candidates[i];
                if (fileName.endsWith(".class") && (className = fileName.substring(0, fileName.lastIndexOf(".class"))).indexOf("/") == -1 && JTFTools.checkIfLoaded(className)) {
                    try {
                        Class<?> karelClass = Class.forName("stanford.karel.Karel");
                        Class<?> c = Class.forName(className);
                        if (karelClass.isAssignableFrom(c)) {
                            result = className;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private static boolean nameAppears(String name, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

