/**
 * File: password-guesser.cpp
 * ---------------------------
 * A first look at combining loops with recursion to generate
 * permutations.
 *
 * (c) Cynthia Lee 2015
 *
 */

#include <iostream>
#include <fstream>
using namespace std;

#include "simpio.h"
#include "console.h"
#include "filelib.h"


/* Function Prototypes */
// Actual recursive function
void generateAllPINs(int length, Vector<Vector<int>> &allPINs,
                     Vector<int> currentPIN);
// Wrapper
void generateAllPINs(int length, Vector<Vector<int>> &allPINs);


// PUBLIC-FACING FUNCTION (the "wrapper")
void generateAllPINs(int length, Vector<Vector<int>> &allPINs) {
    Vector<int> currentPIN;
    generateAllPINs(length, allPINs, currentPIN);
}


// SECRET BEHIND THE SCENES FUNCTION (the recursive one)
void generateAllPINs(int length, Vector<Vector<int>> &allPINs,
                     Vector<int> currentPIN) {
    if (currentPIN.size() == length) {
        allPINs.add(currentPIN);
        return;
    }
    currentPIN.add(0);
    for (int digit = 0; digit <= 9; digit++) {
        currentPIN[currentPIN.size() - 1] = digit;
        generateAllPINs(length, allPINs, currentPIN);
    }
 }



/*
 * Generate all numeric PINs of length N
 * Write them to a file or console.
 */
int main() {
    while (true){
        int length = getInteger("Number of digits in PIN? (0 to quit) ");
        if (length <= 0) break;
        Vector<Vector<int>> allPINs;
        generateAllPINs(length, allPINs);
        int choice = getInteger("Output to: (1) file, or (2) console? ");
        if (choice == 1) {
            ofstream outfile;
            promptUserForFile(outfile, "Enter output filename: ");
            for (Vector<int> PIN : allPINs) {
                outfile << PIN << endl;
            }
        } else {
            for (Vector<int> PIN : allPINs) {
                cout << PIN << endl;
            }
        }
    }
    return 0;
}

