/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvasListener;
import acm.graphics.GContainer;
import acm.graphics.GIterator;
import acm.graphics.GMath;
import acm.graphics.GMouseEvent;
import acm.graphics.GObject;
import acm.graphics.GObjectList;
import acm.graphics.GPoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCanvas
extends JComponent
implements GContainer {
    private static final long serialVersionUID = 0L;
    private GCanvasListener gCanvasListener;
    private GObject lastObject;
    private GObject dragObject;
    private GObjectList contents = new GObjectList(this);
    private boolean autoRepaint;
    private boolean nativeArcFlag;

    public GCanvas() {
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setOpaque(true);
        this.setAutoRepaintFlag(true);
        this.setNativeArcFlag(false);
        this.setLayout(null);
        this.gCanvasListener = new GCanvasListener(this);
        this.addMouseListener(this.gCanvasListener);
        this.addMouseMotionListener(this.gCanvasListener);
    }

    @Override
    public void add(GObject gobject) {
        this.contents.add(gobject);
        this.conditionalRepaint();
    }

    @Override
    public final void add(GObject gobject, double d, double d1) {
        gobject.setLocation(d, d1);
        this.add(gobject);
    }

    @Override
    public final void add(GObject gobject, GPoint gpoint) {
        this.add(gobject, gpoint.getX(), gpoint.getY());
    }

    @Override
    public void remove(GObject gobject) {
        this.contents.remove(gobject);
        this.conditionalRepaint();
    }

    @Override
    public void removeAll() {
        this.contents.removeAll();
        super.removeAll();
        this.repaint();
    }

    @Override
    public Component add(Component component) {
        super.add(component);
        Dimension dimension = component.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            Dimension dimension1 = component.getPreferredSize();
            if (dimension.width == 0) {
                dimension.width = dimension1.width;
            }
            if (dimension.height == 0) {
                dimension.height = dimension1.height;
            }
            component.setSize(dimension);
        }
        return component;
    }

    public final void add(Component component, double d, double d1) {
        component.setLocation(GMath.round(d), GMath.round(d1));
        this.add(component);
    }

    public final void add(Component component, GPoint gpoint) {
        this.add(component, gpoint.getX(), gpoint.getY());
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        this.conditionalRepaint();
    }

    @Override
    public int getElementCount() {
        return this.contents.getElementCount();
    }

    @Override
    public GObject getElement(int i) {
        return this.contents.getElement(i);
    }

    @Override
    public GObject getElementAt(double d, double d1) {
        return this.contents.getElementAt(d, d1, false);
    }

    @Override
    public final GObject getElementAt(GPoint gpoint) {
        return this.getElementAt(gpoint.getX(), gpoint.getY());
    }

    public Iterator<GObject> iterator() {
        return new GIterator(this, 0);
    }

    public Iterator<GObject> iterator(int i) {
        return new GIterator(this, i);
    }

    @Override
    public void paint(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
        }
        super.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.contents.mapPaint(g);
        super.paintComponent(g);
    }

    public void setAutoRepaintFlag(boolean flag) {
        this.autoRepaint = flag;
    }

    public boolean getAutoRepaintFlag() {
        return this.autoRepaint;
    }

    public void setNativeArcFlag(boolean flag) {
        this.nativeArcFlag = flag;
    }

    public boolean getNativeArcFlag() {
        return this.nativeArcFlag;
    }

    protected void sendToFront(GObject gobject) {
        this.contents.sendToFront(gobject);
        this.conditionalRepaint();
    }

    protected void sendToBack(GObject gobject) {
        this.contents.sendToBack(gobject);
        this.conditionalRepaint();
    }

    protected void sendForward(GObject gobject) {
        this.contents.sendForward(gobject);
        this.conditionalRepaint();
    }

    protected void sendBackward(GObject gobject) {
        this.contents.sendBackward(gobject);
        this.conditionalRepaint();
    }

    protected void dispatchMouseEvent(MouseEvent mouseevent) {
        int i;
        GObject gobject = this.contents.getElementAt(mouseevent.getX(), mouseevent.getY(), true);
        GMouseEvent gmouseevent = null;
        if (gobject != this.lastObject) {
            if (this.lastObject != null) {
                gmouseevent = new GMouseEvent(this.lastObject, 505, mouseevent);
                this.lastObject.fireMouseListeners(gmouseevent);
            }
            if (gobject != null) {
                gmouseevent = new GMouseEvent(gobject, 504, mouseevent);
                gobject.fireMouseListeners(gmouseevent);
            }
        }
        this.lastObject = gobject;
        if (this.dragObject != null) {
            gobject = this.dragObject;
        }
        if (gobject != null && (i = mouseevent.getID()) != 505 && i != 504 && (i != 506 || this.dragObject != null)) {
            if (i == 501) {
                this.dragObject = gobject;
            } else if (i == 502) {
                this.dragObject = null;
            }
            gmouseevent = new GMouseEvent(gobject, i, mouseevent);
            gobject.fireMouseListeners(gmouseevent);
        }
        if (gmouseevent != null && gmouseevent.isConsumed()) {
            mouseevent.consume();
        }
    }

    protected void conditionalRepaint() {
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    protected void updateEnabledList() {
        this.contents.updateEnabledList();
    }

    static MouseEvent createMouseEvent(Object obj, int i, MouseEvent mouseevent) {
        return new GMouseEvent(obj, i, mouseevent);
    }
}

