/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Stack;

public class TokenScanner {
    public static final int EOF = -1;
    public static final int SEPARATOR = 0;
    public static final int WORD = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    public static final int OPERATOR = 4;
    private static final int INITIAL_STATE = 0;
    private static final int BEFORE_DECIMAL_POINT = 1;
    private static final int AFTER_DECIMAL_POINT = 2;
    private static final int STARTING_EXPONENT = 3;
    private static final int FOUND_EXPONENT_SIGN = 4;
    private static final int SCANNING_EXPONENT = 5;
    private static final int FINAL_STATE = 6;
    private Reader input = null;
    private String wordChars = "";
    private String savedChars;
    private Stack<String> savedTokens = new Stack();
    private ArrayList<String> operators = new ArrayList();
    private int cpos = 0;
    private boolean ignoreWhitespaceFlag = false;
    private boolean ignoreCommentsFlag = false;
    private boolean scanNumbersFlag = false;
    private boolean scanStringsFlag = false;

    public TokenScanner() {
    }

    public TokenScanner(String string) {
        this();
        this.setInput(string);
    }

    public TokenScanner(Reader reader) {
        this();
        this.setInput(reader);
    }

    public void setInput(String string) {
        this.setInput(new StringReader(string));
    }

    public void setInput(Reader reader) {
        this.savedChars = "";
        this.savedTokens.clear();
        this.cpos = 0;
        this.input = reader;
    }

    public boolean hasMoreTokens() {
        String string = this.nextToken();
        this.saveToken(string);
        return !string.isEmpty();
    }

    public String nextToken() {
        if (!this.savedTokens.isEmpty()) {
            return this.savedTokens.pop();
        }
        return this.scanToken();
    }

    public void saveToken(String string) {
        this.savedTokens.push(string);
    }

    public int getPosition() {
        if (this.savedTokens.isEmpty()) {
            return this.cpos;
        }
        return this.cpos - this.savedTokens.peek().length();
    }

    public void ignoreWhitespace() {
        this.ignoreWhitespaceFlag = true;
    }

    public void ignoreComments() {
        this.ignoreCommentsFlag = true;
    }

    public void scanNumbers() {
        this.scanNumbersFlag = true;
    }

    public void scanStrings() {
        this.scanStringsFlag = true;
    }

    public void addWordCharacters(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (this.wordChars.indexOf(c) != -1) continue;
            this.wordChars = this.wordChars + c;
        }
    }

    public boolean isWordCharacter(int n) {
        if (n == -1) {
            return false;
        }
        return Character.isLetterOrDigit(n) || this.wordChars.indexOf((char)n) >= 0;
    }

    public void addOperator(String string) {
        this.operators.add(string);
    }

    public void verifyToken(String string) {
        String string2 = this.nextToken();
        if (string2.equals(string)) {
            return;
        }
        String string3 = "Found " + string2 + " when expecting " + string;
        throw new ErrorException(string3);
    }

    public int getTokenType(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        char c = string.charAt(0);
        if (Character.isWhitespace(c)) {
            return 0;
        }
        if (Character.isDigit(c)) {
            return 2;
        }
        if (c == '\"' || c == '\'') {
            return 3;
        }
        if (this.isWordCharacter(c)) {
            return 1;
        }
        return 4;
    }

    public int getChar() {
        try {
            ++this.cpos;
            if (!this.savedChars.isEmpty()) {
                char c = this.savedChars.charAt(0);
                this.savedChars = this.savedChars.substring(1);
                return c;
            }
            return this.input.read();
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public void ungetChar(int n) {
        --this.cpos;
        if (this.input instanceof PushbackReader) {
            try {
                ((PushbackReader)this.input).unread(n);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (n >= 0) {
            this.savedChars = (char)n + this.savedChars;
        }
    }

    public String getStringValue(String string) {
        String string2 = "";
        int n = 0;
        int n2 = string.length();
        if (n2 > 1 && (string.charAt(0) == '\"' || string.charAt(0) == '\'')) {
            n = 1;
            --n2;
        }
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (Character.isDigit(c = string.charAt(++i)) || c == 'x') {
                    int n3 = 8;
                    int n4 = 3;
                    if (c == 'x') {
                        n3 = 16;
                        n4 = 2;
                        ++i;
                    }
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = Math.min(n2, i + n4);
                    while (i < n7) {
                        c = string.charAt(i);
                        if (Character.isDigit(c)) {
                            n6 = c - 48;
                        } else if (n3 == 16 && c >= 'A' && c <= 'F') {
                            n6 = c - 65 + 10;
                        } else {
                            if (n3 != 16 || c < 97 || c > 102) break;
                            n6 = c - 97 + 10;
                        }
                        n5 = n3 * n5 + n6;
                        ++i;
                    }
                    c = (char)n5;
                    --i;
                } else {
                    switch (c) {
                        case 'a': {
                            c = '\u0007';
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'v': {
                            c = '\u000b';
                            break;
                        }
                        case '\"': {
                            c = '\"';
                            break;
                        }
                        case '\'': {
                            c = '\'';
                            break;
                        }
                        case '\\': {
                            c = '\\';
                        }
                    }
                }
            }
            string2 = string2 + c;
        }
        return string2;
    }

    private String scanToken() {
        int n = this.scanChar();
        if (n == -1) {
            return "";
        }
        if (this.scanNumbersFlag && Character.isDigit(n)) {
            this.ungetChar(n);
            return this.scanNumber();
        }
        if (this.isWordCharacter(n)) {
            this.ungetChar(n);
            return this.scanWord();
        }
        if (this.scanStringsFlag && (n == 34 || n == 39)) {
            this.ungetChar(n);
            return this.scanString();
        }
        String string = "" + (char)n;
        while (this.isOperatorPrefix(string) && (n = this.getChar()) != -1) {
            string = string + (char)n;
        }
        while (string.length() > 1 && !this.isOperator(string)) {
            this.ungetChar(string.charAt(string.length() - 1));
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private int scanChar() {
        int n;
        block5: {
            int n2;
            boolean bl = false;
            boolean bl2 = false;
            while (true) {
                n = this.getChar();
                if (this.ignoreWhitespaceFlag && Character.isWhitespace(n) && !this.isOperator(Character.toString((char)n))) continue;
                if (bl) {
                    n2 = this.getChar();
                    if (n == 42 && n2 == 47) {
                        bl = false;
                        continue;
                    }
                    this.ungetChar(n2);
                    continue;
                }
                if (bl2) {
                    if (n != 10 && n != 13) continue;
                    bl2 = false;
                    continue;
                }
                if (!this.ignoreCommentsFlag || n != 47) break block5;
                n2 = this.getChar();
                if (n2 == 42) {
                    bl = true;
                    continue;
                }
                if (n2 != 47) break;
                bl2 = true;
            }
            this.ungetChar(n2);
        }
        return n;
    }

    private String scanWord() {
        String string = "";
        int n = this.getChar();
        while (this.isWordCharacter(n)) {
            string = string + (char)n;
            n = this.getChar();
        }
        this.ungetChar(n);
        return string;
    }

    private String scanNumber() {
        String string = "";
        int n = 0;
        int n2 = 69;
        block8: while (n != 6) {
            int n3 = this.getChar();
            switch (n) {
                case 0: {
                    if (n3 == 48) {
                        int n4 = this.getChar();
                        if (n4 == 120 || n4 == 88) {
                            string = "0x";
                            continue block8;
                        }
                        this.ungetChar(n4);
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    if (n3 == 46) {
                        n = 2;
                        break;
                    }
                    if (n3 == 69 || n3 == 101) {
                        n = 3;
                        break;
                    }
                    if (Character.isDigit(n3)) break;
                    n = 6;
                    break;
                }
                case 2: {
                    if (n3 == 69 || n3 == 101) {
                        n2 = n3;
                        n = 3;
                        break;
                    }
                    if (Character.isDigit(n3)) break;
                    n = 6;
                    break;
                }
                case 3: {
                    if (n3 == 43 || n3 == 45) {
                        n = 4;
                        break;
                    }
                    if (Character.isDigit(n3)) {
                        n = 5;
                        break;
                    }
                    n = 6;
                    break;
                }
                case 4: {
                    if (Character.isDigit(n3)) {
                        n = 5;
                        break;
                    }
                    this.ungetChar(n3);
                    n3 = n2;
                    n = 6;
                    break;
                }
                case 5: {
                    if (Character.isDigit(n3)) break;
                    n = 6;
                }
            }
            if (n == 6) {
                this.ungetChar(n3);
                break;
            }
            string = string + (char)n3;
        }
        return string;
    }

    private String scanString() {
        char c;
        char c2 = (char)this.getChar();
        String string = "" + c2;
        char c3 = '\u0000';
        while ((c = this.getChar()) != '\uffffffff' && (c != c2 || c3 == '\\')) {
            string = string + (char)c;
            c3 = c;
        }
        return string + c2;
    }

    private boolean isOperator(String string) {
        for (int i = 0; i < this.operators.size(); ++i) {
            if (!this.operators.get(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isOperatorPrefix(String string) {
        for (int i = 0; i < this.operators.size(); ++i) {
            if (!this.operators.get(i).startsWith(string)) continue;
            return true;
        }
        return false;
    }
}

