/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.collections;

import java.awt.Color;
import java.util.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vertex
extends Observable
implements Comparable<Vertex>,
Cloneable {
    public static final double MAX_COST = Double.POSITIVE_INFINITY;
    private String name;
    private int number;
    private Color color;
    private Vertex previous;
    private boolean visited;
    private double cost;
    public Object extraData;

    public Vertex(String name) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        this.name = name;
        this.clear();
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean clearExtraData) {
        this.previous = null;
        this.visited = false;
        this.cost = Double.POSITIVE_INFINITY;
        this.number = -1;
        this.color = null;
        if (clearExtraData) {
            this.extraData = null;
        }
    }

    public Vertex clone() {
        try {
            Vertex copy = (Vertex)super.clone();
            copy.clear();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Color color() {
        return this.color;
    }

    @Override
    public int compareTo(Vertex o) {
        return this.name.compareTo(o.name);
    }

    public double cost() {
        return this.cost;
    }

    public boolean equals(Object o) {
        if (o instanceof Vertex) {
            Vertex other = (Vertex)o;
            return this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String name() {
        return this.name;
    }

    @Override
    public void notifyObservers() {
        this.setChanged();
        super.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    public int number() {
        return this.number;
    }

    public Vertex previous() {
        return this.previous;
    }

    public void setColor(Color color) {
        this.color = color;
        this.notifyObservers((Object)Event.COLOR_CHANGED);
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setPrevious(Vertex previous) {
        this.previous = previous;
    }

    public void setVisited() {
        this.setVisited(true);
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public boolean visited() {
        return this.visited;
    }

    public String toString() {
        String result = "(" + this.name;
        if (this.number != -1) {
            result = String.valueOf(result) + ",#" + this.number;
        }
        if (this.previous != null) {
            result = String.valueOf(result) + ",previous=" + this.previous.name;
        }
        if (this.cost < Double.POSITIVE_INFINITY) {
            result = String.valueOf(result) + ",cost=" + this.cost;
        }
        if (this.visited) {
            result = String.valueOf(result) + ",visited";
        }
        if (this.extraData != null) {
            result = String.valueOf(result) + ",extraData=" + this.extraData;
        }
        return String.valueOf(result) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        COLOR_CHANGED;

    }
}

