/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class Console
implements Runnable {
    static JTextPane displayPane;
    BufferedReader reader;
    static int pseudoCaretPos;
    static int cursorPos;
    static String currentLine;
    static Queue<String> inputQueue;

    static {
        currentLine = "";
    }

    Console(JTextPane displayPane, PipedOutputStream pos) {
        Console.displayPane = displayPane;
        try {
            PipedInputStream pis = new PipedInputStream(pos);
            this.reader = new BufferedReader(new InputStreamReader(pis));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        SimpleAttributeSet boldBlack = new SimpleAttributeSet();
        StyleConstants.setForeground(boldBlack, Color.BLACK);
        StyleConstants.setBold(boldBlack, true);
        try {
            int c;
            while ((c = this.reader.read()) != -1) {
                Document doc = displayPane.getDocument();
                try {
                    doc.insertString(doc.getLength(), Character.toString((char)c), null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                displayPane.setCaretPosition(displayPane.getDocument().getLength());
                pseudoCaretPos = displayPane.getCaretPosition();
            }
            System.err.println("there was an error in run...");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void redirectOutput(JTextPane displayPane) {
        displayPane.addKeyListener(new MyKeyListener());
        inputQueue = new LinkedList<String>();
        Console.redirectOut(displayPane);
        Console.redirectErr(displayPane);
    }

    public static void redirectOut(JTextPane displayPane) {
        PipedOutputStream pos = new PipedOutputStream();
        System.setOut(new PrintStream(pos, true));
        Console console = new Console(displayPane, pos);
        new Thread(console).start();
    }

    public static void redirectErr(JTextPane displayPane) {
        PipedOutputStream pos = new PipedOutputStream();
        System.setErr(new PrintStream(pos, true));
        Console console = new Console(displayPane, pos);
        new Thread(console).start();
    }

    static String getLine() {
        while (inputQueue.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return inputQueue.remove();
    }

    static void pasteText(String text) {
        SimpleAttributeSet boldBlue = new SimpleAttributeSet();
        StyleConstants.setForeground(boldBlue, Color.BLUE);
        StyleConstants.setBold(boldBlue, true);
        if (displayPane.getCaretPosition() == displayPane.getDocument().getLength()) {
            try {
                displayPane.getDocument().insertString(pseudoCaretPos, text, boldBlue);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            currentLine = String.valueOf(currentLine) + text;
            pseudoCaretPos = displayPane.getDocument().getLength();
            cursorPos = currentLine.length();
            displayPane.setCaretPosition(pseudoCaretPos);
        }
    }

    static class MyKeyListener
    extends KeyAdapter {
        MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            String os_name = System.getProperty("os.name");
            if (keyCode == 86) {
                if (os_name.contains("Mac") && evt.isMetaDown() || !os_name.contains("Mac") && evt.isControlDown()) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    try {
                        String pasteboardText = (String)clipboard.getData(DataFlavor.stringFlavor);
                        Console.pasteText(pasteboardText);
                    }
                    catch (UnsupportedFlavorException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    evt.consume();
                }
            } else if (keyCode == 67 || keyCode == 88) {
                if (os_name.contains("Mac") && evt.isMetaDown() || !os_name.contains("Mac") && evt.isControlDown()) {
                    String textToCopy = displayPane.getSelectedText();
                    StringSelection stringSelection = new StringSelection(textToCopy);
                    Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clpbrd.setContents(stringSelection, null);
                }
                if (keyCode == 88) {
                    int sStart = displayPane.getSelectionStart();
                    int sEnd = displayPane.getSelectionEnd();
                    int docEnd = displayPane.getDocument().getLength();
                    int currentLineStart = docEnd - currentLine.length();
                    if (currentLineStart > sStart) {
                        sStart = currentLineStart;
                    }
                    if (sEnd > sStart) {
                        displayPane.select(sStart, sEnd);
                        displayPane.replaceSelection("");
                        int newStart = currentLine.length() - (docEnd - sStart);
                        currentLine = String.valueOf(currentLine.substring(0, newStart)) + currentLine.substring(currentLine.length() - (docEnd - sEnd), currentLine.length());
                        pseudoCaretPos = displayPane.getDocument().getLength() - currentLine.length();
                        cursorPos = newStart;
                    }
                    evt.consume();
                }
            }
            if (keyCode == 37) {
                if (cursorPos > 0) {
                    --cursorPos;
                    --pseudoCaretPos;
                } else {
                    evt.consume();
                }
            } else if (keyCode == 39) {
                if (cursorPos < currentLine.length()) {
                    ++cursorPos;
                    ++pseudoCaretPos;
                } else {
                    evt.consume();
                }
            } else {
                evt.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            SimpleAttributeSet boldBlue = new SimpleAttributeSet();
            StyleConstants.setForeground(boldBlue, Color.BLUE);
            StyleConstants.setBold(boldBlue, true);
            char c = evt.getKeyChar();
            if (c == '\n') {
                Document doc = displayPane.getDocument();
                try {
                    doc.insertString(doc.getLength(), "\n", boldBlue);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                inputQueue.add(currentLine);
                currentLine = "";
                cursorPos = 0;
                pseudoCaretPos = displayPane.getDocument().getLength();
                displayPane.setCaretPosition(pseudoCaretPos);
            } else {
                int initialPosition = pseudoCaretPos - cursorPos;
                int realCaretPos = displayPane.getCaretPosition();
                if (realCaretPos < initialPosition) {
                    displayPane.setCaretPosition(displayPane.getDocument().getLength());
                    pseudoCaretPos = realCaretPos;
                    cursorPos = currentLine.length();
                } else {
                    cursorPos = realCaretPos - initialPosition;
                    pseudoCaretPos = realCaretPos;
                }
                if (c == '\b') {
                    if (cursorPos > 0) {
                        currentLine = String.valueOf(currentLine.substring(0, cursorPos - 1)) + currentLine.substring(cursorPos, currentLine.length());
                        displayPane.select(pseudoCaretPos - 1, pseudoCaretPos);
                        displayPane.replaceSelection("");
                        --cursorPos;
                        --pseudoCaretPos;
                    }
                } else if (c >= ' ') {
                    currentLine = currentLine.length() == 0 ? String.valueOf(currentLine) + c : String.valueOf(currentLine.substring(0, cursorPos)) + c + currentLine.substring(cursorPos, currentLine.length());
                    ++cursorPos;
                    if (displayPane.getCaretPosition() != pseudoCaretPos) {
                        displayPane.setCaretPosition(displayPane.getDocument().getLength());
                        pseudoCaretPos = displayPane.getCaretPosition();
                        cursorPos = currentLine.length();
                    }
                    Document doc = displayPane.getDocument();
                    try {
                        doc.insertString(pseudoCaretPos, Character.toString(c), boldBlue);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    displayPane.setCaretPosition(++pseudoCaretPos);
                    evt.consume();
                }
            }
        }
    }
}

