/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;

public class MainWindow {
    private JTextPane textPane;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private static final int MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public MainWindow() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.textPane = new JTextPane(){

            @Override
            public void paste() {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Clipboard clipboard = toolkit.getSystemClipboard();
                try {
                    String pasteboardText = (String)clipboard.getData(DataFlavor.stringFlavor);
                    Console.pasteText(pasteboardText);
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        JFrame frame = new JFrame("Console");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(scrollPane);
        frame.setSize(750, 520);
        JMenuBar menubar = new JMenuBar();
        JMenu editMenu = new JMenu("Edit");
        DefaultEditorKit.CutAction cutAction = new DefaultEditorKit.CutAction();
        cutAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, MASK));
        this.cutMenuItem = new JMenuItem(cutAction);
        this.cutMenuItem.setText("Cut");
        DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
        copyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, MASK));
        this.copyMenuItem = new JMenuItem(copyAction);
        this.copyMenuItem.setText("Copy");
        DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
        pasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, MASK));
        this.pasteMenuItem = new JMenuItem(pasteAction);
        this.pasteMenuItem.setText("Paste");
        editMenu.add(this.cutMenuItem);
        editMenu.add(this.copyMenuItem);
        editMenu.add(this.pasteMenuItem);
        menubar.add(editMenu);
        frame.setJMenuBar(menubar);
        frame.setVisible(true);
        Console.redirectOutput(this.textPane);
    }
}

