/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.graphics.GObject;
import acm.gui.TableLayout;
import acm.io.ConsoleModel;
import acm.io.IOConsole;
import acm.io.IODialog;
import acm.io.IOModel;
import acm.io.StandardConsoleModel;
import acm.program.AppletStarter;
import acm.program.CommandLineProgram;
import acm.program.ProgramAppletStub;
import acm.program.ProgramContentPaneLayout;
import acm.program.ProgramFrame;
import acm.program.ProgramMenuBar;
import acm.program.ProgramStartupListener;
import acm.program.ProgramWindowListener;
import acm.util.Animator;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Program
extends JApplet
implements IOModel,
Runnable,
ActionListener,
ComponentListener,
KeyListener,
MouseListener,
MouseMotionListener {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    private static final int DEFAULT_X = 16;
    private static final int DEFAULT_Y = 40;
    private static final int DEFAULT_WIDTH = 754;
    private static final int DEFAULT_HEIGHT = 492;
    private static final int PRINT_MARGIN = 36;
    private ArrayList<Object> finalizers;
    private HashMap<String, String> parameterTable;
    private JFrame programFrame;
    private AppletStub appletStub;
    private String myTitle;
    private ProgramMenuBar myMenuBar;
    private Component northBorder;
    private Component southBorder;
    private Component eastBorder;
    private Component westBorder;
    private JPanel northPanel;
    private JPanel southPanel;
    private JPanel eastPanel;
    private JPanel westPanel;
    private JPanel centerPanel;
    private IOConsole myConsole;
    private IODialog myDialog;
    private IOModel inputModel;
    private IOModel outputModel;
    private Object startupObject;
    private AppletStarter appletStarter;
    private Rectangle programBounds;
    private boolean started;
    private boolean shown;
    private boolean initFinished;
    private boolean appletMode;
    private boolean exitOnClose = true;
    private boolean animatedMode = false;
    private int animationDelay = 20;
    private Timer animationTimer = null;
    private double pauseScaleFactor = 1.0;
    private boolean pauseTickFlag = false;
    private boolean kill = false;
    protected Set<GObject> invisibleObjects = new HashSet<GObject>();

    protected Program() {
        JTFTools.registerApplet(this);
        this.appletMode = this.checkForAppletMode();
        this.shown = false;
        this.parameterTable = null;
        this.finalizers = new ArrayList();
        this.myTitle = this.getClass().getName();
        this.myTitle = this.myTitle.substring(this.myTitle.lastIndexOf(".") + 1);
        this.appletStub = new ProgramAppletStub(this);
        this.setAppletStub(this.appletStub);
        this.initContentPane(this.getContentPane());
        this.setVisible(false);
        this.setConsole(this.createConsole());
        this.myDialog = this.createDialogIO();
        this.myDialog.setAssociatedConsole(this.myConsole);
        this.myMenuBar = this.createMenuBar();
        this.myConsole.setMenuBar(this.myMenuBar);
        this.addComponentListener(this);
    }

    public void animation() {
    }

    public boolean isAnimated() {
        return this.animatedMode;
    }

    public synchronized void setAnimated(boolean value) {
        this.animatedMode = value;
        if (this.animatedMode) {
            if (this.animationTimer == null) {
                this.animationTimer = new Timer(this.animationDelay, new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        Program.this.animation();
                    }
                });
                this.animationTimer.start();
            }
        } else if (this.animationTimer != null) {
            this.animationTimer.stop();
            this.animationTimer = null;
        }
    }

    public synchronized void setAnimationDelay(int delayMS) {
        if (delayMS <= 0) {
            throw new IllegalArgumentException("invalid delay of " + delayMS + "; must be a positive integer");
        }
        if (delayMS != this.animationDelay) {
            this.animationDelay = delayMS;
            if (this.animationTimer != null) {
                this.animationTimer.setDelay(delayMS);
            }
        }
    }

    public int getAnimationDelay() {
        return this.animationDelay;
    }

    public void setFramesPerSecond(int fps) {
        if (fps < 0) {
            throw new IllegalArgumentException("invalid FPS of " + fps + "; must be non-negative");
        }
        if (fps == 0) {
            this.stopAnimation();
        } else {
            this.setAnimationDelay(Math.max(1, 1000 / fps));
        }
    }

    public void startAnimation() {
        this.setAnimated(true);
    }

    public void stopAnimation() {
        this.setAnimated(false);
    }

    @Override
    public void run() {
    }

    @Override
    public void init() {
    }

    @Override
    public void print(String value) {
        this.getOutputModel().print(value);
    }

    @Override
    public final void print(boolean x) {
        this.print("" + x);
    }

    @Override
    public final void print(char x) {
        this.print("" + x);
    }

    @Override
    public final void print(double x) {
        this.print("" + x);
    }

    @Override
    public final void print(float x) {
        this.print("" + x);
    }

    @Override
    public final void print(int x) {
        this.print("" + x);
    }

    @Override
    public final void print(long x) {
        this.print("" + x);
    }

    @Override
    public final void print(Object x) {
        this.print("" + x);
    }

    @Override
    public void println() {
        this.getOutputModel().println();
    }

    @Override
    public void println(String value) {
        this.getOutputModel().println(value);
    }

    public void printf(String format, Object ... args) {
        this.println(String.format(format, args));
    }

    public void println(String value, Color color) {
        Color old = this.getOutputColor();
        this.setOutputColor(color);
        this.getOutputModel().println(value);
        this.setOutputColor(old);
    }

    public void print(String value, Color color) {
        Color old = this.getOutputColor();
        this.setOutputColor(color);
        this.getOutputModel().print(value);
        this.setOutputColor(old);
    }

    public Color getOutputColor() {
        ConsoleModel cmodel;
        IOModel model = this.getOutputModel();
        if (model instanceof IOConsole && (cmodel = ((IOConsole)model).getConsoleModel()) instanceof StandardConsoleModel) {
            StandardConsoleModel smodel = (StandardConsoleModel)cmodel;
            return smodel.getOutputColor();
        }
        return Color.BLACK;
    }

    public void setOutputColor(Color color) {
        ConsoleModel cmodel;
        IOModel model = this.getOutputModel();
        if (model instanceof IOConsole && (cmodel = ((IOConsole)model).getConsoleModel()) instanceof StandardConsoleModel) {
            StandardConsoleModel smodel = (StandardConsoleModel)cmodel;
            smodel.setOutputColor(color);
        }
    }

    public void println(int value, Color color) {
        this.println(String.valueOf(value), color);
    }

    public void println(double value, Color color) {
        this.println(String.valueOf(value), color);
    }

    public void println(boolean value, Color color) {
        this.println(String.valueOf(value), color);
    }

    public void println(char value, Color color) {
        this.println(String.valueOf(value), color);
    }

    public void println(Object value, Color color) {
        this.println(String.valueOf(value), color);
    }

    public void print(int value, Color color) {
        this.print(String.valueOf(value), color);
    }

    public void print(double value, Color color) {
        this.print(String.valueOf(value), color);
    }

    public void print(boolean value, Color color) {
        this.print(String.valueOf(value), color);
    }

    public void print(char value, Color color) {
        this.print(String.valueOf(value), color);
    }

    public void print(Object value, Color color) {
        this.print(String.valueOf(value), color);
    }

    @Override
    public final void println(boolean x) {
        this.println("" + x);
    }

    @Override
    public final void println(char x) {
        this.println("" + x);
    }

    @Override
    public final void println(double x) {
        this.println("" + x);
    }

    @Override
    public final void println(float x) {
        this.println("" + x);
    }

    @Override
    public final void println(int x) {
        this.println("" + x);
    }

    @Override
    public final void println(long x) {
        this.println("" + x);
    }

    @Override
    public final void println(Object x) {
        this.println("" + x);
    }

    @Override
    public void showErrorMessage(String msg) {
        this.getOutputModel().showErrorMessage(msg);
    }

    @Override
    public final String readLine() {
        return this.readLine(null);
    }

    @Override
    public String readLine(String prompt) {
        return this.getInputModel().readLine(prompt);
    }

    @Override
    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public final int readInt(int low, int high) {
        return this.readInt(null, low, high);
    }

    @Override
    public final int readInt(String prompt) {
        return this.readInt(prompt, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public int readInt(String prompt, int low, int high) {
        return this.getInputModel().readInt(prompt, low, high);
    }

    @Override
    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public final double readDouble(double low, double high) {
        return this.readDouble(null, low, high);
    }

    @Override
    public final double readDouble(String prompt) {
        return this.readDouble(prompt, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public double readDouble(String prompt, double low, double high) {
        return this.getInputModel().readDouble(prompt, low, high);
    }

    @Override
    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    @Override
    public final boolean readBoolean(String prompt) {
        return this.readBoolean(prompt, "true", "false");
    }

    @Override
    public boolean readBoolean(String prompt, String trueLabel, String falseLabel) {
        return this.getInputModel().readBoolean(prompt, trueLabel, falseLabel);
    }

    public boolean isAppletMode() {
        return this.appletMode;
    }

    public void setConsole(IOConsole console) {
        this.myConsole = console;
    }

    public IOConsole getConsole() {
        return this.myConsole;
    }

    public void setDialog(IODialog dialog) {
        this.myDialog = dialog;
    }

    public IODialog getDialog() {
        return this.myDialog;
    }

    public JFrame getJFrame() {
        return this.programFrame;
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    public void setInputModel(IOModel io) {
        this.inputModel = io;
    }

    public void setOutputModel(IOModel io) {
        this.outputModel = io;
    }

    public IOModel getInputModel() {
        return this.inputModel == null ? this.myConsole : this.inputModel;
    }

    public IOModel getOutputModel() {
        return this.outputModel == null ? this.myConsole : this.outputModel;
    }

    public BufferedReader getReader() {
        return this.getConsole().getReader();
    }

    public PrintWriter getWriter() {
        return this.getConsole().getWriter();
    }

    public JPanel getRegionPanel(String region) {
        if (region.equals(NORTH)) {
            return this.northPanel;
        }
        if (region.equals(SOUTH)) {
            return this.southPanel;
        }
        if (region.equals(WEST)) {
            return this.westPanel;
        }
        if (region.equals(EAST)) {
            return this.eastPanel;
        }
        if (region.equals(CENTER)) {
            return this.centerPanel;
        }
        throw new ErrorException("getRegionPanel: Illegal region " + region);
    }

    public void add(Component comp, String region, Object constraints) {
        if (region.equals(NORTH)) {
            this.northPanel.add(comp, constraints);
        } else if (region.equals(SOUTH)) {
            this.southPanel.add(comp, constraints);
        } else if (region.equals(WEST)) {
            this.westPanel.add(comp, constraints);
        } else if (region.equals(EAST)) {
            this.eastPanel.add(comp, constraints);
        } else if (region.equals(CENTER)) {
            this.centerPanel.add(comp, constraints);
        } else {
            throw new ErrorException("add: Illegal region " + region);
        }
    }

    public void addActionListeners() {
        this.addActionListeners(this);
    }

    public void addActionListeners(ActionListener listener) {
        this.addActionListeners(this.getContentPane(), listener);
    }

    public void setSize(double width, double height) {
        super.setSize((int)width, (int)height);
    }

    public void setTitle(String title) {
        this.myTitle = title;
        if (this.programFrame != null) {
            this.programFrame.setTitle(title);
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setResizable(boolean resizable) {
        if (this.programFrame != null) {
            this.programFrame.setResizable(resizable);
        }
    }

    public ProgramMenuBar getMenuBar() {
        return this.myMenuBar;
    }

    protected void checkCompilerFlags() {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void start(String[] args) {
        if (this.parameterTable == null) {
            this.parameterTable = Program.createParameterTable(args);
        }
        if (this.getParent() == null) {
            this.initApplicationFrame();
        }
        this.validate();
        this.checkCompilerFlags();
        this.setVisible(true);
        if (this.programFrame != null) {
            this.programFrame.validate();
            int nComponents = this.centerPanel.getComponentCount();
            nComponents += this.northPanel.getComponentCount();
            nComponents += this.southPanel.getComponentCount();
            nComponents += this.westPanel.getComponentCount();
            if ((nComponents += this.eastPanel.getComponentCount()) > 0) {
                this.programFrame.setVisible(true);
                this.shown = true;
            }
            this.circumventFrameSizeBug(this.programFrame, this.programBounds.getSize());
        }
        this.started = true;
        this.init();
        if (this.programFrame != null && this.myMenuBar != null) {
            this.myMenuBar.install(this.programFrame);
        }
        this.validate();
        this.startRun();
    }

    public void exit() {
        if (this.exitOnClose) {
            int nFinalizers = this.finalizers.size();
            int i = 0;
            while (i < nFinalizers) {
                Object obj = this.finalizers.get(i);
                try {
                    Class<?> c = obj.getClass();
                    Method exit = c.getMethod("exit", new Class[0]);
                    exit.invoke(obj, new Object[0]);
                }
                catch (Exception ex) {
                    throw new ErrorException(ex);
                }
                ++i;
            }
            JTFTools.terminateAppletThreads(this);
            if (!this.appletMode) {
                System.exit(0);
            }
        }
    }

    public void addExitHook(Object obj) {
        this.finalizers.add(obj);
    }

    public void setParameter(String name, String value) {
        if (this.parameterTable == null) {
            this.parameterTable = new HashMap();
        }
        this.parameterTable.put(name.toLowerCase(), value);
    }

    public Thread getMainThread() {
        return this.appletStarter == null ? null : this.appletStarter.getMainThread();
    }

    public void pause(double milliseconds) {
        this.checkKill();
        if (this.pauseScaleFactor == 0.0) {
            while (this.pauseScaleFactor == 0.0) {
                if (this.pauseTickFlag) {
                    this.pauseTickFlag = false;
                    break;
                }
                JTFTools.pause(250.0);
            }
        } else {
            JTFTools.pause((int)(milliseconds * this.pauseScaleFactor));
        }
    }

    public void killMe() {
        this.kill = true;
    }

    public void setInvisible(GObject obj, boolean invisible) {
        if (invisible) {
            this.invisibleObjects.add(obj);
        } else {
            this.invisibleObjects.remove(obj);
        }
    }

    public void setPauseScaleFactor(double factor) {
        double oldFactor = this.pauseScaleFactor;
        this.pauseScaleFactor = factor;
        if (oldFactor == 0.0) {
            // empty if block
        }
    }

    public void checkKill() {
        if (this.kill) {
            throw new Error("exit -1");
        }
    }

    public void pauseTick() {
        this.pauseTickFlag = true;
    }

    public Dimension getCentralRegionSize() {
        if (this.centerPanel == null) {
            return super.getSize();
        }
        if (this.initFinished) {
            return this.centerPanel.getSize();
        }
        Dimension size = this.programFrame == null ? super.getSize() : this.programFrame.getSize();
        Insets insets = this.programFrame == null ? super.getInsets() : this.programFrame.getInsets();
        size.width -= this.westPanel.getPreferredSize().width + this.eastPanel.getPreferredSize().width;
        size.width -= insets.left + insets.right;
        size.height -= this.northPanel.getPreferredSize().height + this.southPanel.getPreferredSize().height;
        size.height -= insets.top + insets.bottom;
        return size;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected JFrame createProgramFrame() {
        return new ProgramFrame(this.getTitle());
    }

    protected IOConsole createConsole() {
        return IOConsole.SYSTEM_CONSOLE;
    }

    protected IODialog createDialogIO() {
        return new IODialog(this.getContentPane());
    }

    protected ProgramMenuBar createMenuBar() {
        return new ProgramMenuBar(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.computeProgramBounds().getSize();
    }

    @Override
    public int getWidth() {
        String caller = this.getMyCaller();
        if (caller.startsWith("java.") || caller.startsWith("javax.")) {
            return super.getWidth();
        }
        return this.getCentralRegionSize().width;
    }

    @Override
    public int getHeight() {
        String caller = this.getMyCaller();
        if (caller.startsWith("java.") || caller.startsWith("javax.")) {
            return super.getHeight();
        }
        return this.getCentralRegionSize().height;
    }

    @Override
    public String getParameter(String name) {
        String value = null;
        if (this.parameterTable != null) {
            value = this.parameterTable.get(name.toLowerCase());
        }
        if (value != null) {
            return value;
        }
        return super.getParameter(name);
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.setLayout(layout);
        } else {
            super.setLayout(layout);
        }
    }

    @Override
    public LayoutManager getLayout() {
        if (this.isRootPaneCheckingEnabled()) {
            return this.centerPanel.getLayout();
        }
        return super.getLayout();
    }

    @Override
    public void setBackground(Color color) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.setBackground(color);
        }
        super.setBackground(color);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.isRootPaneCheckingEnabled()) {
            if (constraints == null) {
                this.centerPanel.add(comp, index);
            } else if (constraints.equals(NORTH)) {
                this.northPanel.add(comp, index);
            } else if (constraints.equals(SOUTH)) {
                this.southPanel.add(comp, index);
            } else if (constraints.equals(WEST)) {
                this.westPanel.add(comp, index);
            } else if (constraints.equals(EAST)) {
                this.eastPanel.add(comp, index);
            } else if (constraints.equals(CENTER)) {
                this.centerPanel.add(comp, index);
            } else {
                this.centerPanel.add(comp, constraints, index);
            }
            if (!this.shown && this.programFrame != null) {
                this.programFrame.setVisible(true);
                this.shown = true;
            }
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    @Override
    public void remove(int index) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.remove(index);
        } else {
            super.remove(index);
        }
    }

    @Override
    public void remove(Component comp) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.remove(comp);
        } else {
            super.remove(comp);
        }
        this.invisibleObjects.remove(comp);
    }

    @Override
    public void removeAll() {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.removeAll();
        } else {
            super.removeAll();
        }
    }

    @Override
    public void validate() {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().validate();
        }
        super.validate();
    }

    @Override
    public void repaint() {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().repaint();
        }
        super.repaint();
    }

    @Override
    public final void start() {
        boolean bl = this.appletMode = this.getParent() != null;
        if (this.appletMode) {
            if (!this.started) {
                this.started = true;
                this.validate();
                this.setVisible(true);
                this.appletStarter = new AppletStarter(this);
                this.appletStarter.start();
            }
        } else {
            this.start(null);
        }
    }

    @Override
    public void destroy() {
        Animator.shutdown(this);
        if (this.appletStarter != null) {
            this.appletStarter.stop();
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> ht = Program.createParameterTable(args);
        JTFTools.setDebugOptions(ht.get("debug"));
        String className = ht.get("code");
        if (className == null) {
            className = JTFTools.getMainClass();
        }
        Class<?> mainClass = null;
        Program program = null;
        if (className != null) {
            if (className.endsWith(".class")) {
                className = className.substring(0, className.length() - 6);
            }
            className = className.replace('/', '.');
            CommandLineProgram.checkIfHeadless(className);
            try {
                mainClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (mainClass != null) {
            try {
                Object obj = mainClass.newInstance();
                if (obj instanceof Program) {
                    program = (Program)obj;
                    program.setStartupObject(null);
                } else {
                    className = ht.get("program");
                    if (className == null) {
                        throw new ErrorException("Main class does not specify a program");
                    }
                    program = (Program)Class.forName(className).newInstance();
                    program.setStartupObject(obj);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (program == null) {
            throw new ErrorException("Cannot determine the main class.");
        }
        program.setParameterTable(ht);
        program.start();
    }

    public boolean menuAction(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Quit")) {
            this.exit();
        } else {
            if (cmd.equals("Print") || cmd.equals("Print...")) {
                Frame frame = JTFTools.getEnclosingFrame(this);
                if (frame == null) {
                    return true;
                }
                PrintJob pj = frame.getToolkit().getPrintJob(frame, this.myTitle, null);
                if (pj == null) {
                    return true;
                }
                Graphics pg = pj.getGraphics();
                pg.translate(36, 36);
                frame.printAll(pg);
                pj.end();
                return true;
            }
            if (cmd.equals("Export Applet") || cmd.equals("Submit Project")) {
                JTFTools.executeExportAction(this, cmd);
                return true;
            }
        }
        return this.getConsole().menuAction(e);
    }

    protected Component getBorder(String side) {
        if (side.equals(NORTH)) {
            return this.northBorder;
        }
        if (side.equals(SOUTH)) {
            return this.southBorder;
        }
        if (side.equals(EAST)) {
            return this.eastBorder;
        }
        if (side.equals(WEST)) {
            return this.westBorder;
        }
        throw new ErrorException("Illegal border specification - " + side);
    }

    protected String[] getArgumentArray() {
        if (this.parameterTable == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.parameterTable.get("ARGS"), "\t", false);
        String[] args = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            args[i] = tokenizer.nextToken();
            ++i;
        }
        return args;
    }

    protected boolean isStarted() {
        IOConsole console = this.getConsole();
        if (console == null) {
            return false;
        }
        if (console.getParent() == null) {
            return true;
        }
        Dimension size = console.getSize();
        return console.isShowing() && size.width != 0 && size.height != 0;
    }

    protected void startHook() {
    }

    protected void endHook() {
    }

    protected void setAppletStub(AppletStub stub) {
        this.appletStub = stub;
        this.setStub(stub);
    }

    protected AppletStub getAppletStub() {
        return this.appletStub;
    }

    protected void setParameterTable(HashMap<String, String> ht) {
        this.parameterTable = ht;
    }

    protected HashMap<String, String> getParameterTable() {
        return this.parameterTable;
    }

    protected void setStartupObject(Object obj) {
        this.startupObject = obj;
    }

    protected Object getStartupObject() {
        return this.startupObject;
    }

    protected void startRun() {
        ProgramStartupListener listener = new ProgramStartupListener();
        JRootPane root = this.getRootPane();
        if (root.isShowing()) {
            root.addComponentListener(listener);
            ((Component)root).validate();
            listener.waitForStartup(this);
            ((Component)root).update(((Component)root).getGraphics());
        }
        root.setCursor(Cursor.getDefaultCursor());
        this.initFinished = true;
        this.startHook();
        this.runHook();
        this.endHook();
        if (!root.isShowing() && !this.getContentPane().isShowing()) {
            this.exit();
        }
    }

    protected void runHook() {
        this.run();
    }

    protected static HashMap<String, String> createParameterTable(String[] args) {
        if (args == null) {
            return null;
        }
        HashMap<String, String> ht = new HashMap<String, String>();
        String newArgs = "";
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            int equals = arg.indexOf(61);
            if (equals > 0) {
                String name = arg.substring(0, equals).toLowerCase();
                String value = arg.substring(equals + 1);
                ht.put(name, value);
            } else {
                if (newArgs.length() > 0) {
                    newArgs = String.valueOf(newArgs) + '\t';
                }
                newArgs = String.valueOf(newArgs) + arg;
            }
            ++i;
        }
        ht.put("ARGS", newArgs);
        return ht;
    }

    private void initContentPane(Container contentPane) {
        contentPane.setLayout(new ProgramContentPaneLayout(this));
        this.northPanel = new JPanel();
        this.southPanel = new JPanel();
        this.eastPanel = new JPanel();
        this.westPanel = new JPanel();
        this.centerPanel = new JPanel();
        this.northPanel.setLayout(new TableLayout(1, 0, 5, 5));
        this.southPanel.setLayout(new TableLayout(1, 0, 5, 5));
        this.westPanel.setLayout(new TableLayout(0, 1, 5, 5));
        this.eastPanel.setLayout(new TableLayout(0, 1, 5, 5));
        this.centerPanel.setLayout(new GridLayout(1, 0));
        contentPane.add((Component)this.northPanel, NORTH);
        contentPane.add((Component)this.southPanel, SOUTH);
        contentPane.add((Component)this.eastPanel, EAST);
        contentPane.add((Component)this.westPanel, WEST);
        contentPane.add((Component)this.centerPanel, CENTER);
    }

    private void addActionListeners(Component comp, ActionListener listener) {
        if (this.isButton(comp)) {
            if (!this.hasActionListener(comp)) {
                try {
                    Class[] types = new Class[]{Class.forName("java.awt.event.ActionListener")};
                    Object[] args = new Object[]{listener};
                    Method addActionListener = comp.getClass().getMethod("addActionListener", types);
                    addActionListener.invoke((Object)comp, args);
                }
                catch (Exception ex) {
                    throw new ErrorException(ex);
                }
            }
        } else if (comp instanceof Container) {
            Container container = (Container)comp;
            int nComponents = container.getComponentCount();
            int i = 0;
            while (i < nComponents) {
                this.addActionListeners(container.getComponent(i), listener);
                ++i;
            }
        }
    }

    private boolean isButton(Component comp) {
        return comp instanceof Button || comp instanceof JButton;
    }

    private boolean hasActionListener(Component comp) {
        try {
            Method getActionListeners = comp.getClass().getMethod("getActionListeners", new Class[0]);
            ActionListener[] listeners = (ActionListener[])getActionListeners.invoke((Object)comp, new Object[0]);
            return listeners.length > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void initApplicationFrame() {
        this.programFrame = this.createProgramFrame();
        ((ProgramAppletStub)this.appletStub).setFrame(this.programFrame);
        Container contents = this.programFrame.getContentPane();
        contents.setLayout(new BorderLayout());
        contents.add((Component)this.getContentPane(), CENTER);
        this.programFrame.addWindowListener(new ProgramWindowListener(this));
        this.programBounds = this.computeProgramBounds();
        Insets insets = this.programFrame.getInsets();
        int frameWidth = this.programBounds.width + insets.left + insets.right;
        int frameHeight = this.programBounds.height + insets.top + insets.bottom;
        this.programFrame.setBounds(this.programBounds.x, this.programBounds.y, frameWidth, frameHeight);
    }

    private int decodeSizeParameter(String name, int value, int max) {
        String str = this.getParameter(name);
        if (str == null) {
            try {
                Class<?> mainClass = this.getClass();
                Field field = mainClass.getField("APPLICATION_" + name);
                Object obj = field.get(null);
                if (obj instanceof Integer) {
                    return (Integer)obj;
                }
                if (!(obj instanceof String)) {
                    return value;
                }
                str = (String)obj;
            }
            catch (Exception ex) {
                return value;
            }
        }
        if (str.equals("*")) {
            str = "100%";
        }
        if (str.endsWith("%")) {
            int percent = Integer.parseInt(str.substring(0, str.length() - 1));
            return (int)Math.round((double)percent / 100.0 * (double)max);
        }
        return Integer.parseInt(str);
    }

    private Rectangle computeProgramBounds() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int width = this.decodeSizeParameter("WIDTH", 754, size.width);
        int height = this.decodeSizeParameter("HEIGHT", 492, size.height);
        int x = this.decodeSizeParameter("X", width >= size.width ? 0 : 16, size.width);
        int y = this.decodeSizeParameter("Y", height >= size.height ? 0 : 40, size.height);
        return new Rectangle(x, y, width, height);
    }

    private boolean checkForAppletMode() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int i = 1;
        while (i < stack.length) {
            if (stack[i].getMethodName().indexOf("Applet") >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getMyCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        return String.valueOf(stack[2].getClassName()) + "." + stack[2].getMethodName();
    }

    private void circumventFrameSizeBug(Frame frame, Dimension size) {
        Container contentPane = this.getContentPane();
        Dimension actualSize = contentPane.getSize();
        if (size.equals(actualSize) || actualSize.width == 0 || actualSize.height == 0) {
            return;
        }
        Dimension frameSize = frame.getSize();
        frameSize.width += size.width - actualSize.width;
        frameSize.height += size.height - actualSize.height;
        frame.setSize(frameSize.width, frameSize.height);
        frame.validate();
    }
}

