#!/usr/bin/perl -w
# This script runs the Main program to generate the expected-output-*.txt files.

use strict;

# detect OS to use proper class path separator;
my $os = $^O;
my $cpsep = ":";
my $foldersep = "/";
if ($os =~ m/Win/i) {
    $cpsep = ";";
    #$foldersep = "\\";
}

# folder where input-* and expected-output-* should be stored
my $folder = "../output";

my @TESTS = (
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8"
);

systemp("rm *.huf *-out.*");

foreach my $test (@TESTS) {
    systemp("java -cp 'bin${cpsep}lib${foldersep}acm.jar' -Dscanner.echo=1 -Drandom.seed=42 CommandLineMain < ${folder}${foldersep}input-$test.txt > ${folder}${foldersep}expected-output-$test.txt");
}

# print "Remember that Scanner input is not echoed!\n";
# print "You must manually add it to the expected output files.\n";


# Runs the given system command but also echoes it.
sub systemp {
    my $command = shift;
    print("$command\n");
    system($command);
}
