/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.collections;

import stanford.cs106.collections.Vertex;

public class Edge
implements Cloneable {
    public static final int DEFAULT_WEIGHT = 1;
    private Vertex start;
    private Vertex end;
    private double weight;
    private boolean weighted;
    public Object extraData;

    public Edge(Vertex start, Vertex end) {
        this(start, end, 1.0, false);
    }

    public Edge(Vertex start, Vertex end, double weight) {
        this(start, end, weight, true);
    }

    private Edge(Vertex start, Vertex end, double weight, boolean weighted) {
        if (start == null) {
            throw new NullPointerException("null start vertex");
        }
        if (end == null) {
            throw new NullPointerException("null end vertex");
        }
        this.start = start;
        this.end = end;
        this.setWeight(weight);
        this.weighted = weighted;
    }

    public Edge clone() {
        try {
            Edge copy = (Edge)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean contains(Vertex vertex) {
        if (vertex == null) {
            throw new NullPointerException("null vertex");
        }
        return this.start.equals(vertex) || this.end.equals(vertex);
    }

    public double cost() {
        return this.weight();
    }

    public Vertex end() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (o instanceof Edge) {
            Edge other = (Edge)o;
            return this.start.equals(other.start) && this.end.equals(other.end) && this.weight == other.weight;
        }
        return false;
    }

    public Vertex finish() {
        return this.end;
    }

    public int hashCode() {
        return 13 * this.start.hashCode() + 37 * this.end.hashCode();
    }

    public void setWeight(double weight) {
        if (weight < 0.0) {
            throw new IllegalArgumentException("negative edge weight: " + weight);
        }
        this.weight = weight;
    }

    public Vertex start() {
        return this.start;
    }

    public double weight() {
        return this.weight;
    }

    public String toString() {
        return "(" + this.start.name() + "," + this.end.name() + (this.weighted ? ",weight=" + this.weight : "") + (this.extraData != null ? ",extraData=" + this.extraData : "") + ")";
    }
}

