/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import stanford.cs106.gui.GuiUtils;
import stanford.cs106.util.OperatingSystem;
import stanford.spl.JavaBackEnd;
import stanford.spl.SPLWindowSettings;

public class AutograderInput
extends Observable
implements ActionListener {
    private static final int MIN_WIDTH = 75;
    private static AutograderInput instance;
    private JFrame frame;
    private JPanel currentCategory;
    private Map<String, JComponent> components;
    private Set<JLabel> allLabels = new LinkedHashSet<JLabel>();
    private KeyListener keyListener;

    public static synchronized AutograderInput getInstance(JavaBackEnd javaBackEnd) {
        if (instance == null) {
            instance = new AutograderInput(javaBackEnd);
        }
        return instance;
    }

    public AutograderInput(JavaBackEnd javaBackEnd) {
        this.frame = new JFrame();
        this.frame.setTitle("Autograder Input Panel");
        this.frame.setVisible(false);
        this.keyListener = javaBackEnd.getConsoleKeyListener();
        this.frame.addKeyListener(this.keyListener);
        Box box = Box.createVerticalBox();
        this.frame.setContentPane(box);
        this.components = new HashMap<String, JComponent>();
        SPLWindowSettings.loadWindowLocation(this.frame);
        SPLWindowSettings.saveWindowLocation(this.frame);
    }

    public void addBlank() {
        this.addButton("");
    }

    public void addButton(String text) {
        this.addButton(text, text);
    }

    public void addButton(String text, String input) {
        if (this.currentCategory == null) {
            FlowLayout layout = new FlowLayout(0, 0, 2);
            this.currentCategory = new JPanel(layout);
            this.frame.add(this.currentCategory);
        }
        if (text.length() == 0) {
            this.currentCategory.add(new JPanel());
        } else {
            if (!input.endsWith("\n")) {
                input = String.valueOf(input) + "\n";
            }
            JButton button = new JButton(text);
            button.addKeyListener(this.keyListener);
            if (OperatingSystem.get() == OperatingSystem.MAC) {
                button.setBorder(BorderFactory.createLineBorder(Color.GRAY));
                GuiUtils.pad(button, 20, 10);
            }
            GuiUtils.shrinkFont(button);
            button.setActionCommand(input);
            button.addActionListener(this);
            this.currentCategory.add(button);
            this.components.put(text, button);
        }
        this.checkVisibility();
    }

    public void addCategory(String name) {
        this.currentCategory = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(String.valueOf(name) + (name != null && !name.isEmpty() ? ": " : ""));
        label.setFont(label.getFont().deriveFont(1));
        label.setHorizontalAlignment(4);
        GuiUtils.shrinkFont(label);
        this.allLabels.add(label);
        this.currentCategory.add(label);
        this.frame.add(this.currentCategory);
        this.components.put(name, this.currentCategory);
        this.checkVisibility();
    }

    public void actionPerformed(ActionEvent event) {
        this.setChanged();
        this.notifyObservers(event.getActionCommand());
    }

    public boolean isEmpty() {
        return this.buttonCount() == 0;
    }

    public int buttonCount() {
        return this.frame.getComponentCount();
    }

    public int getColumns() {
        return 1;
    }

    public void removeButton(String text) {
        JComponent button = this.components.get(text);
        if (button != null) {
            this.components.remove(text);
            this.frame.remove(button);
            this.checkVisibility();
        }
    }

    public void removeCategory(String name) {
        JComponent category = this.components.get(name);
        if (category != null) {
            this.components.remove(name);
            this.frame.remove(category);
            this.checkVisibility();
        }
    }

    public void setColumns(int columns) {
        this.checkVisibility();
    }

    public void setVisible(boolean value) {
        this.frame.setVisible(value);
    }

    private void checkVisibility() {
        this.frame.validate();
        this.frame.pack();
        int maxLabelWidth = 0;
        for (JLabel label : this.allLabels) {
            maxLabelWidth = Math.max(maxLabelWidth, label.getPreferredSize().width);
        }
        for (JLabel label : this.allLabels) {
            Dimension size = label.getPreferredSize();
            label.setPreferredSize(new Dimension(maxLabelWidth, size.height));
        }
        this.frame.validate();
        this.frame.pack();
        if (this.frame.getWidth() < 75) {
            this.frame.setSize(75, this.frame.getHeight());
        }
        this.frame.setVisible(!this.isEmpty());
    }
}

