/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvas;
import acm.graphics.GContainer;
import acm.graphics.GIterator;
import acm.graphics.GObject;
import acm.graphics.GObjectList;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.util.ErrorException;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCompound
extends GObject
implements GContainer {
    private boolean complete = false;
    private GObjectList contents = new GObjectList(this);
    private transient GObject lastObject;
    private transient GObject dragObject;
    static final long serialVersionUID = 21L;

    @Override
    public void add(GObject gobject) {
        if (this.complete) {
            throw new ErrorException("You can't add objects to a GCompound that has been marked as complete.");
        }
        this.contents.add(gobject);
        this.repaint();
    }

    @Override
    public final void add(GObject gobject, double d, double d1) {
        gobject.setLocation(d, d1);
        this.add(gobject);
    }

    @Override
    public final void add(GObject gobject, GPoint gpoint) {
        this.add(gobject, gpoint.getX(), gpoint.getY());
    }

    @Override
    public void remove(GObject gobject) {
        if (this.complete) {
            throw new ErrorException("You can't remove objects from a GCompound that has been marked as complete.");
        }
        this.contents.remove(gobject);
        this.repaint();
    }

    @Override
    public void removeAll() {
        if (this.complete) {
            throw new ErrorException("You can't remove objects from a GCompound that has been marked as complete.");
        }
        this.contents.removeAll();
        this.repaint();
    }

    @Override
    public int getElementCount() {
        return this.contents.getElementCount();
    }

    @Override
    public GObject getElement(int i) {
        return this.contents.getElement(i);
    }

    @Override
    public GObject getElementAt(double d, double d1) {
        return this.contents.getElementAt(d, d1, false);
    }

    @Override
    public final GObject getElementAt(GPoint gpoint) {
        return this.getElementAt(gpoint.getX(), gpoint.getY());
    }

    public Iterator<?> iterator() {
        return new GIterator(this, 0);
    }

    public Iterator<?> iterator(int i) {
        return new GIterator(this, i);
    }

    @Override
    public Object clone() {
        GCompound gcompound = (GCompound)super.clone();
        gcompound.contents = new GObjectList(gcompound, this.contents);
        int i = 0;
        while (i < this.contents.getElementCount()) {
            System.err.println("original = " + this.contents.getElement(i).hashCode());
            System.err.println("clone    = " + gcompound.contents.getElement(i).hashCode());
            ++i;
        }
        return gcompound;
    }

    @Override
    protected void paint2d(Graphics2D graphics2d) {
        this.contents.mapPaint(graphics2d);
    }

    @Override
    public GRectangle getBounds() {
        GRectangle grectangle = this.contents.getBounds();
        Shape obj = new Rectangle2D.Double(grectangle.getX(), grectangle.getY(), grectangle.getWidth(), grectangle.getHeight());
        AffineTransform affinetransform = this.getMatrix();
        if (affinetransform != null) {
            obj = affinetransform.createTransformedShape(obj);
        }
        Rectangle rectangle = ((Shape)obj).getBounds();
        return new GRectangle(this.getX() + rectangle.getX(), this.getY() + rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    @Override
    public boolean contains(double d, double d1) {
        d -= this.getX();
        d1 -= this.getY();
        AffineTransform affinetransform = this.getMatrix();
        if (affinetransform != null) {
            try {
                affinetransform = affinetransform.createInverse();
                Point2D.Double double1 = new Point2D.Double(d, d1);
                affinetransform.transform(double1, double1);
                d = double1.getX();
                d1 = double1.getY();
            }
            catch (NoninvertibleTransformException noninvertibletransformexception) {
                throw new ErrorException(noninvertibletransformexception);
            }
        }
        return this.contents.contains(d, d1);
    }

    public final GPoint getCanvasPoint(GPoint gpoint) {
        return this.getCanvasPoint(gpoint.getX(), gpoint.getY());
    }

    public GPoint getCanvasPoint(double d, double d1) {
        GContainer obj = this;
        while (obj instanceof GCompound) {
            GCompound gcompound = obj;
            d += gcompound.getX();
            d1 += gcompound.getY();
            obj = gcompound.getParent();
        }
        return new GPoint(d, d1);
    }

    public final GPoint getLocalPoint(GPoint gpoint) {
        return this.getLocalPoint(gpoint.getX(), gpoint.getY());
    }

    public GPoint getLocalPoint(double d, double d1) {
        GContainer obj = this;
        while (obj instanceof GCompound) {
            GCompound gcompound = obj;
            d -= gcompound.getX();
            d1 -= gcompound.getY();
            obj = gcompound.getParent();
        }
        return new GPoint(d, d1);
    }

    public void markAsComplete() {
        this.complete = true;
    }

    protected void sendToFront(GObject gobject) {
        this.contents.sendToFront(gobject);
        this.repaint();
    }

    protected void sendToBack(GObject gobject) {
        this.contents.sendToBack(gobject);
        this.repaint();
    }

    protected void sendForward(GObject gobject) {
        this.contents.sendForward(gobject);
        this.repaint();
    }

    protected void sendBackward(GObject gobject) {
        this.contents.sendBackward(gobject);
        this.repaint();
    }

    @Override
    protected void fireMouseListeners(MouseEvent mouseevent) {
        int i;
        if (super.areMouseListenersEnabled()) {
            super.fireMouseListeners(mouseevent);
            return;
        }
        GPoint gpoint = new GPoint((double)mouseevent.getX() - this.getX(), (double)mouseevent.getY() - this.getY());
        GObject gobject = this.getElementAt(gpoint);
        MouseEvent mouseevent1 = null;
        if (gobject != this.lastObject) {
            if (this.lastObject != null) {
                mouseevent1 = GCanvas.createMouseEvent(this.lastObject, 505, mouseevent);
                this.lastObject.fireMouseListeners(mouseevent1);
            }
            if (gobject != null) {
                mouseevent1 = GCanvas.createMouseEvent(gobject, 504, mouseevent);
                gobject.fireMouseListeners(mouseevent1);
            }
        }
        this.lastObject = gobject;
        if (this.dragObject != null) {
            gobject = this.dragObject;
        }
        if (gobject != null && (i = mouseevent.getID()) != 505 && i != 504) {
            if (i == 501) {
                this.dragObject = gobject;
            } else if (i == 502) {
                this.dragObject = null;
            }
            mouseevent1 = GCanvas.createMouseEvent(gobject, i, mouseevent);
            gobject.fireMouseListeners(mouseevent1);
        }
        if (mouseevent1 != null && mouseevent1.isConsumed()) {
            mouseevent.consume();
        }
    }

    @Override
    protected boolean areMouseListenersEnabled() {
        if (super.areMouseListenersEnabled()) {
            return true;
        }
        return this.contents.areMouseListenersEnabled();
    }
}

