/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import stanford.spl.GInteractor;
import stanford.spl.JavaBackEnd;
import stanford.spl.SplPipeDecoder;

public class GTable
extends GInteractor
implements ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    public static final int TABLE_EVENT = 1024;
    public static final int TABLE_UPDATED = 1025;
    public static final int TABLE_SELECTED = 1026;
    private JTable table;
    private JTableModel model;
    private JavaBackEnd jbe;
    private Set<Integer> eventTypesEnabled = new HashSet<Integer>(Arrays.asList(1026, 1025));
    private boolean eventsEnabled = true;
    private boolean editable = true;
    private int previouslySelectedRow = -1;
    private int previouslySelectedColumn = -1;

    public GTable(int numRows, int numCols) {
        super(new JTable(numRows, numCols));
        this.checkDimensions("constructor", numRows, numCols);
        this.table = (JTable)super.getInteractor();
        this.model = new JTableModel(numRows, numCols);
        this.table.setModel(this.model);
        this.table.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(4);
        this.model = (JTableModel)this.table.getModel();
        this.model.addTableModelListener(this);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this);
    }

    public synchronized void clear() {
        this.eventsEnabled = false;
        int row = 0;
        while (row < this.table.getRowCount()) {
            int col = 0;
            while (col < this.table.getColumnCount()) {
                this.table.setValueAt("", row, col);
                ++col;
            }
            ++row;
        }
        this.previouslySelectedRow = -1;
        this.previouslySelectedColumn = -1;
        this.eventsEnabled = true;
    }

    public synchronized String get(int row, int column) {
        this.checkIndex("get", row, column);
        Object value = this.table.getValueAt(row, column);
        if (value == null) {
            value = "";
        }
        return String.valueOf(value);
    }

    public synchronized int getColumnWidth(int col) {
        this.checkIndex("getColumnWidth", 0, col);
        TableColumn column = this.table.getColumnModel().getColumn(col);
        return column.getWidth();
    }

    public synchronized Font getFont() {
        return this.table.getFont();
    }

    public synchronized int getSelectedColumn() {
        return this.table.getSelectedColumn();
    }

    public synchronized int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public boolean inBounds(int row, int column) {
        return row >= 0 && row < this.numRows() && column >= 0 && column < this.numCols();
    }

    public synchronized boolean isEventEnabled(int type) {
        return this.eventTypesEnabled.contains(type);
    }

    public int numCols() {
        return this.table.getColumnCount();
    }

    public int numRows() {
        return this.table.getRowCount();
    }

    public synchronized void resize(int numRows, int numCols) {
        this.checkDimensions("resize", numRows, numCols);
        this.eventsEnabled = false;
        this.model.setRowCount(numRows);
        this.model.setColumnCount(numCols);
        this.eventsEnabled = true;
        this.previouslySelectedRow = -1;
        this.previouslySelectedColumn = -1;
    }

    public synchronized void select(int row, int column) {
        if (this.inBounds(row, column)) {
            this.table.setRowSelectionInterval(row, row);
            this.table.setColumnSelectionInterval(column, column);
        } else {
            this.previouslySelectedRow = -1;
            this.previouslySelectedColumn = -1;
            this.table.clearSelection();
        }
    }

    public synchronized void set(int row, int column, String value) {
        this.checkIndex("set", row, column);
        if (value == null) {
            value = "";
        }
        this.eventsEnabled = false;
        this.table.setValueAt(value, row, column);
        this.eventsEnabled = true;
    }

    public synchronized void setColumnWidth(int col, int width) {
        this.checkIndex("setColumnWidth", 0, col);
        if (width < 0) {
            throw new IllegalArgumentException("GTable.setColumnWidth: width cannot be negative");
        }
        TableColumn column = this.table.getColumnModel().getColumn(col);
        column.setPreferredWidth(width);
        column.setWidth(width);
        this.table.validate();
        this.table.repaint();
    }

    public synchronized void setColumnHeadersVisible(boolean visible) {
        if (visible) {
            Object[] columnHeaders = new Object[this.numCols()];
            int i = 0;
            while (i < this.numCols()) {
                columnHeaders[i] = String.valueOf(i);
                ++i;
            }
            this.model.setColumnIdentifiers(columnHeaders);
        } else {
            Object[] columnHeaders = new Object[this.numCols()];
            int i = 0;
            while (i < this.numCols()) {
                columnHeaders[i] = "";
                ++i;
            }
            this.model.setColumnIdentifiers(columnHeaders);
        }
    }

    public synchronized void setEditable(boolean editable) {
        this.editable = editable;
    }

    public synchronized void setEventEnabled(int eventType, boolean enabled) {
        if (eventType != 1026 && eventType != 1025) {
            throw new IllegalArgumentException("GTable.setEventEnabled: bad event type: " + eventType);
        }
        if (enabled) {
            this.eventTypesEnabled.add(eventType);
        } else {
            this.eventTypesEnabled.remove(eventType);
        }
    }

    public synchronized void setFont(Font font) {
        this.table.setFont(font);
    }

    public synchronized void setHorizontalAlignment(int alignment) {
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.table.getCellRenderer(0, 0);
        renderer.setHorizontalAlignment(alignment);
        this.table.validate();
        this.table.repaint();
    }

    public synchronized void setJavaBackEnd(JavaBackEnd jbe) {
        this.jbe = jbe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableChanged(TableModelEvent e) {
        GTable gTable = this;
        synchronized (gTable) {
            if (this.eventsEnabled && this.eventTypesEnabled.contains(1025)) {
                int row = e.getFirstRow();
                int col = e.getColumn();
                String value = this.get(row, col);
                this.jbe.acknowledgeEvent("event:tableUpdated(\"%s\", %d, %d, %d, \"%s\")", this.jbe.getSourceId(this.getInteractor()), (long)this.jbe.getEventTime(), row, col, SplPipeDecoder.encode(value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int row = this.table.getSelectedRow();
            int col = this.table.getSelectedColumn();
            if (this.eventsEnabled && (row != this.previouslySelectedRow || col != this.previouslySelectedColumn)) {
                GTable gTable = this;
                synchronized (gTable) {
                    if (this.eventsEnabled && this.eventTypesEnabled.contains(1026)) {
                        this.jbe.acknowledgeEvent("event:tableSelected(\"%s\", %d, %d, %d)", this.jbe.getSourceId(this.getInteractor()), (long)this.jbe.getEventTime(), row, col);
                    }
                }
                this.previouslySelectedRow = row;
                this.previouslySelectedColumn = col;
            }
        }
    }

    private void checkDimensions(String member, int numRows, int numCols) {
        if (numRows < 0 || numCols < 0) {
            throw new IllegalArgumentException("GTable." + member + ": dimensions " + numRows + "x" + numCols + " cannot be negative");
        }
    }

    private void checkIndex(String member, int row, int column) {
        if (!this.inBounds(row, column)) {
            throw new IndexOutOfBoundsException("GTable." + member + ": index R" + row + "C" + column + " is out of bounds of 0,0 - " + (this.numRows() - 1) + "," + (this.numCols() - 1));
        }
    }

    private class JTableModel
    extends DefaultTableModel {
        public JTableModel(int rows, int cols) {
            super(rows, cols);
        }

        public boolean isCellEditable(int row, int col) {
            return GTable.this.editable;
        }
    }
}

