/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.util.TokenScanner;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stanford.spl.JBECommand;
import stanford.spl.JavaBackEnd;
import stanford.spl.SplPipeDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Regex_matchCountWithLines
extends JBECommand {
    private static final boolean DEBUG = false;

    private Map<Integer, Integer> getLineNumberMap(String s) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int linenum = 1;
        int i = 0;
        int len = s.length();
        while (i < len) {
            char ch = s.charAt(i);
            map.put(i, linenum);
            if (ch == '\n') {
                ++linenum;
            }
            ++i;
        }
        return map;
    }

    @Override
    public void execute(TokenScanner paramTokenScanner, JavaBackEnd paramJavaBackEnd) {
        paramTokenScanner.verifyToken("(");
        String s = SplPipeDecoder.readAndDecode(paramTokenScanner);
        paramTokenScanner.verifyToken(",");
        String regexp = SplPipeDecoder.readAndDecode(paramTokenScanner);
        paramTokenScanner.verifyToken(")");
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(s);
        Map<Integer, Integer> lineNumberMap = this.getLineNumberMap(s);
        StringBuilder linesStr = new StringBuilder();
        int count = 0;
        while (matcher.find()) {
            ++count;
            int startIndex = matcher.start();
            if (!lineNumberMap.containsKey(startIndex)) continue;
            int lineNum = lineNumberMap.get(startIndex);
            if (linesStr.length() > 0) {
                linesStr.append(",");
            }
            linesStr.append(lineNum);
        }
        SplPipeDecoder.writeResult(String.valueOf(count) + ":" + linesStr);
    }
}

