/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.gui.TableConstraints;
import acm.util.ErrorException;
import acm.util.OptionTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JScrollBar;
import javax.swing.JSlider;

public class TableLayout
implements LayoutManager2,
Serializable {
    public static final int NONE = 0;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int BOTH = 1;
    public static final int CENTER = 10;
    public static final int LEFT = 11;
    public static final int RIGHT = 12;
    public static final int TOP = 13;
    public static final int BOTTOM = 14;
    public static final int FILL = 1;
    private static final int LAYOUT_CONTAINER_MODE = 0;
    private static final int MINIMUM_LAYOUT_SIZE_MODE = 1;
    private static final int PREFERRED_LAYOUT_SIZE_MODE = 2;
    private static final int MINIMUM_SCROLLBAR_SIZE = 100;
    private transient Container targetContainer;
    private HashMap<Component, GridBagConstraints> constraintTable;
    private HashMap<Component, TableConstraints> layoutTable;
    private HashMap<String, Object> propertyTable;
    private boolean useStrictGridBagModel;
    private int nRows;
    private int nColumns;
    private int horizontalAlignment;
    private int verticalAlignment;
    private int defaultFill;
    private int hGap;
    private int vGap;
    static final long serialVersionUID = 1L;

    public TableLayout() {
        this(0, 0);
    }

    public TableLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public TableLayout(int n, int n2, int n3, int n4) {
        this.nRows = n;
        this.nColumns = n2;
        this.hGap = n3;
        this.vGap = n4;
        this.horizontalAlignment = 10;
        this.verticalAlignment = 10;
        this.defaultFill = 1;
        this.constraintTable = new HashMap();
        this.propertyTable = new HashMap();
        this.layoutTable = null;
    }

    public void setColumnCount(int n) {
        this.nColumns = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getColumnCount() {
        return this.nColumns;
    }

    public void setRowCount(int n) {
        this.nRows = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getRowCount() {
        return this.nRows;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setDefaultFill(int n) {
        this.defaultFill = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getDefaultFill() {
        return this.defaultFill;
    }

    public void setHgap(int n) {
        this.hGap = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getHgap() {
        return this.hGap;
    }

    public void setVgap(int n) {
        this.vGap = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getVgap() {
        return this.vGap;
    }

    public void setStrictGridBagModel(boolean bl) {
        this.useStrictGridBagModel = bl;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public boolean isStrictGridBagModel() {
        return this.useStrictGridBagModel;
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.constraintTable.put(component, (GridBagConstraints)gridBagConstraints.clone());
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public void setConstraints(Component component, String string) {
        this.setConstraints(component, new TableConstraints(string));
    }

    public TableConstraints getConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
        return gridBagConstraints == null ? null : new TableConstraints(gridBagConstraints);
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void removeLayoutComponent(Component component) {
        this.constraintTable.remove(component);
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        if (container.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        return this.processLayout(container, 2);
    }

    public Dimension minimumLayoutSize(Container container) {
        if (container.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        return this.processLayout(container, 1);
    }

    public void layoutContainer(Container container) {
        this.targetContainer = container;
        this.processLayout(container, 0);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            object = new TableConstraints("");
            ((TableConstraints)object).fill = this.defaultFill;
        } else if (object instanceof String) {
            OptionTable optionTable = new OptionTable(((String)object).toLowerCase(), TableConstraints.LEGAL_KEYS);
            object = new TableConstraints(optionTable.getMap());
            if (!optionTable.isSpecified("fill")) {
                ((TableConstraints)object).fill = optionTable.isSpecified("anchor") ? 0 : this.defaultFill;
            }
        } else if (!(object instanceof GridBagConstraints)) {
            throw new ErrorException("TableLayout: Illegal constraints");
        }
        this.constraintTable.put(component, (GridBagConstraints)object);
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public synchronized void invalidateLayout(Container container) {
        this.layoutTable = null;
        for (String string : this.propertyTable.keySet()) {
            if (string.startsWith("width") && !string.equals("width")) {
                this.propertyTable.put(string, new Integer(0));
            }
            if (string.startsWith("height") && !string.equals("height")) {
                this.propertyTable.put(string, new Integer(0));
            }
            if (string.startsWith("weightx") && !string.equals("weightx")) {
                this.propertyTable.put(string, new Double(0.0));
            }
            if (!string.startsWith("weighty") || string.equals("weighty")) continue;
            this.propertyTable.put(string, new Double(0.0));
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string + "[rows=" + this.nRows + ",columns=" + this.nColumns;
        if (this.hGap != 0) {
            string = string + ",hgap=" + this.hGap;
        }
        if (this.vGap != 0) {
            string = string + ",vgap=" + this.vGap;
        }
        string = string + "]";
        return string;
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        return this.constraintTable.get(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableConstraints lookupConstraints(Component component, Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            if (this.layoutTable == null) {
                this.computeLayoutTable(container);
            }
            return this.layoutTable.get(component);
        }
    }

    private Dimension getMinimumComponentSize(Component component) {
        if (this.isScrollbar(component)) {
            return this.getMinimumScrollbarSize(component);
        }
        return component.getMinimumSize();
    }

    private Dimension getPreferredComponentSize(Component component) {
        if (this.isScrollbar(component)) {
            return this.getMinimumScrollbarSize(component);
        }
        return component.getPreferredSize();
    }

    private boolean isScrollbar(Component component) {
        return component instanceof Scrollbar || component instanceof JScrollBar || component instanceof JSlider;
    }

    private Dimension getMinimumScrollbarSize(Component component) {
        Dimension dimension = component.getMinimumSize();
        try {
            Class<?> clazz = component.getClass();
            Method method = clazz.getMethod("getOrientation", new Class[0]);
            int n = (Integer)method.invoke((Object)component, new Object[0]);
            if (n == 0) {
                dimension.width = Math.max(dimension.width, 100);
            } else {
                dimension.height = Math.max(dimension.height, 100);
            }
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension processLayout(Container container, int n) {
        Object object = container.getTreeLock();
        synchronized (object) {
            return this.lockedProcessLayout(container, n);
        }
    }

    private synchronized Dimension lockedProcessLayout(Container container, int n) {
        int n2;
        Object object;
        int n3;
        Dimension dimension = null;
        if (this.layoutTable == null) {
            this.computeLayoutTable(container);
        }
        int n4 = this.getIntProperty("nRows");
        int n5 = this.getIntProperty("nColumns");
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n5];
        int n6 = container.getComponentCount();
        for (n3 = 0; n3 < n6; ++n3) {
            Component component = container.getComponent(n3);
            object = this.layoutTable.get(component);
            int n7 = object.gridx;
            int n8 = object.gridy;
            int n9 = this.getIntProperty("width" + n7);
            int n10 = this.getIntProperty("height" + n8);
            if (n9 == 0) {
                n9 = n == 1 || this.useStrictGridBagModel ? this.getMinimumComponentSize((Component)component).width : this.getPreferredComponentSize((Component)component).width;
                n9 += 2 * object.ipadx + object.insets.left + object.insets.right;
            }
            if (n10 == 0) {
                n10 = n == 1 || this.useStrictGridBagModel ? this.getMinimumComponentSize((Component)component).height : this.getPreferredComponentSize((Component)component).height;
                n10 += 2 * object.ipady + object.insets.top + object.insets.bottom;
            }
            if (object.gridwidth <= 1) {
                nArray2[n7] = Math.max(nArray2[n7], n9);
            }
            if (object.gridheight > 1) continue;
            nArray[n8] = Math.max(nArray[n8], n10);
        }
        n3 = this.hGap;
        int n11 = this.vGap;
        object = new double[n5];
        double[] dArray = new double[n4];
        double d = 0.0;
        double d2 = 0.0;
        for (n2 = 0; n2 < n5; ++n2) {
            n3 += nArray2[n2] + this.hGap;
            object[n2] = this.getDoubleProperty("weightx" + n2);
            d += object[n2];
        }
        for (n2 = 0; n2 < n4; ++n2) {
            n11 += nArray[n2] + this.vGap;
            dArray[n2] = this.getDoubleProperty("weighty" + n2);
            d2 += dArray[n2];
        }
        if (n == 0) {
            int n12;
            int n13;
            int n14;
            Dimension dimension2 = container.getSize();
            Insets insets = container.getInsets();
            dimension2.width -= insets.left + insets.right;
            dimension2.height -= insets.top + insets.bottom;
            int n15 = dimension2.width - n3;
            int n16 = dimension2.height - n11;
            int n17 = insets.left;
            int n18 = insets.top;
            if (d == 0.0) {
                switch (this.horizontalAlignment) {
                    case 11: {
                        n15 = 0;
                        break;
                    }
                    case 10: {
                        n17 += n15 / 2;
                        n15 = 0;
                        break;
                    }
                    case 12: {
                        n17 += n15;
                        n15 = 0;
                        break;
                    }
                    case 1: {
                        d = n5;
                        for (n14 = 0; n14 < n5; ++n14) {
                            object[n14] = 1.0;
                        }
                        break;
                    }
                }
            }
            if (d2 == 0.0) {
                switch (this.verticalAlignment) {
                    case 13: {
                        n16 = 0;
                        break;
                    }
                    case 10: {
                        n18 += n16 / 2;
                        n16 = 0;
                        break;
                    }
                    case 14: {
                        n18 += n16;
                        n16 = 0;
                        break;
                    }
                    case 1: {
                        d2 = n4;
                        for (n14 = 0; n14 < n4; ++n14) {
                            dArray[n14] = 1.0;
                        }
                        break;
                    }
                }
            }
            int[] nArray3 = new int[n5];
            int n19 = this.hGap + n17;
            for (int i = 0; i < n5; ++i) {
                nArray3[i] = n19;
                if (n15 > 0) {
                    n13 = (int)Math.round((double)n15 * object[i] / d);
                    int n20 = i;
                    nArray2[n20] = nArray2[n20] + n13;
                    n15 -= n13;
                    d -= object[i];
                }
                n19 += nArray2[i] + this.hGap;
            }
            int[] nArray4 = new int[n4];
            n13 = this.vGap + n18;
            for (n12 = 0; n12 < n4; ++n12) {
                nArray4[n12] = n13;
                if (n16 > 0) {
                    int n21 = (int)Math.round((double)n16 * dArray[n12] / d2);
                    int n22 = n12;
                    nArray[n22] = nArray[n22] + n21;
                    n16 -= n21;
                    d2 -= dArray[n12];
                }
                n13 += nArray[n12] + this.vGap;
            }
            for (n12 = 0; n12 < n6; ++n12) {
                int n23;
                Component component = container.getComponent(n12);
                TableConstraints tableConstraints = this.layoutTable.get(component);
                int n24 = tableConstraints.gridx;
                int n25 = tableConstraints.gridy;
                int n26 = nArray3[n24] + tableConstraints.insets.left;
                int n27 = nArray4[n25] + tableConstraints.insets.top;
                int n28 = nArray2[n24];
                for (n23 = 1; n23 < tableConstraints.gridwidth && n24 + n23 < n5; ++n23) {
                    n28 += nArray2[n24 + n23] + this.hGap;
                }
                n28 -= tableConstraints.insets.left + tableConstraints.insets.right;
                n23 = nArray[n25];
                for (int i = 1; i < tableConstraints.gridheight && n25 + i < n4; ++i) {
                    n23 += nArray[n25 + i] + this.vGap;
                }
                Dimension dimension3 = this.useStrictGridBagModel ? this.getMinimumComponentSize(component) : this.getPreferredComponentSize(component);
                Rectangle rectangle = this.computeCellBounds(new Rectangle(n26, n27, n28, n23 -= tableConstraints.insets.top + tableConstraints.insets.bottom), dimension3, tableConstraints);
                component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else {
            dimension = new Dimension(n3, n11);
        }
        return dimension;
    }

    private void computeLayoutTable(Container container) {
        int[] nArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.nColumns;
        int n4 = container.getComponentCount();
        int n5 = 0;
        this.layoutTable = new HashMap();
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            int n8;
            Component component = container.getComponent(i);
            TableConstraints tableConstraints = this.getConstraints(component);
            if (tableConstraints.gridx != -1) {
                n2 = tableConstraints.gridx;
            }
            if (tableConstraints.gridy != -1) {
                n = tableConstraints.gridy;
            }
            if (this.nRows > 0 && n >= this.nRows) {
                throw new ErrorException("TableLayout: Too many rows specified");
            }
            while (nArray != null && n2 < nArray.length && nArray[n2] > 0) {
                if (n3 <= 0 || ++n2 < n3) continue;
                for (n8 = 0; n8 < nArray.length; ++n8) {
                    if (nArray[n8] <= 0) continue;
                    int n9 = n8;
                    nArray[n9] = nArray[n9] - true;
                }
                ++n;
                n2 = this.getFirstAvailableColumn(nArray);
            }
            tableConstraints.gridx = n2;
            tableConstraints.gridy = n;
            n8 = n5;
            this.setMaxProperty("width" + n2, tableConstraints.width);
            this.setMaxProperty("height" + n, tableConstraints.height);
            this.setMaxProperty("weightx" + n2, tableConstraints.weightx);
            this.setMaxProperty("weighty" + n, tableConstraints.weighty);
            int n10 = 1;
            switch (tableConstraints.gridwidth) {
                case 0: {
                    n8 = 1;
                    if (n3 <= 0) break;
                    n10 = n3 - n2;
                    break;
                }
                case -1: {
                    if (n3 <= 0) {
                        throw new ErrorException("TableLayout: Illegal to use gridwidth=RELATIVE in first row");
                    }
                    n10 = n3 - n2 - 1;
                    n5 = 1;
                    break;
                }
                default: {
                    n10 = tableConstraints.gridwidth;
                    int n11 = n8 = this.nColumns > 0 && n2 + tableConstraints.gridwidth >= this.nColumns ? 1 : 0;
                }
            }
            if (n10 > 1 && nArray != null) {
                for (n7 = n2; n7 < Math.min(nArray.length, n2 + n10); ++n7) {
                    if (nArray[n7] == false) continue;
                    throw new ErrorException("TableLayout: Overlapping cells");
                }
            }
            n7 = 1;
            switch (tableConstraints.gridheight) {
                case 0: {
                    n7 = Integer.MAX_VALUE;
                    break;
                }
                case -1: {
                    throw new ErrorException("TableLayout: Illegal to use gridheight=RELATIVE");
                }
                default: {
                    n7 = tableConstraints.gridheight;
                }
            }
            if (n7 > 1) {
                if (nArray == null) {
                    nArray = new int[n2 + n10];
                } else if (nArray.length < n2 + n10) {
                    int[] nArray2 = nArray;
                    nArray = new int[n2 + n10];
                    System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                }
                for (n6 = n2; n6 < n2 + n10; ++n6) {
                    nArray[n6] = n7;
                }
            }
            tableConstraints.gridwidth = n10;
            tableConstraints.gridheight = n7;
            this.layoutTable.put(component, tableConstraints);
            n2 += n10;
            while (n8 != 0 || n3 > 0 && n2 >= n3) {
                if (n3 <= 0) {
                    n3 = n2;
                }
                if (nArray != null) {
                    for (n6 = 0; n6 < nArray.length; ++n6) {
                        if (nArray[n6] <= 0) continue;
                        int n12 = n6;
                        nArray[n12] = nArray[n12] - 1;
                    }
                }
                ++n;
                n2 = this.getFirstAvailableColumn(nArray);
                n8 = 0;
            }
        }
        if (n3 <= 0) {
            n3 = n2;
        }
        this.setIntProperty("nColumns", n3);
        this.setIntProperty("nRows", n + 1);
    }

    private Rectangle computeCellBounds(Rectangle rectangle, Dimension dimension, TableConstraints tableConstraints) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (tableConstraints.fill == 0 || tableConstraints.fill == 3) {
            n3 = dimension.width;
        }
        if (tableConstraints.fill == 0 || tableConstraints.fill == 2) {
            n4 = dimension.height;
        }
        if (n3 != rectangle.width) {
            switch (tableConstraints.anchor) {
                case 10: 
                case 11: 
                case 15: {
                    n += (rectangle.width - n3) / 2;
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    n += rectangle.width - n3;
                }
            }
        }
        if (n4 != rectangle.height) {
            switch (tableConstraints.anchor) {
                case 10: 
                case 13: 
                case 17: {
                    n2 += (rectangle.height - n4) / 2;
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    n2 += rectangle.height - n4;
                }
            }
        }
        return new Rectangle(n, n2, n3, n4);
    }

    private void setMaxProperty(String string, int n) {
        this.setIntProperty(string, Math.max(n, this.getIntProperty(string)));
    }

    private void setMaxProperty(String string, double d) {
        this.setDoubleProperty(string, Math.max(d, this.getDoubleProperty(string)));
    }

    private void setIntProperty(String string, int n) {
        this.propertyTable.put(string, new Integer(n));
    }

    private int getIntProperty(String string) {
        Object object = this.propertyTable.get(string);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private void setDoubleProperty(String string, double d) {
        this.propertyTable.put(string, new Double(d));
    }

    private double getDoubleProperty(String string) {
        Object object = this.propertyTable.get(string);
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    private int getFirstAvailableColumn(int[] nArray) {
        if (this.useStrictGridBagModel && nArray != null) {
            for (int i = nArray.length; i > 0; --i) {
                if (nArray[i - 1] <= 0) continue;
                return i;
            }
        }
        return 0;
    }
}

