/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.graphics.GCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import stanford.spl.TopCompound;

public class JBECanvas
extends GCanvas {
    private String windowId;
    private TopCompound topCompound;
    private Graphics2D osg;
    private Image offscreenImage;
    private int preferredWidth;
    private int preferredHeight;

    public JBECanvas(String string, int n, int n2) {
        this.windowId = string;
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setOpaque(false);
        this.setLayout(null);
        this.preferredWidth = n;
        this.preferredHeight = n2;
    }

    protected Graphics2D getOSG() {
        return this.osg;
    }

    protected void setTopCompound(TopCompound topCompound) {
        this.topCompound = topCompound;
        topCompound.setCanvas(this);
        topCompound.setParent(this);
    }

    protected TopCompound getTopCompound() {
        return this.topCompound;
    }

    protected void initOffscreenImage() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.offscreenImage = this.createImage(dimension.width, dimension.height);
        this.osg = (Graphics2D)this.offscreenImage.getGraphics();
        this.osg.setColor(this.getBackground());
        this.osg.fillRect(0, 0, dimension.width, dimension.height);
        this.osg.setColor(this.getForeground());
    }

    public String getWindowId() {
        return this.windowId;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    public void clear() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.osg.setColor(Color.WHITE);
        this.osg.fillRect(0, 0, dimension.width, dimension.height);
        this.osg.setColor(Color.BLACK);
        this.repaint();
    }

    public void draw(Shape shape) {
        this.osg.draw(shape);
        this.repaint();
    }

    public void fill(Shape shape) {
        this.osg.fill(shape);
        this.repaint();
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        this.osg.draw(double_);
        this.repaint();
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        this.osg.fill(double_);
        this.osg.draw(double_);
        this.repaint();
    }

    public void drawOval(double d, double d2, double d3, double d4) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(d, d2, d3, d4);
        this.osg.draw(double_);
        this.repaint();
    }

    public void fillOval(double d, double d2, double d3, double d4) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(d, d2, d3, d4);
        this.osg.fill(double_);
        this.osg.draw(double_);
        this.repaint();
    }

    public void drawArc(double d, double d2, double d3, double d4, double d5, double d6) {
        Arc2D.Double double_ = new Arc2D.Double(d, d2, d3, d4, d5, d6, 0);
        this.osg.draw(double_);
        this.repaint();
    }

    public void fillArc(double d, double d2, double d3, double d4, double d5, double d6) {
        Arc2D.Double double_ = new Arc2D.Double(d, d2, d3, d4, d5, d6, 2);
        this.osg.fill(double_);
        this.osg.draw(double_);
        this.repaint();
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        Line2D.Double double_ = new Line2D.Double(d, d2, d3, d4);
        this.osg.draw(double_);
        this.repaint();
    }

    public void setColor(int n) {
        this.osg.setColor(new Color(n));
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.drawImage(this.offscreenImage, 0, 0, this);
        this.topCompound.paint(graphics);
        super.paint(graphics);
    }
}

