/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.gui.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import stanford.spl.JBECanvas;
import stanford.spl.JavaBackEnd;

public class JBEWindow
extends JFrame {
    private JavaBackEnd jbe;
    private JBECanvas canvas;
    private String windowId;
    private JPanel northPanel;
    private JPanel eastPanel;
    private JPanel southPanel;
    private JPanel westPanel;

    public JBEWindow(JavaBackEnd javaBackEnd, String string, String string2, int n, int n2) {
        super(string2);
        this.jbe = javaBackEnd;
        this.windowId = string;
        this.setLayout(new BorderLayout());
        this.canvas = new JBECanvas(string, n, n2);
        this.addWindowListener(this.jbe);
        this.canvas.addComponentListener(this.jbe);
        this.canvas.addMouseListener(this.jbe);
        this.canvas.addMouseMotionListener(this.jbe);
        this.canvas.addKeyListener(this.jbe);
        this.add((Component)this.canvas, "Center");
        this.createSidePanels();
    }

    public JBECanvas getCanvas() {
        return this.canvas;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public void close() {
        WindowEvent windowEvent = new WindowEvent(this, 201);
        this.processWindowEvent(windowEvent);
    }

    public void clear() {
        this.canvas.clear();
        boolean bl = false;
        if (this.northPanel != null) {
            this.northPanel.removeAll();
            bl = true;
        }
        if (this.eastPanel != null) {
            this.eastPanel.removeAll();
            bl = true;
        }
        if (this.southPanel != null) {
            this.southPanel.removeAll();
            bl = true;
        }
        if (this.westPanel != null) {
            this.westPanel.removeAll();
            bl = true;
        }
        if (bl) {
            this.validate();
        }
    }

    public void addToRegion(JComponent jComponent, String string) {
        JPanel jPanel = null;
        if (string.equalsIgnoreCase("NORTH")) {
            jPanel = this.northPanel;
        } else if (string.equalsIgnoreCase("EAST")) {
            jPanel = this.eastPanel;
        } else if (string.equalsIgnoreCase("SOUTH")) {
            jPanel = this.southPanel;
        } else if (string.equalsIgnoreCase("WEST")) {
            jPanel = this.westPanel;
        }
        if (jPanel != null) {
            jPanel.add(jComponent);
            this.validate();
        }
    }

    public void setRegionAlignment(String string, String string2) {
        JPanel jPanel = null;
        if (string.equalsIgnoreCase("NORTH")) {
            jPanel = this.northPanel;
        } else if (string.equalsIgnoreCase("EAST")) {
            jPanel = this.eastPanel;
        } else if (string.equalsIgnoreCase("SOUTH")) {
            jPanel = this.southPanel;
        } else if (string.equalsIgnoreCase("WEST")) {
            jPanel = this.westPanel;
        }
        int n = 10;
        if (string2.equalsIgnoreCase("LEFT")) {
            n = 11;
        } else if (string2.equalsIgnoreCase("RIGHT")) {
            n = 12;
        }
        if (jPanel != null) {
            ((TableLayout)jPanel.getLayout()).setHorizontalAlignment(n);
        }
    }

    private void createSidePanels() {
        this.northPanel = new JPanel();
        this.southPanel = new JPanel();
        this.eastPanel = new JPanel();
        this.westPanel = new JPanel();
        this.northPanel.setLayout(new TableLayout(1, 0, 5, 5));
        this.southPanel.setLayout(new TableLayout(1, 0, 5, 5));
        this.westPanel.setLayout(new TableLayout(0, 1, 5, 5));
        this.eastPanel.setLayout(new TableLayout(0, 1, 5, 5));
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.southPanel, "South");
        this.add((Component)this.eastPanel, "East");
        this.add((Component)this.westPanel, "West");
    }
}

