/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.util.ErrorException;
import acm.util.JTFTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandLineProgramLoader
extends ClassLoader {
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_NameAndType = 12;
    private HashMap<Integer, Integer> classTable;
    private ClassLoader realLoader;
    private String targetName;
    private int superclassOffset;

    public CommandLineProgramLoader(String name) {
        this.targetName = name;
        try {
            Class<?> classLoader = Class.forName("java.lang.ClassLoader");
            Method getSystemClassLoader = classLoader.getMethod("getSystemClassLoader", new Class[0]);
            this.realLoader = (ClassLoader)getSystemClassLoader.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.equals(this.targetName)) {
            InputStream in = this.getResourceAsStream(String.valueOf(name) + ".class");
            this.superclassOffset = this.findSuperclassOffset(in);
            in = this.getResourceAsStream(String.valueOf(name) + ".class");
            byte[] code = this.patchClassData(in);
            return this.defineClass(name, code, 0, code.length);
        }
        return this.realLoader.loadClass(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.realLoader.getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        return this.realLoader.getResource(name);
    }

    private byte[] patchClassData(InputStream in) {
        try {
            int ch;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JTFTools.copyBytes(in, out, 8L);
            int nConstants = in.read() << 8 | in.read();
            out.write(nConstants >> 8);
            out.write(nConstants & 0xFF);
            int index = 1;
            while (index < nConstants) {
                int type = in.read();
                out.write(type);
                if (JTFTools.testDebugOption("constants")) {
                    System.out.println(String.valueOf(index) + ": " + CommandLineProgramLoader.getConstantTypeName(type));
                }
                switch (type) {
                    case 3: {
                        JTFTools.copyBytes(in, out, 4L);
                        break;
                    }
                    case 4: {
                        JTFTools.copyBytes(in, out, 4L);
                        break;
                    }
                    case 5: {
                        JTFTools.copyBytes(in, out, 8L);
                        ++index;
                        break;
                    }
                    case 6: {
                        JTFTools.copyBytes(in, out, 8L);
                        ++index;
                        break;
                    }
                    case 7: {
                        JTFTools.copyBytes(in, out, 2L);
                        break;
                    }
                    case 8: {
                        JTFTools.copyBytes(in, out, 2L);
                        break;
                    }
                    case 9: {
                        JTFTools.copyBytes(in, out, 4L);
                        break;
                    }
                    case 10: {
                        JTFTools.copyBytes(in, out, 4L);
                        break;
                    }
                    case 11: {
                        JTFTools.copyBytes(in, out, 4L);
                        break;
                    }
                    case 12: {
                        JTFTools.copyBytes(in, out, 4L);
                        break;
                    }
                    case 1: {
                        int nChars;
                        if (index == this.superclassOffset) {
                            nChars = in.read() << 8 | in.read();
                            in.skip(nChars);
                            String superclass = "acm/program/CommandLineProgram";
                            nChars = superclass.length();
                            out.write(nChars >> 8);
                            out.write(nChars & 0xFF);
                            int j = 0;
                            while (j < nChars) {
                                out.write((byte)superclass.charAt(j));
                                ++j;
                            }
                            break;
                        }
                        nChars = in.read() << 8 | in.read();
                        out.write(nChars >> 8);
                        out.write(nChars & 0xFF);
                        JTFTools.copyBytes(in, out, nChars);
                    }
                }
                ++index;
            }
            while ((ch = in.read()) != -1) {
                out.write(ch);
            }
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    private int findSuperclassOffset(InputStream in) {
        this.classTable = new HashMap();
        try {
            in.skip(8L);
            int nConstants = in.read() << 8 | in.read();
            nConstants += 2;
            int i = 1;
            while (i < nConstants - 2) {
                int type = in.read();
                switch (type) {
                    case 3: {
                        in.skip(4L);
                        break;
                    }
                    case 4: {
                        in.skip(4L);
                        break;
                    }
                    case 5: {
                        in.skip(8L);
                        ++i;
                        break;
                    }
                    case 6: {
                        in.skip(8L);
                        ++i;
                        break;
                    }
                    case 8: {
                        in.skip(2L);
                        break;
                    }
                    case 9: {
                        in.skip(4L);
                        break;
                    }
                    case 10: {
                        in.skip(4L);
                        break;
                    }
                    case 11: {
                        in.skip(4L);
                        break;
                    }
                    case 12: {
                        in.skip(4L);
                        break;
                    }
                    case 7: {
                        int offset = in.read() << 8 | in.read();
                        this.classTable.put(new Integer(i), new Integer(offset));
                        break;
                    }
                    case 1: {
                        int nChars = in.read() << 8 | in.read();
                        in.skip(nChars);
                    }
                }
                ++i;
            }
            in.skip(4L);
            return this.classTable.get(new Integer(in.read() << 8 | in.read()));
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    private static String getConstantTypeName(int id) {
        switch (id) {
            case 1: {
                return "Utf8";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 6: {
                return "Double";
            }
            case 7: {
                return "Class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Fieldref";
            }
            case 10: {
                return "Methodref";
            }
            case 11: {
                return "InterfaceMethodref";
            }
            case 12: {
                return "NameAndType";
            }
        }
        return "Type[" + id + "]";
    }
}

