#include "intStack.h"
#include "error.h"

IntStack::IntStack() {
    head = nullptr;
}

bool IntStack::isEmpty() {
    return head == nullptr;
}

void IntStack::push(int value) {
    Node* node = new Node;
    // pushing "value"
    node->value = value;

    node->next = head;

    head = node;
}

int IntStack::peek() {
	if (isEmpty()) {
        throw "Error! Trying to peek from empty stack!";
	}
	
	return head->value;
}

int IntStack::pop() {
	if (isEmpty()) {
        throw "Error! Trying to pop from empty stack!";
	}
	
    Node* result = head;
	head = head->next;

	int value = result->value;
	delete result;
	return value;
}

IntStack::~IntStack() {
    while (head != nullptr) {
        Node* next = head->next;
        delete head;
        head = next;
    }
}

