// QueueString.cpp
// Implementation of QueueString class

#include "QueueString.h"

// constructor
QueueString::QueueString(){
    front = nullptr; // no elements yet
    back = nullptr; // no elements yet
}

// destructor
QueueString::~QueueString(){
    // walk through queue and delete all elements
    while (front != nullptr) {
        Node *temp = front->link;
        delete front;
        front = temp;
    }
}

// enqueue onto back of queue
void QueueString::enqueue(string value){
    Node *newNode = new Node;
    newNode->value = value;
    newNode->link = nullptr;
    // special case -- first node
    if (back == nullptr) {
        back = newNode;
        front = newNode;
    } else {
        back->link = newNode; // update previous back
        back = newNode; // set the back to the new node we just created
    }
}


// dequeue from front of queue
string QueueString::dequeue(){
    string toReturn = front->value;
    Node *nextNode = front->link;
    delete front;
    front = nextNode;
    if (front == nullptr) {
        back = nullptr;
    }

    return toReturn;
}

ostream& operator<<(ostream &out, QueueString &q) {
    out << "{";
    Node *curr = q.front;
    while (curr != nullptr) {
        out << curr->value;
        if (curr->link != nullptr) {
            out << ", ";
        }
        curr = curr->link;
    }
    out << "}";
    return out;
}
