// StackString.cpp
// Implementation of StackString class

#include "StackString.h"

// constructor
StackString::StackString(){
    head = nullptr; // no elements yet
}

// destructor
StackString::~StackString(){
    // walk through stack and delete all elements
    while (head != nullptr) {
        Node *temp = head->link;
        delete head;
        head = temp;
    }
}

// push onto stack
void StackString::push(string value){
    Node *newNode = new Node;
    newNode->value = value;
    newNode->link = head;
    head = newNode;
}

// pop from the stack
string StackString::pop(){
    string toReturn = head->value;
    Node *nextNode = head->link;
    delete head;
    head = nextNode;

    return toReturn;
}
