/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.net;

import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import stanford.cs106.gui.Event;
import stanford.cs106.io.IORuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkManager {
    private static final boolean DEBUG = false;
    private static final String IP_SERVICE_URL = "http://www.martystepp.com/critters/ip.php";
    private static String hostName = null;
    private static String ipAddress = null;
    private static String ipAddresses = "";
    private int port;
    private boolean shouldContinue;
    private List<Message> outQueue;
    private Thread sendThread;
    private Thread receiveThread;
    private ServerSocket receiveSrvSock;
    private Event<String[]> receive;
    private Event<Exception> error;

    public static void findIPAddress(ActionListener listener) {
        Thread networkThread = new Thread(new NetworkRunner(listener));
        networkThread.start();
    }

    public static String getHostName() {
        return hostName;
    }

    public static String getIpAddress() {
        return ipAddress;
    }

    public static String getIpAddresses() {
        return ipAddresses;
    }

    public NetworkManager(int port) {
        this.port = port;
        this.shouldContinue = true;
        this.outQueue = Collections.synchronizedList(new LinkedList());
        this.receive = new Event();
        this.error = new Event();
    }

    public Event<? extends Exception> getErrorEvent() {
        return this.error;
    }

    public int getPort() {
        return this.port;
    }

    public Event<String[]> getReceiveEvent() {
        return this.receive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String host, String ... strings) {
        List<Message> list = this.outQueue;
        synchronized (list) {
            Message message = new Message(host, strings);
            this.outQueue.add(message);
        }
    }

    public String sendHttp(String url, Map<String, Object> params) {
        try {
            StringBuilder postData = new StringBuilder();
            for (String key : params.keySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode(key, "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(params.get(key)), "UTF-8"));
            }
            byte[] postDataBytes = postData.toString().getBytes("UTF-8");
            URL uurl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)uurl.openConnection();
            conn.setDoOutput(true);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("charset", "utf-8");
            conn.setRequestProperty("Content-Length", Integer.toString(postDataBytes.length));
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.getOutputStream().write(postDataBytes);
            StringBuilder out = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            int c = ((Reader)in).read();
            while (c != -1) {
                out.append((char)c);
                c = ((Reader)in).read();
            }
            return out.toString();
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    public void stop() {
        this.shouldContinue = false;
        try {
            if (this.receiveSrvSock != null) {
                this.receiveSrvSock.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.sendThread != null) {
            this.sendThread.stop();
            this.sendThread = null;
        }
        if (this.receiveThread != null) {
            this.receiveThread.stop();
            this.receiveThread = null;
        }
    }

    public void start() throws IOException {
        this.shouldContinue = true;
        if (this.sendThread == null) {
            this.sendThread = new Thread(new SendRunnable());
            this.receiveThread = new Thread(new ReceiveRunnable());
        }
        this.sendThread.start();
        this.receiveThread.start();
    }

    private static class Message
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public String host;
        public String[] strings;

        public Message(String host, String[] strings) {
            this.host = host;
            this.strings = strings;
        }

        public String toString() {
            return "Message{host=" + this.host + ", strings=" + Arrays.toString(this.strings) + "}";
        }
    }

    private static class NetworkRunner
    implements Runnable {
        private ActionListener listener;

        public NetworkRunner(ActionListener listener) {
            this.listener = listener;
        }

        public void run() {
            if (ipAddress == null) {
                try {
                    InetAddress localhost = InetAddress.getLocalHost();
                    hostName = localhost.getHostName();
                    ipAddress = localhost.getHostAddress();
                    InetAddress[] inetAddressArray = InetAddress.getAllByName(hostName);
                    int n = inetAddressArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InetAddress addr = inetAddressArray[n2];
                        ipAddresses = String.valueOf(ipAddresses) + " " + addr.getHostAddress();
                        ++n2;
                    }
                    ipAddresses = ipAddresses.trim();
                }
                catch (UnknownHostException e) {
                    hostName = "unknown_host";
                    ipAddresses = "127.0.0.1";
                    ipAddress = "127.0.0.1";
                }
                catch (SecurityException e) {
                    hostName = "unknown_host";
                    ipAddresses = "127.0.0.1";
                    ipAddress = "127.0.0.1";
                }
            }
            try {
                URL ipServiceURL = new URL(NetworkManager.IP_SERVICE_URL);
                Scanner input = new Scanner(ipServiceURL.openStream());
                if (input.hasNextLine()) {
                    ipAddress = input.nextLine().trim();
                    ipAddresses = String.valueOf(ipAddress) + "  (local: " + ipAddresses + ")";
                }
                input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listener.actionPerformed(null);
        }
    }

    private class ReceiveRunnable
    implements Runnable {
        public ReceiveRunnable() throws IOException {
            NetworkManager.this.receiveSrvSock = new ServerSocket(NetworkManager.this.port);
        }

        public void run() {
            try {
                while (NetworkManager.this.shouldContinue) {
                    Socket sock = NetworkManager.this.receiveSrvSock.accept();
                    InputStream stream = sock.getInputStream();
                    ObjectInputStream ois = new ObjectInputStream(stream);
                    String[] strings = (String[])ois.readObject();
                    NetworkManager.this.receive.fire(strings);
                }
            }
            catch (Exception e) {
                NetworkManager.this.error.fire(e);
            }
        }
    }

    private class SendRunnable
    implements Runnable {
        private SendRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (NetworkManager.this.shouldContinue) {
                if (!NetworkManager.this.outQueue.isEmpty()) {
                    List list = NetworkManager.this.outQueue;
                    synchronized (list) {
                        if (!NetworkManager.this.outQueue.isEmpty()) {
                            Message message = (Message)NetworkManager.this.outQueue.remove(0);
                            try {
                                Socket sock = new Socket(message.host, NetworkManager.this.port);
                                OutputStream stream = sock.getOutputStream();
                                ObjectOutputStream oos = new ObjectOutputStream(stream);
                                oos.writeObject(message.strings);
                                sock.close();
                            }
                            catch (IOException e) {
                                NetworkManager.this.error.fire(e);
                            }
                        }
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

